/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bJ\b\u0010\u0016\u001a\u00020\u0000H\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\bJ\u0013\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/vcs/changes/VirtualFileHolder;", "Lcom/intellij/openapi/vcs/changes/FileHolder;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myFiles", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/HashSet;", "files", "", "getFiles", "()Ljava/util/List;", "cleanAll", "", "cleanUnderScope", "scope", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScope;", "addFile", "file", "removeFile", "copy", "containsFile", "", "equals", "other", "", "hashCode", "", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class VirtualFileHolder
implements FileHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final HashSet<VirtualFile> myFiles;

    public VirtualFileHolder(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myFiles = new HashSet();
    }

    @NotNull
    public final List<VirtualFile> getFiles() {
        return CollectionsKt.toList((Iterable)this.myFiles);
    }

    @Override
    public void cleanAll() {
        this.myFiles.clear();
    }

    @Override
    public void cleanUnderScope(@NotNull VcsDirtyScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Companion.cleanScope((Set<VirtualFile>)this.myFiles, scope);
    }

    public final void addFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myFiles.add(file);
    }

    public final void removeFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myFiles.remove(file);
    }

    @Override
    @NotNull
    public VirtualFileHolder copy() {
        VirtualFileHolder virtualFileHolder;
        VirtualFileHolder it = virtualFileHolder = new VirtualFileHolder(this.myProject);
        boolean bl = false;
        it.myFiles.addAll((Collection<VirtualFile>)this.myFiles);
        return virtualFileHolder;
    }

    public final boolean containsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.myFiles.contains(file);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VirtualFileHolder");
        VirtualFileHolder cfr_ignored_0 = (VirtualFileHolder)other;
        return Intrinsics.areEqual(this.myFiles, ((VirtualFileHolder)other).myFiles);
    }

    public int hashCode() {
        return this.myFiles.hashCode();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/VirtualFileHolder$Companion;", "", "<init>", "()V", "cleanScope", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lcom/intellij/openapi/vcs/changes/VcsDirtyScope;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void cleanScope(@NotNull Set<VirtualFile> files, @NotNull VcsDirtyScope scope) {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                    ProgressManager.checkCanceled();
                    if (files.isEmpty()) {
                        return;
                    }
                    if (scope.getRecursivelyDirtyDirectories().size() != 0) break block5;
                    Set dirtyFiles = scope.getDirtyFiles();
                    boolean cleanDroppedFiles = false;
                    for (FilePath dirtyFile : dirtyFiles) {
                        VirtualFile f = dirtyFile.getVirtualFile();
                        if (f != null) {
                            files.remove(f);
                            continue;
                        }
                        cleanDroppedFiles = true;
                    }
                    if (!cleanDroppedFiles) break block6;
                    Iterator<VirtualFile> iterator = files.iterator();
                    while (iterator.hasNext()) {
                        VirtualFile file = iterator.next();
                        if (file.isValid()) continue;
                        iterator.remove();
                    }
                    break block6;
                }
                Iterator<VirtualFile> iterator = files.iterator();
                while (iterator.hasNext()) {
                    VirtualFile file = iterator.next();
                    if (file.isValid() && !scope.belongsTo(VcsUtil.getFilePath((VirtualFile)file))) continue;
                    iterator.remove();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

