/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.util.paths;

import com.intellij.openapi.vcs.util.paths.FilePathHashUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FilePathMapping<T> {
    private final boolean myCaseSensitive;
    private final Map<String, T> myPathMap;
    private final IntSet myPathHashSet = new IntOpenHashSet();

    public FilePathMapping(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.myPathMap = caseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    public void add(@NotNull String filePath, @NotNull T value) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(0);
        }
        if (value == null) {
            FilePathMapping.$$$reportNull$$$0(1);
        }
        String path = UriUtil.trimTrailingSlashes((String)filePath);
        this.myPathMap.put(path, value);
        this.myPathHashSet.add(FilePathHashUtil.pathHashCode(this.myCaseSensitive, path));
    }

    public void remove(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(2);
        }
        String path = UriUtil.trimTrailingSlashes((String)filePath);
        this.myPathMap.remove(path);
    }

    public void clear() {
        this.myPathMap.clear();
        this.myPathHashSet.clear();
    }

    @NotNull
    public Collection<T> values() {
        Collection<T> collection = this.myPathMap.values();
        if (collection == null) {
            FilePathMapping.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean containsKey(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(4);
        }
        String path = UriUtil.trimTrailingSlashes((String)filePath);
        return this.myPathMap.containsKey(path);
    }

    @Nullable
    public T getMappingFor(@NotNull String filePath) {
        if (filePath == null) {
            FilePathMapping.$$$reportNull$$$0(5);
        }
        String path = UriUtil.trimTrailingSlashes((String)filePath);
        int index = 0;
        int prefixHash = 0;
        IntArrayList matches = new IntArrayList();
        if (this.myPathHashSet.contains(prefixHash)) {
            matches.add(index);
        }
        while (index < path.length()) {
            int nextIndex = path.indexOf(47, index + 1);
            if (nextIndex == -1) {
                nextIndex = path.length();
            }
            if (this.myPathHashSet.contains(prefixHash = FilePathHashUtil.pathHashCode(this.myCaseSensitive, path, index, nextIndex, prefixHash))) {
                matches.add(nextIndex);
            }
            index = nextIndex;
        }
        for (int i = matches.size() - 1; i >= 0; --i) {
            String prefix = path.substring(0, matches.getInt(i));
            T root = this.myPathMap.get(prefix);
            if (root == null) continue;
            return root;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/util/paths/FilePathMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/util/paths/FilePathMapping";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

