/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.DelayedCommitMessageProvider;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0004J \u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcsConfiguration", "Lcom/intellij/openapi/vcs/VcsConfiguration;", "getVcsConfiguration", "()Lcom/intellij/openapi/vcs/VcsConfiguration;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getChangeListManager", "()Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "getCommitMessageForList", "", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getCommitMessageFromProvider", "getCommitMessageFromVcs", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "listenForDelayedProviders", "", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractCommitMessagePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCommitMessagePolicy.kt\ncom/intellij/vcs/commit/AbstractCommitMessagePolicy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,55:1\n1863#2,2:56\n37#3,2:58\n*S KotlinDebug\n*F\n+ 1 AbstractCommitMessagePolicy.kt\ncom/intellij/vcs/commit/AbstractCommitMessagePolicy\n*L\n30#1:56,2\n46#1:58,2\n*E\n"})
public abstract class AbstractCommitMessagePolicy {
    @NotNull
    private final Project project;

    public AbstractCommitMessagePolicy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VcsConfiguration getVcsConfiguration() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsConfiguration, (String)"getInstance(...)");
        return vcsConfiguration;
    }

    @NotNull
    protected final ChangeListManager getChangeListManager() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        return changeListManager;
    }

    @Nullable
    protected final String getCommitMessageForList(@NotNull LocalChangeList changeList) {
        String providerMessage;
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        String string = providerMessage = this.getCommitMessageFromProvider(changeList);
        if (string != null) {
            return string;
        }
        String changeListDescription = changeList.getComment();
        CharSequence charSequence = changeListDescription;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return changeListDescription;
        }
        return !changeList.hasDefaultName() ? changeList.getName() : null;
    }

    @Nullable
    protected final String getCommitMessageFromProvider(@NotNull LocalChangeList changeList) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Iterable $this$forEach$iv = CommitMessageProvider.EXTENSION_POINT_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String providerMessage;
            CommitMessageProvider provider = (CommitMessageProvider)element$iv;
            boolean bl = false;
            String string = providerMessage = provider.getCommitMessage(changeList, this.project);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Nullable
    protected final String getCommitMessageFromVcs(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ChangesUtil.processChangesByVcs((Project)this.project, (Collection)changes, (arg_0, arg_1) -> AbstractCommitMessagePolicy.getCommitMessageFromVcs$lambda$1(result2, this, arg_0, arg_1));
        return (String)result2.element;
    }

    private final String getCommitMessageFromVcs(AbstractVcs vcs, List<? extends Change> changes) {
        String string;
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            List list = ChangesUtil.getPaths((Collection)changes);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPaths(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            string = checkinEnvironment.getDefaultMessageFor(thisCollection$iv.toArray(new FilePath[0]));
        } else {
            string = null;
        }
        return string;
    }

    protected final void listenForDelayedProviders(@NotNull CommitMessageUi commitMessageUi, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        CommitMessageProvider.EXTENSION_POINT_NAME.forEachExtensionSafe(arg_0 -> AbstractCommitMessagePolicy.listenForDelayedProviders$lambda$3(arg_0 -> AbstractCommitMessagePolicy.listenForDelayedProviders$lambda$2(this, commitMessageUi, disposable, arg_0), arg_0));
    }

    private static final void getCommitMessageFromVcs$lambda$1(Ref.ObjectRef $result, AbstractCommitMessagePolicy this$0, AbstractVcs vcs, List vcsChanges) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)vcsChanges, (String)"vcsChanges");
        if ($result.element == null) {
            $result.element = this$0.getCommitMessageFromVcs(vcs, vcsChanges);
        }
    }

    private static final Unit listenForDelayedProviders$lambda$2(AbstractCommitMessagePolicy this$0, CommitMessageUi $commitMessageUi, Disposable $disposable, CommitMessageProvider extension) {
        if (extension instanceof DelayedCommitMessageProvider) {
            ((DelayedCommitMessageProvider)extension).init(this$0.project, $commitMessageUi, $disposable);
        }
        return Unit.INSTANCE;
    }

    private static final void listenForDelayedProviders$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

