/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.table.GridTableModel;
import com.intellij.database.run.ui.table.TableResultViewColumn;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.Range;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransposedGridTableModel
extends GridTableModel {
    public TransposedGridTableModel(@NotNull DataGrid grid) {
        if (grid == null) {
            TransposedGridTableModel.$$$reportNull$$$0(0);
        }
        super(grid);
    }

    @Override
    protected int row(int rowIndex, int columnIndex) {
        return columnIndex;
    }

    @Override
    protected int col(int rowIndex, int columnIndex) {
        return rowIndex;
    }

    @Override
    protected Range<Integer> rowRange(ModelIndexSet<GridRow> rows2, ModelIndexSet<GridColumn> columns) {
        return TransposedGridTableModel.getSmallestCoveringRange(columns);
    }

    @Override
    public int getRowCount() {
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumnCount();
    }

    @Override
    public int getColumnCount() {
        return this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount();
    }

    public void columnsAdded(ModelIndexSet<GridColumn> columns) {
        Range<Integer> range = TransposedGridTableModel.getSmallestCoveringRange(columns);
        this.fireTableRowsInserted((Integer)range.getFrom(), (Integer)range.getTo());
    }

    public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
        Range<Integer> range = TransposedGridTableModel.getSmallestCoveringRange(columns);
        this.fireTableRowsDeleted((Integer)range.getFrom(), (Integer)range.getTo());
    }

    public void rowsAdded(ModelIndexSet<GridRow> rows2) {
        this.fireTableStructureChanged();
    }

    public void rowsRemoved(ModelIndexSet<GridRow> rows2) {
        this.fireTableStructureChanged();
    }

    @Override
    @NotNull
    public TableResultViewColumn createColumn(int columnDataIdx) {
        return new TransposedTableResultViewColumn(columnDataIdx);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/table/TransposedGridTableModel", "<init>"));
    }

    protected class TransposedTableResultViewColumn
    extends TableResultViewColumn {
        public TransposedTableResultViewColumn(int modelIndex) {
            super(modelIndex);
        }

        @Override
        public Icon getIcon(boolean forDisplay) {
            return null;
        }

        @Override
        @NlsContexts.ColumnName
        @NotNull
        public String getHeaderValue() {
            String string = GridUtil.getRowName(TransposedGridTableModel.this.myGrid, this.getModelIndex());
            if (string == null) {
                TransposedTableResultViewColumn.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NlsContexts.ColumnName
        @NotNull
        public List<String> getMultilineHeaderValues() {
            List<String> list = List.of(this.getHeaderValue());
            if (list == null) {
                TransposedTableResultViewColumn.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @NlsContexts.Tooltip
        @Nullable
        public String getTooltipText() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/run/ui/table/TransposedGridTableModel$TransposedTableResultViewColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMultilineHeaderValues";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

