/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.impl.json;

import com.intellij.database.run.ui.FormattedModeHandlerKt;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grid/impl/json/JsonMinimizedFormat;", "Lcom/intellij/database/run/ui/MinimizedFormat;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "rules", "", "Lcom/intellij/grid/impl/json/JsonMinimizedFormat$Companion$SpaceRule;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "reformat", "", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "restore", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.grid.impl.json"})
@SourceDebugExtension(value={"SMAP\nJsonMinimizedFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonMinimizedFormat.kt\ncom/intellij/grid/impl/json/JsonMinimizedFormat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1797#2,3:84\n*S KotlinDebug\n*F\n+ 1 JsonMinimizedFormat.kt\ncom/intellij/grid/impl/json/JsonMinimizedFormat\n*L\n34#1:84,3\n*E\n"})
public final class JsonMinimizedFormat
implements MinimizedFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final List<Companion.SpaceRule> rules;
    private static final int ELEMENTS_TO_DETECT_FORMAT = 128;

    public JsonMinimizedFormat(@NotNull Project project, @NotNull Document document, @NotNull List<Companion.SpaceRule> rules) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        this.project = project;
        this.document = document;
        this.rules = rules;
    }

    @Override
    public void reformat(@NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        FormattedModeHandlerKt.runFormatter(this.project, this.document, disableUpdateListener);
    }

    @Override
    @NotNull
    public String restore(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).traverse(TreeTraversal.LEAVES_DFS).filter(arg_0 -> JsonMinimizedFormat.restore$lambda$1(JsonMinimizedFormat::restore$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), (CharSequence)"", null, null, (int)0, null, arg_0 -> JsonMinimizedFormat.restore$lambda$3(this, arg_0), (int)30, null);
    }

    private static final boolean restore$lambda$0(PsiElement it) {
        return !(it instanceof PsiWhiteSpace);
    }

    private static final boolean restore$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence restore$lambda$3(JsonMinimizedFormat this$0, PsiElement it) {
        void $this$fold$iv;
        Iterable iterable = this$0.rules;
        String initial$iv = it.getText();
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void rule;
            Companion.SpaceRule spaceRule = (Companion.SpaceRule)element$iv;
            String text = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)text);
            accumulator$iv = rule.apply(text, PsiTreeUtilKt.getElementType((PsiElement)it));
        }
        String string = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fold(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/grid/impl/json/JsonMinimizedFormat$Companion;", "", "<init>", "()V", "ELEMENTS_TO_DETECT_FORMAT", "", "detect", "Lcom/intellij/grid/impl/json/JsonMinimizedFormat;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "SpaceRule", "intellij.grid.impl.json"})
    @SourceDebugExtension(value={"SMAP\nJsonMinimizedFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonMinimizedFormat.kt\ncom/intellij/grid/impl/json/JsonMinimizedFormat$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1863#2:84\n1863#2,2:85\n1864#2:87\n*S KotlinDebug\n*F\n+ 1 JsonMinimizedFormat.kt\ncom/intellij/grid/impl/json/JsonMinimizedFormat$Companion\n*L\n59#1:84\n60#1:85,2\n59#1:87\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final JsonMinimizedFormat detect(@NotNull Project project, @NotNull Document document) {
            void $this$forEach$iv;
            PsiFile file;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (!((psiFile != null ? psiFile.getLanguage() : null) instanceof JsonLanguage)) {
                return null;
            }
            Object object = new SpaceRule[8];
            IElementType iElementType = JsonElementTypes.COLON;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"COLON");
            object[0] = new SpaceRule(true, iElementType, true);
            IElementType iElementType2 = JsonElementTypes.COLON;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"COLON");
            object[1] = new SpaceRule(false, iElementType2, false);
            IElementType iElementType3 = JsonElementTypes.COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"COMMA");
            object[2] = new SpaceRule(true, iElementType3, true);
            IElementType iElementType4 = JsonElementTypes.COMMA;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"COMMA");
            object[3] = new SpaceRule(false, iElementType4, false);
            IElementType iElementType5 = JsonElementTypes.L_CURLY;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"L_CURLY");
            object[4] = new SpaceRule(true, iElementType5, false);
            IElementType iElementType6 = JsonElementTypes.R_CURLY;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"R_CURLY");
            object[5] = new SpaceRule(false, iElementType6, false);
            IElementType iElementType7 = JsonElementTypes.L_BRACKET;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType7, (String)"L_BRACKET");
            object[6] = new SpaceRule(true, iElementType7, false);
            IElementType iElementType8 = JsonElementTypes.R_BRACKET;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType8, (String)"R_BRACKET");
            object[7] = new SpaceRule(false, iElementType8, false);
            List rules = CollectionsKt.listOf((Object[])object);
            JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).traverse(TreeTraversal.LEAVES_DFS).take(128);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"take(...)");
            object = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement e = (PsiElement)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = rules;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SpaceRule it = (SpaceRule)element$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)e);
                    it.observeElement(e);
                }
            }
            return new JsonMinimizedFormat(project, document, rules);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grid/impl/json/JsonMinimizedFormat$Companion$SpaceRule;", "", "isAfter", "", "elementType", "Lcom/intellij/psi/tree/IElementType;", "default", "<init>", "(ZLcom/intellij/psi/tree/IElementType;Z)V", "spaceCount", "", "noSpaceCount", "observeElement", "", "e", "Lcom/intellij/psi/PsiElement;", "apply", "", "text", "type", "intellij.grid.impl.json"})
        public static final class SpaceRule {
            private final boolean isAfter;
            @NotNull
            private final IElementType elementType;
            private final boolean default;
            private int spaceCount;
            private int noSpaceCount;

            public SpaceRule(boolean isAfter, @NotNull IElementType elementType, boolean bl) {
                Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
                this.isAfter = isAfter;
                this.elementType = elementType;
                this.default = bl;
            }

            public final void observeElement(@NotNull PsiElement e) {
                boolean hasSpace;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)e), (Object)this.elementType)) {
                    return;
                }
                boolean bl = hasSpace = this.isAfter ? e.getNextSibling() instanceof PsiWhiteSpace : e.getPrevSibling() instanceof PsiWhiteSpace;
                if (hasSpace) {
                    int n = this.spaceCount;
                    this.spaceCount = n + 1;
                } else {
                    int n = this.noSpaceCount;
                    this.noSpaceCount = n + 1;
                }
            }

            @NotNull
            public final String apply(@NotNull String text, @Nullable IElementType type) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                if (!Intrinsics.areEqual((Object)type, (Object)this.elementType) || !this.default && this.noSpaceCount == this.spaceCount || this.noSpaceCount > this.spaceCount) {
                    return text;
                }
                return this.isAfter ? text + " " : " " + text;
            }
        }
    }
}

