/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.playwright.js;

import com.intellij.aqua.runners.playwright.js.PlaywrightRunConfiguration;
import com.intellij.aqua.runners.playwright.js.PlaywrightRunSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/aqua/runners/playwright/js/PlaywrightUtil;", "", "<init>", "()V", "PLAYWRIGHT_PACKAGE_NAME", "", "TAG__CONFIG_FILE", "TAG__NODE_INTERPRETER", "TAG__NODE_OPTIONS", "TAG__PLAYWRIGHT_PACKAGE", "TAG__WORKING_DIR", "TAG__CLI_OPTIONS", "PKG_DESCRIPTOR", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPKG_DESCRIPTOR$intellij_aqua_runners_playwright_js", "()Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPlaywrightMainJsFile", "Ljava/nio/file/Path;", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "writeXml", "", "element", "Lorg/jdom/Element;", "settings", "Lcom/intellij/aqua/runners/playwright/js/PlaywrightRunSettings;", "readXml", "checkRunConfiguration", "configuration", "Lcom/intellij/aqua/runners/playwright/js/PlaywrightRunConfiguration;", "intellij.aqua.runners.playwright.js"})
public final class PlaywrightUtil {
    @NotNull
    public static final PlaywrightUtil INSTANCE = new PlaywrightUtil();
    @NotNull
    private static final String PLAYWRIGHT_PACKAGE_NAME = "@playwright/test";
    @NotNull
    private static final String TAG__CONFIG_FILE = "config";
    @NotNull
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    @NotNull
    private static final String TAG__NODE_OPTIONS = "node-options";
    @NotNull
    private static final String TAG__PLAYWRIGHT_PACKAGE = "playwright-package";
    @NotNull
    private static final String TAG__WORKING_DIR = "working-dir";
    @NotNull
    private static final String TAG__CLI_OPTIONS = "cli-options";
    @NotNull
    private static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("@playwright/test");

    private PlaywrightUtil() {
    }

    @NotNull
    public final NodePackageDescriptor getPKG_DESCRIPTOR$intellij_aqua_runners_playwright_js() {
        return PKG_DESCRIPTOR;
    }

    @NotNull
    public final Path getPlaywrightMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessDefaultBinaryNameOfDependency(...)");
        String binaryName = string;
        File file = pkg.findBinFile(binaryName, "./index.mjs");
        if (file != null) {
            File it = file;
            boolean bl = false;
            Path path2 = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }
        Object[] objectArray = new Object[]{pkg.getName()};
        throw new ExecutionException(JavaScriptBundle.message("node.package.cannot.find.bin.file.dialog.message", objectArray));
    }

    public final void writeXml(@NotNull Element element, @NotNull PlaywrightRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFilePath()));
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_OPTIONS, settings.getNodeOptions());
        NodePackage nodePackage = settings.getFrameworkPackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__PLAYWRIGHT_PACKAGE, it.getSystemIndependentPath());
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        if (((CharSequence)settings.getCliOptions()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__CLI_OPTIONS, settings.getCliOptions());
        }
        settings.getEnvData().writeExternal(element);
        settings.getScope().writeExternal(element);
    }

    @NotNull
    public final PlaywrightRunSettings readXml(@NotNull Element element) {
        String string;
        PlaywrightRunSettings.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PlaywrightRunSettings.Builder $this$readXml_u24lambda_u243 = builder2 = new PlaywrightRunSettings.Builder();
        boolean bl = false;
        String string2 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__CONFIG_FILE);
        if (string2 == null) {
            string2 = "";
        }
        $this$readXml_u24lambda_u243.setConfigFilePath(string2);
        $this$readXml_u24lambda_u243.setInterpreterRef(NodeJsInterpreterRef.create(JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_INTERPRETER)));
        String string3 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_OPTIONS);
        if (string3 == null) {
            string3 = "";
        }
        $this$readXml_u24lambda_u243.setNodeOptions(string3);
        String string4 = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__PLAYWRIGHT_PACKAGE);
        if (string4 != null) {
            String it = string4;
            boolean bl2 = false;
            $this$readXml_u24lambda_u243.setFrameworkPackage(PKG_DESCRIPTOR.createPackage(it));
        }
        if ((string = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__WORKING_DIR)) == null) {
            string = "";
        }
        $this$readXml_u24lambda_u243.setWorkingDir(string);
        String string5 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__CLI_OPTIONS);
        if (string5 == null) {
            string5 = "";
        }
        $this$readXml_u24lambda_u243.setCliOptions(string5);
        $this$readXml_u24lambda_u243.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        $this$readXml_u24lambda_u243.setScope(JsTestRunScope.Companion.readExternal(element));
        return builder2.build();
    }

    public final void checkRunConfiguration(@NotNull PlaywrightRunConfiguration configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        PlaywrightRunSettings settings = configuration.getSettings();
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.validatePath(false, "configuration file", settings.getConfigFilePath());
        }
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", settings.getWorkingDir());
        NodeInterpreterUtil.checkForRunConfiguration(settings.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getOrDetectPackage().validateForRunConfiguration(PLAYWRIGHT_PACKAGE_NAME);
        settings.getScope().validateForRunConfiguration(false);
    }
}

