/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.PackageJsonDependency;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchResponse;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageJsonDependenciesVerifier {
    private static final Logger LOG = Logger.getInstance(PackageJsonDependenciesVerifier.class);
    public static final EnumSet<PackageJsonDependency> DEPENDENCIES_TO_VERIFY = EnumSet.of(PackageJsonDependency.dependencies, PackageJsonDependency.devDependencies);
    private final Project myProject;
    private final VirtualFile myPackageJson;

    public PackageJsonDependenciesVerifier(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(0);
        }
        if (packageJson == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPackageJson = packageJson;
    }

    public boolean verify() {
        DepsInstallation installation;
        DepsInstallation depsInstallation = installation = this.myProject.isDisposed() ? new DepsInstallation() : this.collectInstallation();
        if (installation.isIncomplete()) {
            return false;
        }
        try {
            List<PackageVersionRangeMatchResponse> mismatches = PackageVersionRangeMatcher.findMismatches(this.myProject, installation.getRequests());
            return mismatches.isEmpty();
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    @NotNull
    private DepsInstallation collectInstallation() {
        PackageJsonData data = PackageJsonData.getOrCreate(this.myPackageJson);
        DepsInstallation installation = new DepsInstallation();
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(this.myProject, this.myPackageJson);
        for (PackageJsonData.PackageJsonDependencyEntry dependencyEntry : data.getAllDependencyEntries().values()) {
            if (!DEPENDENCIES_TO_VERIFY.contains((Object)dependencyEntry.getDependencyType())) continue;
            String packageName = dependencyEntry.getName();
            String versionRange = dependencyEntry.getVersionRange();
            InstalledPackageVersion installed = finder.findInstalledPackage(packageName);
            if (installed == null) {
                LOG.info("Missing '" + packageName + "' dependency for " + this.myPackageJson.getPath());
                installation.setIncomplete();
                break;
            }
            SemVer version2 = installed.getVersion();
            if (version2 == null) continue;
            installation.addRequest(new PackageVersionRangeMatchRequest(packageName, versionRange, version2.getRawVersion(), this.myPackageJson));
        }
        DepsInstallation depsInstallation = installation;
        if (depsInstallation == null) {
            PackageJsonDependenciesVerifier.$$$reportNull$$$0(2);
        }
        return depsInstallation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonDependenciesVerifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonDependenciesVerifier";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectInstallation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class DepsInstallation {
        private final List<PackageVersionRangeMatchRequest> myRequests = new ArrayList<PackageVersionRangeMatchRequest>();
        private boolean myIncomplete = false;

        private DepsInstallation() {
        }

        void addRequest(@NotNull PackageVersionRangeMatchRequest request2) {
            if (request2 == null) {
                DepsInstallation.$$$reportNull$$$0(0);
            }
            this.myRequests.add(request2);
        }

        void setIncomplete() {
            this.myIncomplete = true;
        }

        @NotNull
        List<PackageVersionRangeMatchRequest> getRequests() {
            List<PackageVersionRangeMatchRequest> list = this.myRequests;
            if (list == null) {
                DepsInstallation.$$$reportNull$$$0(1);
            }
            return list;
        }

        boolean isIncomplete() {
            return this.myIncomplete;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonDependenciesVerifier$DepsInstallation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageJsonDependenciesVerifier$DepsInstallation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequests";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addRequest";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

