/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.nodejs.execution.NodeRunProgramRunner;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.coverage.FileModificationsSettledDownTracker;
import com.intellij.javascript.testing.vitest.VitestConsoleProperties;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunProfileState;
import com.intellij.javascript.testing.vitest.VitestUtil;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageConfig;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageConfigListener;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageProgramRunner;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageRunner;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestCoverageProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "Handler", "intellij.javascript.impl"})
public final class VitestCoverageProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "VitestCoverageProgramRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Coverage", (Object)executorId) && profile instanceof VitestRunConfiguration;
    }

    @NotNull
    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        return (RunnerSettings)new CoverageRunnerData();
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Disposable disposable = Disposer.newDisposable((Disposable)JSDisposable.getInstance(environment.getProject()), (String)"vitest");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listeningForCoverageConfig = disposable;
        Supplier<VitestCoverageConfig> coverageConfigSupplier = Handler.INSTANCE.getCoverageConfigSupplier(environment, listeningForCoverageConfig);
        Promise promise = NodeRunProgramRunner.Companion.execute(state, environment).onSuccess(arg_0 -> VitestCoverageProgramRunner.execute$lambda$0(listeningForCoverageConfig, state, environment, coverageConfigSupplier, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    private static final void execute$lambda$0(Disposable $listeningForCoverageConfig, RunProfileState $state, ExecutionEnvironment $environment, Supplier $coverageConfigSupplier, RunContentDescriptor descriptor) {
        if (descriptor != null) {
            Disposer.register((Disposable)((Disposable)descriptor), (Disposable)$listeningForCoverageConfig);
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler != null) {
                Intrinsics.checkNotNull((Object)$state, (String)"null cannot be cast to non-null type com.intellij.javascript.testing.vitest.VitestRunProfileState");
                Handler.INSTANCE.doExecute(descriptor, (VitestRunProfileState)$state, $environment, $coverageConfigSupplier, processHandler, NodeTargetRun.Companion.getTargetRun(processHandler));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ>\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ8\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010%\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\u001d\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u000b\u0010-\u001a\u00070\u001b\u00a2\u0006\u0002\b.H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/javascript/testing/vitest/coverage/VitestCoverageProgramRunner$Handler;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getCoverageConfigSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/javascript/testing/vitest/coverage/VitestCoverageConfig;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "listeningForCoverageConfig", "Lcom/intellij/openapi/Disposable;", "doExecute", "", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/javascript/testing/vitest/VitestRunProfileState;", "coverageConfigSupplier", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "getLocalCoverageDirectory", "Ljava/nio/file/Path;", "targetCoverageDirectory", "", "processWithLcovFile", "env", "checkedEnv", "Lcom/intellij/openapi/util/CheckedDisposable;", "lcovFile", "Ljava/io/File;", "processed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "vitestState", "updateCoverageView", "copyFile", "", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "showError", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nVitestCoverageProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestCoverageProgramRunner.kt\ncom/intellij/javascript/testing/vitest/coverage/VitestCoverageProgramRunner$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,238:1\n14#2:239\n*S KotlinDebug\n*F\n+ 1 VitestCoverageProgramRunner.kt\ncom/intellij/javascript/testing/vitest/coverage/VitestCoverageProgramRunner$Handler\n*L\n79#1:239\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();
        @NotNull
        private static final Logger LOG;

        private Handler() {
        }

        @NotNull
        public final Supplier<VitestCoverageConfig> getCoverageConfigSupplier(@NotNull ExecutionEnvironment environment, @NotNull Disposable listeningForCoverageConfig) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)listeningForCoverageConfig, (String)"listeningForCoverageConfig");
            AtomicReference<VitestCoverageConfig> coverageConfigRef = new AtomicReference<VitestCoverageConfig>();
            RunProfile runProfile = WrappingRunConfiguration.unwrapRunProfile((RunProfile)environment.getRunProfile());
            Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"unwrapRunProfile(...)");
            RunProfile thisRunProfile = runProfile;
            environment.getProject().getMessageBus().connect(listeningForCoverageConfig).subscribe(VitestConsoleProperties.Companion.getCOVERAGE_CONFIG_TOPIC(), (Object)new VitestCoverageConfigListener(thisRunProfile, coverageConfigRef){
                final /* synthetic */ RunProfile $thisRunProfile;
                final /* synthetic */ AtomicReference<VitestCoverageConfig> $coverageConfigRef;
                {
                    this.$thisRunProfile = $thisRunProfile;
                    this.$coverageConfigRef = $coverageConfigRef;
                }

                public void onVitestConfigReceived(VitestRunConfiguration configuration, VitestCoverageConfig vitestCoverageConfig) {
                    Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                    Intrinsics.checkNotNullParameter((Object)vitestCoverageConfig, (String)"vitestCoverageConfig");
                    if (configuration == this.$thisRunProfile) {
                        this.$coverageConfigRef.set(vitestCoverageConfig);
                    }
                }
            });
            return () -> Handler.getCoverageConfigSupplier$lambda$0(coverageConfigRef);
        }

        public final void doExecute(@NotNull RunContentDescriptor descriptor, @NotNull VitestRunProfileState state, @NotNull ExecutionEnvironment environment, @NotNull Supplier<VitestCoverageConfig> coverageConfigSupplier, @NotNull ProcessHandler processHandler, @NotNull NodeTargetRun targetRun) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter(coverageConfigSupplier, (String)"coverageConfigSupplier");
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            AtomicBoolean testingRunning = new AtomicBoolean(false);
            ExecutionConsole executionConsole = descriptor.getExecutionConsole();
            Intrinsics.checkNotNull((Object)executionConsole, (String)"null cannot be cast to non-null type com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView");
            SMTRunnerConsoleView consoleView = (SMTRunnerConsoleView)executionConsole;
            TestConsoleProperties testConsoleProperties = consoleView.getProperties();
            Intrinsics.checkNotNull((Object)testConsoleProperties, (String)"null cannot be cast to non-null type com.intellij.javascript.testing.vitest.VitestConsoleProperties");
            VitestConsoleProperties consoleProperties = (VitestConsoleProperties)testConsoleProperties;
            AtomicLong prevTestRunCoverageFileLastModified = new AtomicLong(-1L);
            consoleView.getResultsViewer().addEventsListener(new TestResultsViewer.EventsListener(testingRunning, processHandler, consoleProperties, coverageConfigSupplier, environment, targetRun, prevTestRunCoverageFileLastModified, state){
                final /* synthetic */ AtomicBoolean $testingRunning;
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ VitestConsoleProperties $consoleProperties;
                final /* synthetic */ Supplier<VitestCoverageConfig> $coverageConfigSupplier;
                final /* synthetic */ ExecutionEnvironment $environment;
                final /* synthetic */ NodeTargetRun $targetRun;
                final /* synthetic */ AtomicLong $prevTestRunCoverageFileLastModified;
                final /* synthetic */ VitestRunProfileState $state;
                {
                    this.$testingRunning = $testingRunning;
                    this.$processHandler = $processHandler;
                    this.$consoleProperties = $consoleProperties;
                    this.$coverageConfigSupplier = $coverageConfigSupplier;
                    this.$environment = $environment;
                    this.$targetRun = $targetRun;
                    this.$prevTestRunCoverageFileLastModified = $prevTestRunCoverageFileLastModified;
                    this.$state = $state;
                }

                public void onTestingStarted(TestResultsViewer sender) {
                    Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
                    this.$testingRunning.set(true);
                }

                public void onTestingFinished(TestResultsViewer sender) {
                    Path path2;
                    Set<String> foundMissingDependencies;
                    Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
                    this.$testingRunning.set(false);
                    if (this.$processHandler.isProcessTerminated() && ((foundMissingDependencies = this.$consoleProperties.getTextModifier().getFoundMissingDependencies()).contains("@vitest/coverage-c8") || foundMissingDependencies.contains("@vitest/coverage-istanbul"))) {
                        return;
                    }
                    VitestCoverageConfig coverageConfig = this.$coverageConfigSupplier.get();
                    if (coverageConfig == null) {
                        Project project = this.$environment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        String string = JavaScriptBundle.message("vitest.coverage.directory.not.found.notification.content", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Handler.access$showError(Handler.INSTANCE, project, string);
                        Handler.access$getLOG$p().warn("Cannot find coverageDirectory option from Vitest configuration");
                        return;
                    }
                    try {
                        path2 = Handler.INSTANCE.getLocalCoverageDirectory(this.$targetRun, coverageConfig.getRemoteCoverageDirectory());
                    }
                    catch (IOException e) {
                        Project project = this.$environment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        Object[] objectArray = new Object[]{coverageConfig.getRemoteCoverageDirectory()};
                        String string = JavaScriptBundle.message("vitest.coverage.cannot.find.lcov.info.notification.content", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        Handler.access$showError(Handler.INSTANCE, project, string);
                        Handler.access$getLOG$p().warn("Cannot find coverageDirectory " + coverageConfig.getRemoteCoverageDirectory(), (Throwable)e);
                        return;
                    }
                    Path coverageDirectory = path2;
                    File lcovFile = new File(coverageDirectory.toFile(), "lcov.info");
                    AtomicBoolean processedWithLcovFile = new AtomicBoolean(false);
                    CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((String)"environment");
                    Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
                    CheckedDisposable checkedEnvironment = checkedDisposable;
                    Disposer.register((Disposable)((Disposable)this.$environment), (Disposable)((Disposable)checkedEnvironment));
                    FileModificationsSettledDownTracker tracker = new FileModificationsSettledDownTracker(lcovFile.toString(), 50, 150, 10, 300, this.$prevTestRunCoverageFileLastModified.get(), () -> doExecute.1.onTestingFinished$lambda$0(this.$environment, checkedEnvironment, this.$testingRunning), () -> doExecute.1.onTestingFinished$lambda$1(this.$prevTestRunCoverageFileLastModified, lcovFile, this.$environment, checkedEnvironment, processedWithLcovFile, this.$state, this.$targetRun));
                    if (checkedEnvironment.isDisposed()) {
                        Handler.access$getLOG$p().warn("Already disposed " + this.$environment);
                        return;
                    }
                    this.$processHandler.addProcessListener((ProcessListener)new ProcessAdapter(this.$environment, checkedEnvironment, lcovFile, processedWithLcovFile, this.$state, this.$targetRun, tracker){
                        final /* synthetic */ ExecutionEnvironment $environment;
                        final /* synthetic */ CheckedDisposable $checkedEnvironment;
                        final /* synthetic */ File $lcovFile;
                        final /* synthetic */ AtomicBoolean $processedWithLcovFile;
                        final /* synthetic */ VitestRunProfileState $state;
                        final /* synthetic */ NodeTargetRun $targetRun;
                        final /* synthetic */ FileModificationsSettledDownTracker $tracker;
                        {
                            this.$environment = $environment;
                            this.$checkedEnvironment = $checkedEnvironment;
                            this.$lcovFile = $lcovFile;
                            this.$processedWithLcovFile = $processedWithLcovFile;
                            this.$state = $state;
                            this.$targetRun = $targetRun;
                            this.$tracker = $tracker;
                        }

                        public void processTerminated(ProcessEvent event) {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Handler.access$processWithLcovFile(Handler.INSTANCE, this.$environment, this.$checkedEnvironment, this.$lcovFile, this.$processedWithLcovFile, this.$state, this.$targetRun);
                            this.$tracker.stop();
                        }
                    }, (Disposable)this.$environment);
                    if (this.$processHandler.isProcessTerminated()) {
                        Handler.access$processWithLcovFile(Handler.INSTANCE, this.$environment, checkedEnvironment, lcovFile, processedWithLcovFile, this.$state, this.$targetRun);
                        tracker.stop();
                    }
                }

                private static final boolean onTestingFinished$lambda$0(ExecutionEnvironment $environment, CheckedDisposable $checkedEnvironment, AtomicBoolean $testingRunning) {
                    return !$environment.getProject().isDisposed() && !$checkedEnvironment.isDisposed() && !$testingRunning.get();
                }

                private static final void onTestingFinished$lambda$1(AtomicLong $prevTestRunCoverageFileLastModified, File $lcovFile, ExecutionEnvironment $environment, CheckedDisposable $checkedEnvironment, AtomicBoolean $processedWithLcovFile, VitestRunProfileState $state, NodeTargetRun $targetRun) {
                    $prevTestRunCoverageFileLastModified.set($lcovFile.lastModified());
                    Handler.access$processWithLcovFile(Handler.INSTANCE, $environment, $checkedEnvironment, $lcovFile, $processedWithLcovFile, $state, $targetRun);
                }
            });
        }

        @NotNull
        public final Path getLocalCoverageDirectory(@NotNull NodeTargetRun targetRun, @NotNull String targetCoverageDirectory) throws IOException {
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            Intrinsics.checkNotNullParameter((Object)targetCoverageDirectory, (String)"targetCoverageDirectory");
            try {
                Path path2 = Path.of(targetRun.convertTargetPathToLocalPath(targetCoverageDirectory), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
                return path2;
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }

        private final void processWithLcovFile(ExecutionEnvironment env, CheckedDisposable checkedEnv, File lcovFile, AtomicBoolean processed, VitestRunProfileState vitestState, NodeTargetRun targetRun) {
            if (processed.compareAndSet(false, true) && !checkedEnv.isDisposed()) {
                this.updateCoverageView(env, lcovFile, vitestState, targetRun);
            }
        }

        private final void updateCoverageView(ExecutionEnvironment env, File lcovFile, VitestRunProfileState vitestState, NodeTargetRun targetRun) {
            CoverageHelper.resetCoverageSuit((RunConfigurationBase)((RunConfigurationBase)vitestState.getConfiguration()));
            if (this.copyFile(lcovFile, vitestState.getConfiguration())) {
                VitestCoverageRunner vitestCoverageRunner;
                VitestCoverageRunner it = vitestCoverageRunner = VitestCoverageRunner.Companion.findInstance();
                boolean bl = false;
                it.setWorkingDirectory(vitestState.getSettings().getWorkingDir());
                it.setTargetRun(targetRun);
                CoverageDataManager coverageDataManager = CoverageDataManager.getInstance((Project)env.getProject());
                RunConfigurationBase runConfigurationBase = (RunConfigurationBase)vitestState.getConfiguration();
                RunnerSettings runnerSettings = env.getRunnerSettings();
                Intrinsics.checkNotNull((Object)runnerSettings, (String)"null cannot be cast to non-null type com.intellij.coverage.CoverageRunnerData");
                coverageDataManager.processGatheredCoverage(runConfigurationBase, (RunnerSettings)((CoverageRunnerData)runnerSettings));
            }
        }

        private final boolean copyFile(File lcovFile, VitestRunConfiguration configuration) {
            String coverageFilePath = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)((RunConfigurationBase)configuration)).getCoverageFilePath();
            if (coverageFilePath == null) {
                LOG.warn("CoverageEnabledConfiguration.coverageFilePath is null");
                return false;
            }
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (!lcovFile.isFile()) {
                Object[] objectArray = new Object[]{lcovFile.getAbsolutePath()};
                String string = JavaScriptBundle.message("vitest.coverage.cannot.find.lcov.info.notification.content", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showError(project2, string);
                LOG.warn("Cannot find Vitest coverage: " + lcovFile.getAbsolutePath());
                return false;
            }
            try {
                FileUtil.copy((File)lcovFile, (File)new File(coverageFilePath));
                return true;
            }
            catch (IOException e) {
                String string = JavaScriptBundle.message("vitest.coverage.cannot.copy.lcov.info.notification.content", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showError(project2, string);
                LOG.error("Cannot copy " + lcovFile.getAbsolutePath() + " to " + coverageFilePath, (Throwable)e);
                return false;
            }
        }

        private final void showError(Project project, String content) {
            String string = JavaScriptBundle.message("vitest.coverage.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            VitestUtil.INSTANCE.notify(project, string, content, NotificationType.ERROR);
        }

        private static final VitestCoverageConfig getCoverageConfigSupplier$lambda$0(AtomicReference $coverageConfigRef) {
            return (VitestCoverageConfig)$coverageConfigRef.get();
        }

        public static final /* synthetic */ void access$showError(Handler $this, Project project, String content) {
            $this.showError(project, content);
        }

        public static final /* synthetic */ Logger access$getLOG$p() {
            return LOG;
        }

        public static final /* synthetic */ void access$processWithLcovFile(Handler $this, ExecutionEnvironment env, CheckedDisposable checkedEnv, File lcovFile, AtomicBoolean processed, VitestRunProfileState vitestState, NodeTargetRun targetRun) {
            $this.processWithLcovFile(env, checkedEnv, lcovFile, processed, vitestState, targetRun);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(VitestCoverageProgramRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            LOG = logger;
        }
    }
}

