/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config.graph;

import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.graph.Graph;
import com.intellij.util.keyFMap.KeyFMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JSImportGraph
implements Graph<VirtualFile> {
    private int[] myRootNodes;
    private KeyFMap myUserData;
    @NotNull
    private final Int2ObjectMap<IntList> myOutEdges;
    @NotNull
    private final Int2ObjectMap<IntList> myInEdges;
    @NotNull
    private final Int2ObjectMap<VirtualFile> myIds;
    @NotNull
    private final JSFileImports mySearcher;
    private final AtomicBoolean myInitialized;
    private final ReentrantReadWriteLock myLock;

    public JSImportGraph(@NotNull JSFileImports searcher) {
        if (searcher == null) {
            JSImportGraph.$$$reportNull$$$0(0);
        }
        this.myInitialized = new AtomicBoolean(false);
        this.myLock = new ReentrantReadWriteLock();
        this.myOutEdges = new Int2ObjectOpenHashMap();
        this.myInEdges = new Int2ObjectOpenHashMap();
        this.mySearcher = searcher;
        this.myIds = new Int2ObjectOpenHashMap();
        this.myUserData = KeyFMap.EMPTY_MAP;
    }

    public JSImportGraph initialize() {
        this.initialize(false);
        return this;
    }

    public boolean initialize(boolean tryOnly) {
        if (this.myInitialized.get()) {
            return true;
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (tryOnly) {
            if (!writeLock.tryLock()) {
                return false;
            }
            return this.runUnderWriteLock(writeLock);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)writeLock);
        return this.runUnderWriteLock(writeLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putUserData(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            JSImportGraph.$$$reportNull$$$0(1);
        }
        if (value == null) {
            JSImportGraph.$$$reportNull$$$0(2);
        }
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.myUserData = this.myUserData.plus(key, value);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            JSImportGraph.$$$reportNull$$$0(3);
        }
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        try {
            Object object = this.myUserData.get(key);
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean runUnderWriteLock(@NotNull Lock writeLock) {
        if (writeLock == null) {
            JSImportGraph.$$$reportNull$$$0(4);
        }
        this.mySearcher.startCaching();
        try {
            if (this.myInitialized.get()) {
                boolean bl = true;
                return bl;
            }
            JSImportGraph.logStartGraphBuilding(this);
            Set<VirtualFile> files = this.mySearcher.getRootFiles();
            this.myRootNodes = JSImportGraph.extractIdsForFiles(files);
            ProgressManager.checkCanceled();
            this.add(files, true);
            this.myInitialized.set(true);
            JSImportGraph.logEndGraphBuilding(this);
        }
        catch (ProcessCanceledException e) {
            this.resetGraph();
            throw e;
        }
        finally {
            writeLock.unlock();
            this.mySearcher.stopCaching();
        }
        return false;
    }

    private static int[] extractIdsForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            JSImportGraph.$$$reportNull$$$0(5);
        }
        return StreamEx.of(files).mapToInt(JSImportGraph::getFileId).toArray();
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles(this.myRootNodes);
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            JSImportGraph.$$$reportNull$$$0(6);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    @NotNull
    private Set<VirtualFile> copyAsFiles(int @NotNull [] elements) {
        if (elements == null) {
            JSImportGraph.$$$reportNull$$$0(7);
        }
        Set<VirtualFile> set = IntStream.of(elements).mapToObj(el -> this.getNode(el)).collect(Collectors.toSet());
        if (set == null) {
            JSImportGraph.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> copyAsFiles(IntCollection elements) {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(elements.size());
        IntIterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            result2.add(this.getNode(iterator.nextInt()));
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSImportGraph.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Set<VirtualFile> getNodes() {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles((IntCollection)this.myIds.keySet());
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            JSImportGraph.$$$reportNull$$$0(10);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    public boolean isInitialized() {
        return this.myInitialized.get();
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(11);
        }
        return this.containsId(JSImportGraph.getFileId(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int fileId) {
        this.initialize();
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        try {
            boolean bl = this.myIds.containsKey(fileId);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public void recalculateEdges(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(12);
        }
        boolean resetOnCancel = false;
        try {
            JSImportGraph.logStartGraphUpdating(this, file);
            this.validate(file);
            HashSet<VirtualFile> newFiles = new HashSet<VirtualFile>();
            this.mySearcher.getOutFiles(file, newFiles::add);
            resetOnCancel = true;
            this.recalculateEdges(file, newFiles);
            JSImportGraph.logEndGraphUpdating(this);
        }
        catch (ProcessCanceledException e) {
            if (resetOnCancel) {
                this.resetGraph();
            }
            throw e;
        }
        catch (IllegalStateException e) {
            this.resetGraph();
            JSConfigGraphCache.LOG.error((Throwable)e);
        }
    }

    @NotNull
    public Iterator<VirtualFile> getIn(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(13);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file, this.myInEdges).iterator();
        if (iterator == null) {
            JSImportGraph.$$$reportNull$$$0(14);
        }
        return iterator;
    }

    @NotNull
    public Iterator<VirtualFile> getOut(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(15);
        }
        this.initialize();
        Iterator<VirtualFile> iterator = this.getValueUnderLock(file, this.myOutEdges).iterator();
        if (iterator == null) {
            JSImportGraph.$$$reportNull$$$0(16);
        }
        return iterator;
    }

    @NotNull
    public JSFileImports getFileImports() {
        JSFileImports jSFileImports = this.mySearcher;
        if (jSFileImports == null) {
            JSImportGraph.$$$reportNull$$$0(17);
        }
        return jSFileImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Set<VirtualFile> getValueUnderLock(@NotNull VirtualFile file, Int2ObjectMap<IntList> mapFrom) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(18);
        }
        ReentrantReadWriteLock.ReadLock lock = this.myLock.readLock();
        lock.lock();
        Set<VirtualFile> set = this.copyAsFiles((IntCollection)JSImportGraph.getOrDefault(mapFrom, JSImportGraph.getFileId(file)));
        Set<VirtualFile> set2 = set;
        if (set2 == null) {
            JSImportGraph.$$$reportNull$$$0(19);
        }
        return set2;
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateEdges(@NotNull VirtualFile file, @NotNull Set<VirtualFile> newOutFiles) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(20);
        }
        if (newOutFiles == null) {
            JSImportGraph.$$$reportNull$$$0(21);
        }
        int fileId = JSImportGraph.getFileId(file);
        Set<VirtualFile> oldOutFiles = this.getValueUnderLock(file, this.myOutEdges);
        if (oldOutFiles.size() == newOutFiles.size() && newOutFiles.containsAll(oldOutFiles)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.removeOutNodesRecursive(fileId);
            this.add(file, newOutFiles);
            this.removeNotAvailableFromRoots();
            this.myUserData = KeyFMap.EMPTY_MAP;
            assert (this.myIds.size() >= this.myRootNodes.length);
        }
        finally {
            lock.unlock();
        }
    }

    private void add(@NotNull VirtualFile file, @NotNull Collection<VirtualFile> newOutFiles) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(22);
        }
        if (newOutFiles == null) {
            JSImportGraph.$$$reportNull$$$0(23);
        }
        int fileId = JSImportGraph.getFileId(file);
        this.myIds.put(fileId, (Object)file);
        JSImportGraph.addEdges(this.myOutEdges, file, newOutFiles);
        ArrayList<VirtualFile> toCheck = new ArrayList<VirtualFile>(newOutFiles.size());
        newOutFiles.forEach(el -> {
            toCheck.add((VirtualFile)el);
            JSImportGraph.addEdge(this.myInEdges, el, fileId);
        });
        this.add(toCheck, false);
    }

    @NotNull
    private static IntList getOrDefault(@NotNull Int2ObjectMap<IntList> map2, int value) {
        IntList list;
        if (map2 == null) {
            JSImportGraph.$$$reportNull$$$0(24);
        }
        Object object = (list = (IntList)map2.get(value)) == null ? IntLists.EMPTY_LIST : list;
        if (object == null) {
            JSImportGraph.$$$reportNull$$$0(25);
        }
        return object;
    }

    private void removeOutNodesRecursive(int fileId) {
        IntList oldOut = JSImportGraph.getOrDefault(this.myOutEdges, fileId);
        IntListIterator iterator = oldOut.iterator();
        while (iterator.hasNext()) {
            int oldDestination = iterator.nextInt();
            IntList inForOldValue = JSImportGraph.getOrDefault(this.myInEdges, oldDestination);
            int index = inForOldValue.indexOf(fileId);
            if (index == -1) {
                VirtualFile node = this.getNode(oldDestination);
                assert (node != null);
                VirtualFile fileNode = this.getNode(fileId);
                assert (fileNode != null);
                throw new IllegalStateException("Inconsistent graph in: " + fileNode.getPath() + " out: " + node.getPath());
            }
            inForOldValue.removeInt(index);
        }
        if (oldOut.size() > 0) {
            oldOut.clear();
        }
    }

    private void removeNotAvailableFromRoots() {
        Set<VirtualFile> availableFromRoot = this.getAvailableFromRoots();
        if (availableFromRoot.size() == this.myIds.size()) {
            return;
        }
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>(this.copyAsFiles((IntCollection)this.myIds.keySet()));
        toRemove.removeAll(availableFromRoot);
        toRemove.forEach(el -> {
            int elId = JSImportGraph.getFileId(el);
            this.myOutEdges.remove(elId);
            this.myInEdges.remove(elId);
        });
        toRemove.forEach(el -> this.myIds.remove(JSImportGraph.getFileId(el)));
    }

    private void validate(@NotNull VirtualFile file) throws IllegalArgumentException {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(26);
        }
        if (!this.myInitialized.get()) {
            throw new IllegalStateException("The graph is not initialized");
        }
        if (!this.myIds.containsKey(JSImportGraph.getFileId(file))) {
            throw new IllegalStateException("No such node present in the graph");
        }
    }

    @Nullable
    private VirtualFile getNode(int id) {
        return (VirtualFile)this.myIds.get(id);
    }

    @NotNull
    Set<VirtualFile> getAvailableFromRoots() {
        this.initialize();
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(this.copyAsFiles(this.myRootNodes));
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>();
        while (!toCheck.isEmpty()) {
            VirtualFile pop = (VirtualFile)toCheck.pop();
            if (!result2.add(pop)) continue;
            IntList out = JSImportGraph.getOrDefault(this.myOutEdges, JSImportGraph.getFileId(pop));
            IntListIterator iterator = out.iterator();
            while (iterator.hasNext()) {
                int el = iterator.nextInt();
                VirtualFile node = this.getNode(el);
                if (node == null) {
                    throw new IllegalStateException("Graph is inconsistent. Out edges are missing");
                }
                toCheck.add(node);
            }
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSImportGraph.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    private void add(@NotNull Collection<VirtualFile> toProcess, boolean checkCanceled) {
        if (toProcess == null) {
            JSImportGraph.$$$reportNull$$$0(28);
        }
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>(toProcess);
        while (!toCheck.isEmpty()) {
            VirtualFile file;
            int fileId;
            if (checkCanceled) {
                ProgressManager.checkCanceled();
            }
            if (this.myIds.containsKey(fileId = JSImportGraph.getFileId(file = (VirtualFile)toCheck.pop()))) continue;
            this.myIds.put(fileId, (Object)file);
            IntList arr = JSImportGraph.getOrInitMapFor(this.myOutEdges, file);
            this.mySearcher.getOutFiles(file, el -> {
                arr.add(JSImportGraph.getFileId(el));
                toCheck.add((VirtualFile)el);
                JSImportGraph.addEdge(this.myInEdges, el, fileId);
            });
        }
    }

    private static void addEdge(@NotNull Int2ObjectMap<IntList> map2, @NotNull VirtualFile key, int valueId) {
        if (map2 == null) {
            JSImportGraph.$$$reportNull$$$0(29);
        }
        if (key == null) {
            JSImportGraph.$$$reportNull$$$0(30);
        }
        JSImportGraph.getOrInitMapFor(map2, key).add(valueId);
    }

    @NotNull
    private static IntList getOrInitMapFor(@NotNull Int2ObjectMap<IntList> map2, @NotNull VirtualFile key) {
        if (map2 == null) {
            JSImportGraph.$$$reportNull$$$0(31);
        }
        if (key == null) {
            JSImportGraph.$$$reportNull$$$0(32);
        }
        IntList intList = (IntList)map2.computeIfAbsent(JSImportGraph.getFileId(key), __ -> new IntArrayList());
        if (intList == null) {
            JSImportGraph.$$$reportNull$$$0(33);
        }
        return intList;
    }

    private static void addEdges(@NotNull Int2ObjectMap<IntList> map2, @NotNull VirtualFile key, @NotNull Collection<VirtualFile> values) {
        if (map2 == null) {
            JSImportGraph.$$$reportNull$$$0(34);
        }
        if (key == null) {
            JSImportGraph.$$$reportNull$$$0(35);
        }
        if (values == null) {
            JSImportGraph.$$$reportNull$$$0(36);
        }
        IntList arr = JSImportGraph.getOrInitMapFor(map2, key);
        arr.addAll((IntList)IntArrayList.wrap((int[])values.stream().mapToInt(el -> JSImportGraph.getFileId(el)).toArray()));
    }

    private static void logStartGraphBuilding(JSImportGraph graph) {
        if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        JSConfigGraphCache.LOG.trace("Start building tsconfig graph. Hash: " + graph.hashCode() + ", file_imports_hash: " + graph.getFileImports().hashCode() + ",thread:" + Thread.currentThread().getName());
    }

    public void resetGraph() {
        ReentrantReadWriteLock.WriteLock lock = this.myLock.writeLock();
        lock.lock();
        try {
            this.myInitialized.set(false);
            this.myIds.clear();
            this.myOutEdges.clear();
            this.myInEdges.clear();
            this.myRootNodes = null;
            this.myUserData = KeyFMap.EMPTY_MAP;
        }
        finally {
            lock.unlock();
        }
    }

    private static void logEndGraphBuilding(@NotNull JSImportGraph graph) {
        if (graph == null) {
            JSImportGraph.$$$reportNull$$$0(37);
        }
        if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        JSConfigGraphCache.LOG.trace("End building tsconfig graph. TypeScriptFileImports.hash:" + graph.getFileImports().hashCode() + ", thread: " + Thread.currentThread().getName());
        JSImportGraph.logGraphState(graph);
    }

    static void logStartGraphUpdating(@NotNull JSImportGraph graph, @NotNull VirtualFile file) {
        if (graph == null) {
            JSImportGraph.$$$reportNull$$$0(38);
        }
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(39);
        }
        if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        JSConfigGraphCache.LOG.trace("Start updating tsconfig graph. Source: " + file.getName() + ". Nodes: " + graph.getNodes().size() + ", thread: " + Thread.currentThread().getName());
    }

    static void logEndGraphUpdating(@NotNull JSImportGraph graph) {
        if (graph == null) {
            JSImportGraph.$$$reportNull$$$0(40);
        }
        if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
            return;
        }
        JSConfigGraphCache.LOG.trace("End updating tsconfig graph. Thread: " + Thread.currentThread().getName());
        JSImportGraph.logGraphState(graph);
    }

    private static void logGraphState(@NotNull JSImportGraph graph) {
        if (graph == null) {
            JSImportGraph.$$$reportNull$$$0(41);
        }
        JSConfigGraphCache.LOG.trace("Graph (has:" + graph.hashCode() + ") roots: " + graph.getRoots().size() + ", nodes: " + graph.getNodes().size() + ", available from roots: " + graph.getAvailableFromRoots().size());
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportGraph.$$$reportNull$$$0(42);
        }
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)file).getId();
        }
        return file.getPath().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 14, 16, 17, 19, 25, 27, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: 
            case 3: 
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeLock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/config/graph/JSImportGraph";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOutFiles";
                break;
            }
            case 24: 
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 37: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/config/graph/JSImportGraph";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAsFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOut";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileImports";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueUnderLock";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDefault";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableFromRoots";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrInitMapFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runUnderWriteLock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractIdsForFiles";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 25: 
            case 27: 
            case 33: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAsFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 12: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "recalculateEdges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIn";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOut";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getValueUnderLock";
                break;
            }
            case 22: 
            case 23: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOrDefault";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOrInitMapFor";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addEdges";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphBuilding";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logStartGraphUpdating";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "logEndGraphUpdating";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "logGraphState";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFileId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 14, 16, 17, 19, 25, 27, 33 -> new IllegalStateException(string);
        };
    }
}

