/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.evaluation;

import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCodeBasedTypeFactory
extends JSLocalTypeEvaluatorBase {
    private final boolean myIsAstAccessAllowed;
    private final boolean myIsContextualOverload;

    private JSCodeBasedTypeFactory(boolean isAstAccessAllowed, boolean isContextualOverload) {
        this.myIsAstAccessAllowed = isAstAccessAllowed;
        this.myIsContextualOverload = isContextualOverload;
    }

    @Nullable
    public static JSType getCodeBasedType(@Nullable JSExpression expression, boolean isAstAccessAllowed, boolean isContextualOverload) {
        return new JSCodeBasedTypeFactory(isAstAccessAllowed, isContextualOverload).evaluate(expression);
    }

    @NotNull
    public static JSPsiBasedTypeOfType getPsiBasedType(@NotNull PsiElement element, @NotNull JSEvaluateContext context2) {
        if (element == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(1);
        }
        return new JSPsiBasedTypeOfType(element, context2);
    }

    @Override
    @Nullable
    public JSType getPsiBasedExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(2);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Nullable
    private JSType getPsiBasedTypeOfType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(3);
        }
        return this.myIsAstAccessAllowed ? new JSPsiBasedTypeOfType((PsiElement)expression, this.myIsContextualOverload) : null;
    }

    @Override
    @Nullable
    protected JSType getTaggedTemplateExpressionType(@NotNull ES6TaggedTemplateExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(4);
        }
        return this.myIsAstAccessAllowed ? super.getTaggedTemplateExpressionType(expression) : null;
    }

    @Override
    @Nullable
    protected JSType getCallExpressionType(@NotNull JSCallExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(5);
        }
        JSExpression methodExpression = this.myIsAstAccessAllowed ? expression.getMethodExpression() : expression.getStubSafeMethodExpression();
        return this.getCallLikeExpressionType(expression, methodExpression);
    }

    @Override
    @Nullable
    protected JSType getAssignmentExpressionType(@NotNull JSAssignmentExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(6);
        }
        return this.myIsAstAccessAllowed ? super.getAssignmentExpressionType(expression) : null;
    }

    @Override
    @Nullable
    protected JSType getLiteralExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(7);
        }
        return this.myIsAstAccessAllowed ? super.getLiteralExpressionType(expression) : null;
    }

    @Override
    @Nullable
    protected JSType getBinaryExpressionType(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(8);
        }
        return this.myIsAstAccessAllowed ? super.getBinaryExpressionType(expression) : null;
    }

    @Override
    @Nullable
    protected JSType getNewExpressionType(@NotNull JSNewExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(9);
        }
        JSExpression methodExpression = this.myIsAstAccessAllowed ? expression.getMethodExpression() : expression.getStubSafeMethodExpression();
        return this.getNewExpressionType(expression, methodExpression);
    }

    @Override
    @Nullable
    protected JSType getReferenceExpressionType(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(10);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Override
    @Nullable
    protected JSType getIndexedPropertyAccessExpressionType(@NotNull JSIndexedPropertyAccessExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(11);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Override
    @Nullable
    protected JSType getArrayLiteralExpressionType(@NotNull JSArrayLiteralExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(12);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Override
    @Nullable
    protected JSType getConditionalExpressionType(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(13);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Override
    @Nullable
    protected List<JSType> getArrayNestedTypes(@NotNull JSArrayLiteralExpression expression, int limit, boolean widen) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(14);
        }
        return this.myIsAstAccessAllowed ? super.getArrayNestedTypes(expression, limit, widen) : null;
    }

    @Override
    @Nullable
    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(15);
        }
        return this.myIsAstAccessAllowed ? super.evaluateTypeFromInlineComment(expression) : null;
    }

    @Override
    @Nullable
    protected JSType getThisExpressionType(@NotNull JSThisExpression expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(16);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    @Override
    @Nullable
    protected JSType getImportCallType(@NotNull ES6ImportCall expression) {
        if (expression == null) {
            JSCodeBasedTypeFactory.$$$reportNull$$$0(17);
        }
        return this.getPsiBasedTypeOfType(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/evaluation/JSCodeBasedTypeFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiBasedType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiBasedExpressionType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiBasedTypeOfType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTaggedTemplateExpressionType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAssignmentExpressionType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiteralExpressionType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBinaryExpressionType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewExpressionType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceExpressionType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexedPropertyAccessExpressionType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayLiteralExpressionType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getConditionalExpressionType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayNestedTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getThisExpressionType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportCallType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

