/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public final class JSAssignmentUsedAsConditionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSAssignmentUsedAsConditionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSAssignmentUsedAsConditionInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.isCondition(node) && node.getOperationSign() == JSTokenTypes.EQ) {
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.assignment.used.as.condition.text", new Object[0]), new LocalQuickFix[]{new JSReplaceWithComparisonFix((PsiElement)node, false), new JSReplaceWithComparisonFix((PsiElement)node, true)});
                }
            }

            private boolean isCondition(@NotNull JSAssignmentExpression node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = node.getParent()) instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == node) {
                    JSExpression operand;
                    return !(parent instanceof JSWhileStatement) && !(parent instanceof JSDoWhileStatement) || (operand = node.getROperand()) == null || !SideEffectChecker.mayHaveSideEffects(operand);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSAssignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCondition";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JSReplaceWithComparisonFix
    extends LocalQuickFixOnPsiElement {
        private final String myNewOperator;

        protected JSReplaceWithComparisonFix(@NotNull PsiElement element, boolean useTripleEqual) {
            if (element == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myNewOperator = useTripleEqual ? "===" : "==";
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("js.assignment.used.as.condition.fix", this.myNewOperator);
            if (string == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            ASTNode eqNode;
            if (project == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(5);
            }
            if ((eqNode = startElement.getNode().findChildByType(JSTokenTypes.EQ)) != null) {
                TextRange eqRange = eqNode.getTextRange().shiftLeft(startElement.getTextRange().getStartOffset());
                String newText = StringUtil.replaceSubstring((String)startElement.getText(), (TextRange)eqRange, (String)this.myNewOperator);
                JSChangeUtil.replaceExpression((JSExpression)startElement, JSPsiElementFactory.createJSExpression(newText, startElement));
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$JSReplaceWithComparisonFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$JSReplaceWithComparisonFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    }
}

