/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class JSSuspiciousEqPlusInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSuspiciousEqPlusInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSSuspiciousEqPlusInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSAssignmentExpression(node);
                JSExpression rOperand = node.getROperand();
                if (rOperand instanceof JSPrefixExpression && ((JSPrefixExpression)rOperand).getOperationSign() == JSTokenTypes.PLUS) {
                    PsiElement prevSibling = rOperand.getPrevSibling();
                    ASTNode opNode = node.getOperationNode();
                    if (opNode == null) {
                        return;
                    }
                    PsiElement operationNode = opNode.getPsi();
                    if (prevSibling == operationNode) {
                        int eqStart = operationNode.getStartOffsetInParent();
                        holder.registerProblem((PsiElement)node, new TextRange(eqStart, eqStart + 2), JavaScriptBundle.message("js.suspicious.eq.plus.inspection.desc", new Object[0]), new LocalQuickFix[]{new ReplaceWithPlusEqFix(node)});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSSuspiciousEqPlusInspection$1", "visitJSAssignmentExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSSuspiciousEqPlusInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ReplaceWithPlusEqFix
    extends LocalQuickFixOnPsiElement {
        private ReplaceWithPlusEqFix(JSAssignmentExpression node) {
            super((PsiElement)node);
        }

        @NotNull
        public String getText() {
            String string = JavaScriptBundle.message("js.suspicious.eq.plus.fix.name", new Object[0]);
            if (string == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(4);
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)startElement;
            JSPrefixExpression rightOp = (JSPrefixExpression)Objects.requireNonNull(assignment.getROperand());
            rightOp.replace(rightOp.getExpression());
            Objects.requireNonNull(assignment.getOperationNode()).getPsi().replace(JSChangeUtil.createTokenElement((PsiElement)assignment, JSTokenTypes.PLUSEQ, "+="));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.suspicious.eq.plus.fix.name", new Object[0]);
            if (string == null) {
                ReplaceWithPlusEqFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSSuspiciousEqPlusInspection$ReplaceWithPlusEqFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSSuspiciousEqPlusInspection$ReplaceWithPlusEqFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

