/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.ES6AddExportModifierIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6AddExportDefaultIntention
extends JavaScriptIntention
implements LowPriorityAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.intention.add.default.export.family.name", new Object[0]);
        if (string == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element) || !DialectDetector.hasFeature(element, JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return false;
        }
        JSNamedElement namedElement = ES6AddExportDefaultIntention.findParentNamedElement(element, JSNamedElement.class);
        PsiElement module = ES6AddExportModifierIntention.getModuleIfTopLevel(namedElement);
        return ES6AddExportModifierIntention.isAcceptableElement(namedElement) && !(module instanceof TypeScriptModule) && module != null && ES6PsiUtil.findDefaultExport(module) == null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(5);
        }
        ES6AddExportDefaultIntention.invokeOnElement(ES6AddExportDefaultIntention.findParentNamedElement(element, JSAttributeListOwner.class));
    }

    private static void invokeOnElement(@Nullable JSAttributeListOwner namedElement) {
        if (namedElement == null) {
            return;
        }
        if (ES6AddExportDefaultIntention.isConvertibleToExpression(namedElement)) {
            PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)namedElement);
            if (docComment != null) {
                docComment.delete();
            }
            String text = namedElement.getText();
            ES6ExportDefaultAssignment createdExportDefault = ES6AddExportDefaultIntention.createExportDefault(namedElement, text);
            createdExportDefault = (ES6ExportDefaultAssignment)namedElement.replace((PsiElement)createdExportDefault);
            JSDocumentationUtils.moveJSDoc(docComment, (PsiElement)createdExportDefault);
        } else {
            String name = namedElement.getName();
            if (StringUtil.isEmpty((String)name)) {
                return;
            }
            ES6ExportDefaultAssignment createdExportDefault = ES6AddExportDefaultIntention.createExportDefault(namedElement, name + JSCodeStyleSettings.getSemicolon((PsiElement)namedElement));
            JSSourceElement jsSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)namedElement, JSSourceElement.class, (boolean)false);
            assert (jsSourceElement != null);
            jsSourceElement.getParent().addAfter((PsiElement)createdExportDefault, (PsiElement)jsSourceElement);
        }
    }

    private static ES6ExportDefaultAssignment createExportDefault(@NotNull JSAttributeListOwner namedElement, @NotNull String text) {
        if (namedElement == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(6);
        }
        if (text == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(7);
        }
        return JSPsiElementFactory.createJSSourceElement("export default " + text, (PsiElement)namedElement, ES6ExportDefaultAssignment.class);
    }

    private static boolean isConvertibleToExpression(@NotNull JSAttributeListOwner namedElement) {
        if (namedElement == null) {
            ES6AddExportDefaultIntention.$$$reportNull$$$0(8);
        }
        if (TypeScriptPsiUtil.hasAmbientAttribute(namedElement)) {
            return false;
        }
        if (namedElement instanceof TypeScriptEnum || namedElement instanceof TypeScriptTypeAlias) {
            return false;
        }
        return namedElement instanceof JSFunction || namedElement instanceof JSClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6AddExportDefaultIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6AddExportDefaultIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createExportDefault";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleToExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

