/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeWithSignature;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSContextTypeEvaluator {
    @Nullable
    public static JSType getTypeByFunctionParamIndex(JSFunctionType funcType, int paramIndex) {
        JSParameterItem lastParam;
        List<JSParameterTypeDecorator> funcTypeParameters = funcType.getParameters();
        if (paramIndex < funcTypeParameters.size()) {
            return funcTypeParameters.get(paramIndex).getInferredType();
        }
        JSType parameterType = null;
        JSParameterItem jSParameterItem = lastParam = funcTypeParameters.size() > 0 ? funcTypeParameters.get(funcTypeParameters.size() - 1) : null;
        if (lastParam != null && lastParam.isRest()) {
            parameterType = lastParam.getInferredType();
        }
        return parameterType;
    }

    @Nullable
    public static JSType getParameterType(@NotNull JSParameterListElement parameter, @NotNull JSEvaluateContext evaluateContext, JSExpectedTypeKind expectedTypeKind) {
        JSExpression initialization;
        JSParameterItem superParameter;
        JSFunction fun;
        if (parameter == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(1);
        }
        if ((fun = parameter.getDeclaringFunction()) == null) {
            return null;
        }
        if (parameter instanceof JSParameter && (superParameter = JSInheritanceUtil.findMatchedSuperParameter((JSParameter)parameter, fun)) != null) {
            return superParameter.getSimpleType();
        }
        JSType parameterType = null;
        if (fun instanceof JSFunctionExpression || fun instanceof ES6FunctionProperty) {
            PsiElement parentOfFunction = fun.getParent();
            if (parentOfFunction == null) {
                return null;
            }
            JSDestructuringContext destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)parameter, owner -> owner.getParent() instanceof JSParameterList);
            JSInitializerOwner outerParameter = destructuringContext.getOuterElement();
            if (!(outerParameter instanceof JSParameterListElement)) {
                if (!JSContextTypeEvaluator.allowsParameterOutOfParameterList(parameter)) {
                    Logger.getInstance(JSContextTypeEvaluator.class).error("outerParameter not found", new Attachment[]{new Attachment("parameter", parameter.getText()), new Attachment("function", fun.getText())});
                }
                return null;
            }
            int paramIndex = JSContextTypeEvaluator.getParameterIndex((JSParameterListElement)outerParameter);
            if (paramIndex == -1) {
                return null;
            }
            JSType outerParameterType = JSContextTypeEvaluator.getParameterTypeByExpectedTypes(fun, expectedTypeKind, parentOfFunction, paramIndex);
            parameterType = destructuringContext.applyToOuterType(outerParameterType);
        }
        if (parameterType == null && fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall() && parameter instanceof JSParameter && (initialization = JSSymbolUtil.getParameterInitialization((JSParameter)parameter)) != null) {
            parameterType = JSResolveUtil.getExpressionJSType(initialization);
        }
        return parameterType;
    }

    public static int getParameterIndex(@NotNull JSParameterListElement outerParameter) {
        int paramIndex;
        PsiElement parent;
        if (outerParameter == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (!((parent = outerParameter.getParent()) instanceof JSParameterList)) {
            return -1;
        }
        JSParameterListElement[] parameters = ((JSParameterList)parent).getParameters();
        for (paramIndex = 0; paramIndex < parameters.length && parameters[paramIndex] != outerParameter; ++paramIndex) {
        }
        if (paramIndex == parameters.length) {
            if (JSContextTypeEvaluator.allowsParameterOutOfParameterList(outerParameter)) {
                return -1;
            }
            Logger.getInstance(JSContextTypeEvaluator.class).error("paramIndex not found in " + parent.getContainingFile().getVirtualFile().getPath(), new Attachment[]{new Attachment("parameter", outerParameter.getText()), new Attachment("parameterList", parent.getText())});
        }
        return paramIndex;
    }

    private static boolean allowsParameterOutOfParameterList(@NotNull JSParameterListElement parameter) {
        if (parameter == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(3);
        }
        return !DialectDetector.hasFeature((PsiElement)parameter, JSLanguageFeature.DESTRUCTURING_PARAMETERS) || TypeScriptPsiUtil.isThisParameter(parameter);
    }

    @Nullable
    private static JSType getParameterParentExpectedType(@NotNull JSFunction fun, @NotNull JSExpectedTypeKind expectedTypeKind, @Nullable PsiElement parentOfFunction) {
        JSType funcType;
        if (fun == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (expectedTypeKind == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (fun instanceof ES6FunctionProperty) {
            funcType = null;
            if (!fun.isGetProperty() && !fun.isSetProperty() && parentOfFunction instanceof JSObjectLiteralExpression) {
                JSRecordType.PropertySignature propertySignature;
                JSType parentType = JSDialectSpecificHandlersFactory.findExpectedType((JSObjectLiteralExpression)parentOfFunction, expectedTypeKind);
                String name = fun.getName();
                if (parentType != null && name != null && (propertySignature = parentType.asRecordType().findPropertySignature(name)) != null) {
                    funcType = propertySignature.getJSType();
                }
            }
        } else {
            funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSFunctionExpression)fun, expectedTypeKind);
        }
        return funcType;
    }

    @Nullable
    private static JSType getParameterTypeByExpectedTypes(@NotNull JSFunction fun, @NotNull JSExpectedTypeKind expectedTypeKind, @NotNull PsiElement parentOfFunction, int paramIndex) {
        JSExpression methodExpr;
        PsiElement callExpr;
        if (fun == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (expectedTypeKind == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (parentOfFunction == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(8);
        }
        if ((callExpr = parentOfFunction.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression) {
            return JSContextTypeEvaluator.processParameterExpectedTypeInCallExpression(fun, expectedTypeKind, parentOfFunction, paramIndex, callExpr, methodExpr);
        }
        JSType funcType = JSContextTypeEvaluator.getParameterParentExpectedType(fun, expectedTypeKind, parentOfFunction);
        return JSContextTypeEvaluator.getSimpleParameterExpectedType(funcType, parentOfFunction, paramIndex);
    }

    @Nullable
    private static JSType processParameterExpectedTypeInCallExpression(@NotNull JSFunction fun, @NotNull JSExpectedTypeKind expectedTypeKind, @NotNull PsiElement parentOfFunction, int paramIndex, @NotNull PsiElement callExpr, @NotNull JSExpression methodExpr) {
        List<PsiElement> elements;
        PsiElement resolve2;
        JSType contextualExpectedType;
        if (fun == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (expectedTypeKind == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (parentOfFunction == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (callExpr == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (methodExpr == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(13);
        }
        if ((contextualExpectedType = JSContextTypeEvaluator.getParameterParentExpectedType(fun, JSExpectedTypeKind.CONTEXTUAL_FOR_PARAMETER, parentOfFunction)) instanceof TypeScriptOverloadContextualType) {
            List<JSTypeWithSignature> types = ((TypeScriptOverloadContextualType)contextualExpectedType).getTypes();
            JSType parameterType = null;
            for (JSTypeWithSignature type : types) {
                JSType signature;
                JSFunctionItem function = type.getFunction();
                if (function == null || (signature = JSContextTypeEvaluator.getParameterTypeForSignature(fun, expectedTypeKind, paramIndex, callExpr, methodExpr, type.getType(), (PsiElement)function)) == null) continue;
                if (parameterType == null) {
                    parameterType = signature;
                    continue;
                }
                JSType prevParameterType = parameterType;
                if ((parameterType = JSTypeUtils.getCommonType(parameterType, signature, DialectDetector.dialectOfElement(callExpr), false)).isEquivalentTo(prevParameterType, null, false)) continue;
                parameterType = null;
                break;
            }
            if (parameterType != null) {
                return JSContextTypeEvaluator.overrideStrictnessByExpectedType(contextualExpectedType, parameterType);
            }
        }
        if ((resolve2 = JSContextTypeEvaluator.findTypeArgumentsOwner(elements = JSResolveResult.toElements(((JSReferenceExpression)methodExpr).multiResolve(false)))) != null) {
            JSType expectedType;
            JSType jSType = expectedType = contextualExpectedType instanceof TypeScriptOverloadContextualType && expectedTypeKind != JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS ? JSContextTypeEvaluator.getParameterParentExpectedType(fun, expectedTypeKind, parentOfFunction) : contextualExpectedType;
            if (expectedType == null) {
                return null;
            }
            JSType signature = JSContextTypeEvaluator.getParameterTypeForSignature(fun, expectedTypeKind, paramIndex, callExpr, methodExpr, expectedType, resolve2);
            return JSContextTypeEvaluator.overrideStrictnessByExpectedType(expectedType, signature);
        }
        return JSContextTypeEvaluator.getSimpleParameterExpectedType(contextualExpectedType, callExpr, paramIndex);
    }

    @Nullable
    private static JSType overrideStrictnessByExpectedType(@Nullable JSType expected, @Nullable JSType current) {
        if (expected == null || current == null) {
            return current;
        }
        return current.copyWithStrict(expected.isSourceStrict());
    }

    @Nullable
    private static JSType getParameterTypeForSignature(@NotNull JSFunction fun, @NotNull JSExpectedTypeKind expectedTypeKind, int paramIndex, @NotNull PsiElement callExpr, @NotNull JSExpression methodExpr, @NotNull JSType expectedType, @NotNull PsiElement resolve2) {
        if (fun == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (expectedTypeKind == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (callExpr == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (methodExpr == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (expectedType == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (resolve2 == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(19);
        }
        JSType parameterType = null;
        Collection functionTypes = JSTypeUtils.getFunctionType(expectedType, false, callExpr).collect(Collectors.toList());
        List result2 = StreamEx.of((Collection)functionTypes).select(JSFunctionTypeImpl.class).nonNull().toList();
        JSFunctionType functionLike = TypeScriptTypeParser.buildFunctionType(fun).copyWithReturnType(JSAnyType.get(fun));
        int indexOfFunctionExpression = ExpectedTypeEvaluator.getParameterIndexInArgumentList(((JSCallExpression)callExpr).getArgumentList(), fun);
        JSGenericTypesEvaluator.GenericEvaluationContext context2 = new JSGenericTypesEvaluator.GenericEvaluationContext(null, indexOfFunctionExpression, expectedTypeKind);
        JSGenericTypeEvaluationFunction function = JSGenericTypesEvaluator.getEvaluator((PsiElement)methodExpr).getEvaluationFunction((JSCallLikeExpression)callExpr, resolve2, context2);
        for (JSFunctionTypeImpl type : result2) {
            JSType currentType = JSContextTypeEvaluator.getTypeByFunctionParamIndex(type, paramIndex);
            if (currentType == null) continue;
            JSTypeSubstitutor values = JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(functionLike, type, fun);
            currentType = function.evaluate(JSTypeUtils.applyGenericArguments(currentType, values));
            if (expectedTypeKind.isContextual()) {
                JSTypeSubstitutor defaults = JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(resolve2);
                currentType = JSTypeUtils.applyGenericArguments(currentType, defaults);
            }
            if (currentType instanceof JSRestTypeImpl) {
                JSType typeByIndex;
                JSRecordType recordType;
                JSRecordType.PropertySignature signature;
                int offset = type.getParameters().size() - 1;
                JSType nested = ((JSRestTypeImpl)currentType).getIterableType().substitute();
                if (nested instanceof JSTupleType && ((JSTupleType)nested).hasTypeByIndex(paramIndex - offset)) {
                    JSType typeByIndex2 = ((JSTupleType)nested).getTypeByIndex(paramIndex - offset);
                    if (typeByIndex2 != null) {
                        currentType = typeByIndex2;
                    }
                } else if (!JSTypeUtils.isArrayLikeType(nested) && (signature = (recordType = nested.asRecordType()).findPropertySignature(String.valueOf(paramIndex - offset))) != null && (typeByIndex = signature.getJSType()) != null) {
                    currentType = typeByIndex;
                }
            }
            parameterType = parameterType == null ? currentType : JSTypeUtils.getCommonType(parameterType, currentType, DialectDetector.dialectOfElement(callExpr), false);
        }
        return parameterType;
    }

    @Nullable
    private static JSType getSimpleParameterExpectedType(@Nullable JSType expectedType, @NotNull PsiElement context2, int paramIndex) {
        if (context2 == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(20);
        }
        List result2 = ContainerUtil.filterIsInstance(JSTypeUtils.getFunctionType(expectedType, false, context2).toList(), JSFunctionTypeImpl.class);
        JSType parameterType = null;
        for (JSFunctionTypeImpl type : result2) {
            JSType currentType = JSContextTypeEvaluator.getTypeByFunctionParamIndex(type, paramIndex);
            if (currentType instanceof JSRestTypeImpl) {
                JSType iterableType = ((JSRestTypeImpl)currentType).getIterableType();
                int index = paramIndex - type.getParameters().size() + 1;
                currentType = iterableType instanceof JSTupleType && index >= 0 && ((JSTupleType)iterableType).hasTypeByIndex(index) ? ((JSTupleType)iterableType).getTypeByIndex(index) : new JSIterableComponentTypeImpl(iterableType, currentType.getSource());
            }
            parameterType = parameterType == null || currentType == null ? currentType : JSTypeUtils.getCommonType(parameterType, currentType, DialectDetector.dialectOfElement(context2), false);
        }
        return JSContextTypeEvaluator.overrideStrictnessByExpectedType(expectedType, parameterType);
    }

    @Nullable
    private static PsiElement findTypeArgumentsOwner(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(21);
        }
        PsiElement typeOwner = null;
        for (PsiElement element : elements) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(element);
            if (parameters.length <= 0) continue;
            if (typeOwner == null) {
                typeOwner = element;
                continue;
            }
            return null;
        }
        if (typeOwner != null) {
            return typeOwner;
        }
        return elements.size() > 1 ? null : (PsiElement)ContainerUtil.getFirstItem(elements, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerParameter";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeKind";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentOfFunction";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpr";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/JSContextTypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allowsParameterOutOfParameterList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterParentExpectedType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterTypeByExpectedTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processParameterExpectedTypeInCallExpression";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterTypeForSignature";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleParameterExpectedType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeArgumentsOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

