/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluableTypeResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCompleteTypeEvaluationProcessor
implements JSTypeProcessor {
    private static final int QUALIFIER_CHAIN_LENGTH_LIMIT = 100;
    @NotNull
    private final JSEvaluableTypeResolver myEvaluableTypeResolver;
    @NotNull
    private final JSTypeProcessor myBaseProcessor;
    @NotNull
    private final Set<JSEvaluationResultElementKey> myVisitedTypes;

    public JSCompleteTypeEvaluationProcessor(@NotNull JSTypeProcessor baseProcessor, @NotNull JSEvaluableTypeResolver evaluableTypeResolver) {
        if (baseProcessor == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(0);
        }
        if (evaluableTypeResolver == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(1);
        }
        this.myVisitedTypes = new HashSet<JSEvaluationResultElementKey>();
        this.myBaseProcessor = baseProcessor;
        this.myEvaluableTypeResolver = evaluableTypeResolver;
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext context2) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(3);
        }
        if (type instanceof JSEvaluableOnlyType) {
            JSTypeEvaluationResult result2 = this.myEvaluableTypeResolver.unwrapRecursively((JSEvaluableOnlyType)type, false, context2);
            for (JSEvaluationResultElement resultElement : result2.getResults()) {
                JSType resultType = resultElement.getTypeOrAdditionalType();
                if (resultElement.isAdditionalType()) {
                    this.processAdditionalType(resultType, resultElement.getEvaluateContext());
                    continue;
                }
                this.doAddType(resultType, resultElement.getEvaluateContext());
            }
            return;
        }
        this.doAddType(type, context2);
    }

    private void doAddType(@NotNull JSType type, @NotNull JSEvaluateContext context2) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(5);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            type = handler.adjustTypeBeforeAdd(type, context2);
        }
        type = JSCompleteTypeEvaluationProcessor.applyContextAndPrepare(type, context2);
        this.passToBaseProcessor(type, false, context2);
    }

    @Override
    public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(7);
        }
        type = JSCompleteTypeEvaluationProcessor.applyContextAndPrepare(type, evaluateContext);
        this.passToBaseProcessor(type, true, evaluateContext);
    }

    @NotNull
    private static JSType applyContextAndPrepare(@NotNull JSType type, @NotNull JSEvaluateContext context2) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(9);
        }
        if (type instanceof JSEvaluableType && !(type instanceof JSPropertiesOwnerType)) {
            type = type.substitute((PsiElement)context2.targetFile);
        }
        type = JSGenericTypesEvaluator.getEvaluator(type.getSourceElement()).evaluateGenerics(type, context2.getProcessedExpression(), null);
        if (!context2.isStrict() && type.isSourceStrict()) {
            type = JSTypeUtils.copyWithStrictRecursive(type, false);
        }
        if ((type = JSCompositeTypeFactory.optimizeTypeForSubstitute(type, (PsiElement)context2.getProcessedExpression())) instanceof JSFreshObjectLiteralType && context2.getSource() instanceof JSVariable) {
            type = ((JSFreshObjectLiteralType)type).removeFreshness();
        }
        JSType jSType = type = JSCompleteTypeEvaluationProcessor.substituteEvaluableOnlyType(type, context2);
        if (jSType == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @NotNull
    private static JSType substituteEvaluableOnlyType(@NotNull JSType type, @NotNull JSEvaluateContext context2) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(11);
        }
        if (context2 == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(12);
        }
        if (type instanceof JSEvaluableOnlyType && !(type instanceof JSPropertiesOwnerType)) {
            if (!((type = type.substitute((PsiElement)context2.targetFile)) instanceof JSEvaluableOnlyType) || type instanceof JSPropertiesOwnerType) {
                JSType jSType = type;
                if (jSType == null) {
                    JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(13);
                }
                return jSType;
            }
            HashSet<JSType> visited = new HashSet<JSType>();
            while (type instanceof JSEvaluableOnlyType && !(type instanceof JSPropertiesOwnerType) && visited.add(type)) {
                type = type.substitute((PsiElement)context2.targetFile);
            }
            JSType jSType = type instanceof JSEvaluableOnlyType && !(type instanceof JSPropertiesOwnerType) ? JSAnyType.get(type.getSource()) : type;
            if (jSType == null) {
                JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    private void passToBaseProcessor(@NotNull JSType type, boolean isAdditionalType, @NotNull JSEvaluateContext context2) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(17);
        }
        if (!(!(type instanceof JSEvaluableOnlyType) || type instanceof JSPropertiesOwnerType && this.myEvaluableTypeResolver.willPassPropertiesOwnerTypes())) {
            Logger.getInstance(JSCompleteTypeEvaluationProcessor.class).error("Unwrapped type: " + JSEvaluationLogger.toPresentable(type));
        }
        if (this.myVisitedTypes.add(new JSEvaluationResultElementKey(type, isAdditionalType, context2))) {
            if (isAdditionalType) {
                this.myBaseProcessor.processAdditionalType(type, context2);
            } else {
                this.myBaseProcessor.process(type, context2);
            }
        }
    }

    public static void evaluateTypes(@NotNull PsiElement element, @Nullable PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, boolean passPropertiesOwnerTypes) {
        if (element == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(18);
        }
        if (typeProcessor == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(19);
        }
        JSEvaluateContext evaluateContext = new JSEvaluateContext(targetFile);
        if (element instanceof JSExpression) {
            JSExpression expr = (JSExpression)element;
            if (DialectDetector.isJavaScript(element) && JSCompleteTypeEvaluationProcessor.isTooLongQualifierChain(expr)) {
                typeProcessor.process(JSAnyType.getSimple(), evaluateContext);
                return;
            }
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)targetFile, () -> {
            JSPsiBasedTypeOfType type = JSCodeBasedTypeFactory.getPsiBasedType(element, evaluateContext);
            JSCompleteTypeEvaluationProcessor.evaluateTypes(type, evaluateContext, typeProcessor, passPropertiesOwnerTypes);
        });
    }

    public static void evaluateTypes(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, @NotNull JSTypeProcessor typeProcessor, boolean passPropertiesOwnerTypes) {
        if (type == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(20);
        }
        if (evaluateContext == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(21);
        }
        if (typeProcessor == null) {
            JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(22);
        }
        JSCompleteTypeEvaluationProcessor processor = new JSCompleteTypeEvaluationProcessor(typeProcessor, JSEvaluableTypeResolver.complete(passPropertiesOwnerTypes));
        processor.process(type, evaluateContext);
    }

    private static boolean isTooLongQualifierChain(@NotNull JSExpression expression) {
        block3: {
            if (expression == null) {
                JSCompleteTypeEvaluationProcessor.$$$reportNull$$$0(23);
            }
            int count = 0;
            while (true) {
                if (expression instanceof JSCallExpression) {
                    expression = ((JSCallExpression)expression).getMethodExpression();
                    continue;
                }
                if (!(expression instanceof JSQualifiedExpression)) break block3;
                expression = ((JSQualifiedExpression)expression).getQualifier();
                if (++count > 100) break;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluableTypeResolver";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSCompleteTypeEvaluationProcessor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCompleteTypeEvaluationProcessor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyContextAndPrepare";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteEvaluableOnlyType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndPrepare";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "substituteEvaluableOnlyType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "passToBaseProcessor";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isTooLongQualifierChain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static final class JSEvaluationResultElementKey {
        @NotNull
        private final JSResolvedTypeId myTypeId;
        private final boolean myIsAdditionalType;
        @NotNull
        private final JSEvaluateContext myContext;

        private JSEvaluationResultElementKey(@NotNull JSType type, boolean isAdditionalType, @NotNull JSEvaluateContext context2) {
            if (type == null) {
                JSEvaluationResultElementKey.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                JSEvaluationResultElementKey.$$$reportNull$$$0(1);
            }
            this.myTypeId = type.getResolvedTypeId();
            this.myIsAdditionalType = isAdditionalType;
            this.myContext = context2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationResultElementKey key = (JSEvaluationResultElementKey)o;
            return this.myIsAdditionalType == key.myIsAdditionalType && this.myTypeId.equals(key.myTypeId) && this.myContext.equals(key.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myTypeId, this.myIsAdditionalType, this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSCompleteTypeEvaluationProcessor$JSEvaluationResultElementKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

