/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSGistDataOwnerStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.DefaultStubBuilder;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileStubBuilder
extends DefaultStubBuilder {
    public static final Key<Boolean> ALLOW_HANDLERS = Key.create((String)"js.stubs.allow.handlers");
    private static final Logger LOG = Logger.getInstance(JSFileStubBuilder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubElement<?> buildStubTree(@NotNull PsiFile file) {
        StubElement<?> stubTree;
        if (file == null) {
            JSFileStubBuilder.$$$reportNull$$$0(0);
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        JSStubElementImpl.startBuildingStubs();
        try {
            stubTree = this.doBuildStubTree(file);
        }
        finally {
            JSStubElementImpl.finishBuildingStubs();
        }
        if (start > 0L && LOG.isDebugEnabled()) {
            VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                virtualFile = ((LightVirtualFile)virtualFile).getOriginalFile();
            }
            long duration = System.currentTimeMillis() - start;
            long fileSize = virtualFile != null ? virtualFile.getLength() : (long)file.getTextLength();
            LOG.debug(String.format("Building stub for %s took %dms, size %s, speed %s/sec, language: %s", virtualFile != null ? virtualFile.getCanonicalPath() : file.getName(), duration, StringUtil.formatFileSize((long)fileSize), duration > 0L ? StringUtil.formatFileSize((long)(fileSize * 1000L / duration)) : "INF", file.getLanguage()));
        }
        return stubTree;
    }

    private StubElement<?> doBuildStubTree(final @NotNull PsiFile file) {
        StubElement<?> parentStub;
        if (file == null) {
            JSFileStubBuilder.$$$reportNull$$$0(1);
        }
        if (!((parentStub = this.createStubForFile(file)) instanceof JSFileStubImpl) || !(file instanceof JSFile) || ((JSFileStubImpl)parentStub).getCachedData() != null) {
            new JSStubBuildingWalkingVisitor((ASTNode)file.getNode(), parentStub).buildStubTreeAndUpdateLinks();
            return parentStub;
        }
        final JSFileCachedData cachedData = new JSFileCachedData();
        if (JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)file)) {
            file.putUserData(ALLOW_HANDLERS, (Object)false);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)file)) {
            handler.processFile((JSFile)file, cachedData);
        }
        new JSStubBuildingWalkingVisitor((ASTNode)file.getNode(), parentStub){
            final JSFileCachedDataEvaluator evaluator;
            {
                super(root, parentStub);
                this.evaluator = JSDialectSpecificHandlersFactory.forLanguage(file.getLanguage()).newFileCachedDataEvaluator(cachedData);
            }

            protected void visitNode(StubElement parentStub, ASTNode node, boolean immediateParentStubbed) {
                PsiElement element = node.getPsi();
                this.evaluator.startElement(element);
                super.visitNode(parentStub, node, immediateParentStubbed);
                if (node.getLastChildNode() == null) {
                    this.evaluator.finishElement();
                    ASTNode nextNode = this.peekNextElement();
                    if (nextNode != null) {
                        ASTNode nextNodeParent = nextNode.getTreeParent();
                        for (ASTNode currentParent = node.getTreeParent(); currentParent != null && currentParent != nextNodeParent; currentParent = currentParent.getTreeParent()) {
                            this.evaluator.finishElement();
                        }
                    }
                }
            }
        }.buildStubTreeAndUpdateLinks();
        ((JSFileStubImpl)parentStub).setCachedData(cachedData);
        return parentStub;
    }

    @NotNull
    protected StubElement<?> createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            JSFileStubBuilder.$$$reportNull$$$0(2);
        }
        if (file instanceof JSFile) {
            return new JSFileStubImpl((JSFile)file);
        }
        StubElement stubElement = super.createStubForFile(file);
        if (stubElement == null) {
            JSFileStubBuilder.$$$reportNull$$$0(3);
        }
        return stubElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStubForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doBuildStubTree";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStubForFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class JSStubBuildingWalkingVisitor
    extends DefaultStubBuilder.StubBuildingWalkingVisitor {
        @NotNull
        private final JSStubLinksTracker myLinksTracker;

        protected JSStubBuildingWalkingVisitor(ASTNode root, StubElement parentStub) {
            super((DefaultStubBuilder)JSFileStubBuilder.this, root, parentStub);
            this.myLinksTracker = new JSStubLinksTracker();
        }

        protected void buildStubTreeAndUpdateLinks() {
            this.buildStubTree();
            this.myLinksTracker.updateCollectedTypes();
        }

        @Nullable
        protected StubElement<?> createStub(StubElement parentStub, ASTNode node) {
            StubElement stub = super.createStub(parentStub, node);
            this.myLinksTracker.stubCreated(stub, node);
            return stub;
        }
    }

    private static final class JSStubLinksTracker {
        private final Map<StubBasedPsiElement<?>, ObjectStubBase<?>> myMap = new HashMap();
        private final List<JSStubBasedExpressionType> myTypesToProcess = new SmartList();

        private JSStubLinksTracker() {
        }

        void stubCreated(StubElement<?> stub, ASTNode node) {
            Object data;
            PsiElement psi;
            if (stub instanceof ObjectStubBase && (psi = node.getPsi()) instanceof StubBasedPsiElement) {
                this.myMap.put((StubBasedPsiElement)psi, (ObjectStubBase)stub);
            }
            if (stub instanceof JSTypeHolderOwner) {
                this.processTypeHolder(((JSTypeHolderOwner)stub).getJSTypeHolder());
            }
            if (stub instanceof JSQualifiedObjectStubBase) {
                this.processTypeHolder(((JSQualifiedObjectStubBase)stub).myNamespace);
            }
            if (stub instanceof JSGistDataOwnerStub && (data = ((JSGistDataOwnerStub)stub).getGistDataIfProvided()) instanceof JSTypeHolderOwner) {
                this.processTypeHolder(((JSTypeHolderOwner)data).getJSTypeHolder());
            }
        }

        private void processTypeHolder(@Nullable JSStubElementTypeHolder typeHolder) {
            if (typeHolder == null) {
                return;
            }
            JSType type = typeHolder.getJSType();
            if (type == null) {
                return;
            }
            type.accept(new JSRecursiveTypeVisitor(){

                @Override
                public void visitJSType(@NotNull JSType type) {
                    if (type == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type instanceof JSStubBasedExpressionType) {
                        myTypesToProcess.add((JSStubBasedExpressionType)type);
                    }
                    super.visitJSType(type);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/stubs/impl/JSFileStubBuilder$JSStubLinksTracker$1", "visitJSType"));
                }
            });
        }

        void updateCollectedTypes() {
            for (JSStubBasedExpressionType stubBasedExpressionType : this.myTypesToProcess) {
                stubBasedExpressionType.applyMappings(this.myMap);
            }
        }
    }
}

