/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ECMA4FunctionSignatureGenerator
extends JSFunctionSignatureGenerator {
    @Override
    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result2, PsiElement context2) {
        if (info.getScope() == JSFunctionSignatureInfo.Scope.CLASS) {
            JSAttributeList.AccessType type = info.getAccessType();
            result2.append(JSVisibilityUtil.accessTypeToKeyword(type, DialectOptionHolder.ECMA_4)).append(" ");
        }
        if (info.isStatic()) {
            result2.append("static ");
        }
        result2.append("function ").append(info.getFunctionName());
    }

    @Override
    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        if (Strings.areSameInstance((String)((String)parameterWithType.second), (String)"$varArgs$")) {
            String string = "... " + (String)parameterWithType.first;
            if (string == null) {
                ECMA4FunctionSignatureGenerator.$$$reportNull$$$0(0);
            }
            return string;
        }
        String type = (String)parameterWithType.second;
        String string = (String)parameterWithType.first + ":" + (StringUtil.isEmpty((String)type) ? "*" : type);
        if (string == null) {
            ECMA4FunctionSignatureGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result2) {
        result2.append(":");
        result2.append(info.getReturnType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/ECMA4FunctionSignatureGenerator", "getFunctionParameter"));
    }
}

