/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.LoggerBucket;
import com.intellij.lang.javascript.service.MessageStreamLogger;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/javascript/service/MessageStreamLoggerService;", "", "<init>", "()V", "loggers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/lang/javascript/service/LoggerBucket;", "connect", "Lcom/intellij/lang/javascript/service/MessageStreamLogger;", "logFileName", "disconnect", "", "logger", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nMessageStreamLoggerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/MessageStreamLoggerService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n72#2,2:126\n1#3:128\n1#3:129\n14#4:130\n*S KotlinDebug\n*F\n+ 1 MessageStreamLoggerService.kt\ncom/intellij/lang/javascript/service/MessageStreamLoggerService\n*L\n23#1:126,2\n23#1:128\n30#1:130\n*E\n"})
public final class MessageStreamLoggerService {
    @NotNull
    private final ConcurrentHashMap<String, LoggerBucket> loggers = new ConcurrentHashMap();

    @Nullable
    public final MessageStreamLogger connect(@NotNull String logFileName) {
        Intrinsics.checkNotNullParameter((Object)logFileName, (String)"logFileName");
        ConcurrentMap $this$getOrPut$iv = this.loggers;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(logFileName);
        if (object == null) {
            boolean bl = false;
            LoggerBucket default$iv = new LoggerBucket(logFileName);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(logFileName, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        LoggerBucket bucket = (LoggerBucket)object;
        return bucket.connect();
    }

    public final void disconnect(@NotNull MessageStreamLogger logger) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Collection<LoggerBucket> collection = this.loggers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                LoggerBucket it = (LoggerBucket)t;
                boolean bl = false;
                if (!it.containsLogger(logger)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        LoggerBucket bucket = v1;
        if (bucket == null) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(MessageStreamLoggerService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Cannot find a bucket of " + logger.getLogPath$intellij_javascript_impl().getFileName());
            return;
        }
        bucket.disconnect(logger);
    }
}

