/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentationBase;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.xml.XmlElementDescriptor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureItemPresentation
extends JSStructureItemPresentationBase {
    @NotNull
    private final CachedValue<String> myPresentation;
    private static final Map<String, Icon> myQNameToIconMap = new HashMap<String, Icon>();
    private static long myQNameToIconModificationCount;

    public JSStructureItemPresentation(JSStructureViewElementBase jsStructureViewElement) {
        super(jsStructureViewElement);
        PsiElement original = jsStructureViewElement.getElement();
        assert (original != null);
        this.myPresentation = CachedValuesManager.getManager((Project)original.getProject()).createCachedValue(() -> {
            PsiElement psiElement = this.element.getElement();
            return psiElement == null ? CachedValueProvider.Result.create((Object)"*invalid*", (Object[])new Object[]{ModificationTracker.EVER_CHANGED}) : CachedValueProvider.Result.create((Object)this.buildPresentationForElement(psiElement), (Object[])new Object[]{psiElement.getContainingFile()});
        }, false);
    }

    public String getPresentableText() {
        PsiElement psiElement = this.element.getValue();
        if (psiElement == null || !psiElement.isValid()) {
            return "*invalid*";
        }
        return (String)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(psiElement, () -> (String)this.myPresentation.getValue());
    }

    @Nullable
    protected String buildPresentationForElement(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            JSStructureItemPresentation.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof JSObjectLiteralExpression) {
            PsiElement parent2 = psiElement.getParent();
            if (parent2 instanceof JSAssignmentExpression) {
                JSExpression lOperand = ((JSAssignmentExpression)parent2).getLOperand();
                if (!(lOperand instanceof JSDefinitionExpression)) {
                    return null;
                }
                JSExpression expression = ((JSDefinitionExpression)lOperand).getExpression();
                if (expression == null) {
                    return null;
                }
                JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(expression);
                return ns != null && ns.getQualifiedName() != null ? ns.getQualifiedName().getQualifiedName() : expression.getText();
            }
            return null;
        }
        if (psiElement instanceof JSReferenceExpression) {
            JSExpression jsExpression;
            JSReferenceExpression expression = (JSReferenceExpression)psiElement;
            String s = expression.getReferenceName();
            if ("prototype".equals(s) && (jsExpression = expression.getQualifier()) instanceof JSReferenceExpression) {
                s = ((JSReferenceExpression)jsExpression).getReferenceName();
            }
            return s;
        }
        if (!(psiElement instanceof PsiNamedElement)) {
            return psiElement.getText();
        }
        StringBuilder nameBuilder = new StringBuilder();
        if (psiElement instanceof JSPsiNamedElementBase) {
            ES6ComputedName expr;
            String propertyName = JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)psiElement, true);
            if (propertyName != null) {
                nameBuilder.append(propertyName);
            } else if (psiElement instanceof JSComputedPropertyNameOwner && (expr = ((JSComputedPropertyNameOwner)psiElement).getComputedPropertyName()) != null) {
                return expr.getText();
            }
        } else {
            String elementName = ((PsiNamedElement)psiElement).getName();
            if (elementName != null) {
                nameBuilder.append(elementName);
            }
        }
        if (psiElement instanceof JSProperty) {
            psiElement = ((JSProperty)psiElement).tryGetFunctionInitializer();
        }
        boolean function = false;
        if (psiElement instanceof JSClass) {
            if (nameBuilder.length() == 0) {
                nameBuilder.append(JSFormatUtil.getAnonymousName(psiElement));
            }
        } else if (psiElement instanceof JSFunctionItem) {
            if (nameBuilder.length() == 0) {
                nameBuilder.append(JSFormatUtil.getAnonymousName(psiElement));
            }
            nameBuilder.append(JSFormatUtil.buildFunctionSignaturePresentation((JSFunctionItem)psiElement));
        } else if (psiElement instanceof JSImplicitElement && ((JSImplicitElement)psiElement).getType().isFunction()) {
            function = true;
        } else if (psiElement instanceof JSVariable) {
            JSFormatUtil.appendTypeAfter(psiElement, 8193, nameBuilder, ((JSVariable)psiElement).getJSType());
        }
        if (nameBuilder.length() == 0 && psiElement != null && (parent = psiElement.getParent()) instanceof JSAssignmentExpression) {
            JSExpression lExpression = ((JSAssignmentExpression)parent).getLOperand();
            if (!(lExpression instanceof JSDefinitionExpression)) {
                return null;
            }
            JSExpression lOperand = ((JSDefinitionExpression)lExpression).getExpression();
            JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(lOperand);
            if (ns == null) {
                return null;
            }
            PsiElement element = ns.getSource().getSourceElement();
            return element instanceof JSReferenceExpression ? ((JSReferenceExpression)element).getReferenceName() : (lOperand != null ? lOperand.getText() : null);
        }
        if (nameBuilder.length() > 0 && psiElement instanceof JSDefinitionExpression && ((JSDefinitionExpression)psiElement).getInitializerOrStub() instanceof JSFunction || function) {
            nameBuilder.append("()");
        }
        return nameBuilder.toString();
    }

    public Icon getIcon(boolean open) {
        Icon icon;
        int flags = 3;
        PsiElement psiElement = this.element.getValue();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof JSImplicitElement) {
            return ((ItemPresentation)psiElement).getIcon(open);
        }
        if (psiElement instanceof JSParameter) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Field);
        }
        if (psiElement instanceof JSReferenceExpression) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
        }
        if (psiElement instanceof XmlAttributeValue && (icon = JSStructureItemPresentation.getIcon((XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class))) != null) {
            return icon;
        }
        if (psiElement instanceof JSFunctionItem) {
            boolean isProperty;
            boolean bl = isProperty = ((JSFunctionItem)psiElement).isGetProperty() || ((JSFunctionItem)psiElement).isSetProperty();
            if (isProperty) {
                boolean hasSetProperty = false;
                boolean hasGetProperty = false;
                for (PsiElement e : this.element.getAllElements()) {
                    hasSetProperty |= e instanceof JSFunctionItem && ((JSFunctionItem)e).isSetProperty();
                    hasGetProperty |= e instanceof JSFunctionItem && ((JSFunctionItem)e).isGetProperty();
                }
                if (hasGetProperty && hasSetProperty) {
                    JSFunctionItem jsFunction = (JSFunctionItem)psiElement;
                    Icon initialIcon = jsFunction.getJSContext() == JSContext.STATIC ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
                    JSVisibilityUtil.PresentableAccessModifier modifier = JSVisibilityUtil.getPresentableAccessModifier(jsFunction);
                    if (modifier == null) {
                        return initialIcon;
                    }
                    return ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)initialIcon, (Icon)modifier.getIcon());
                }
            }
        }
        return psiElement.getIcon(flags);
    }

    @Nullable
    public static Icon getIcon(XmlTag tag) {
        Icon icon;
        if (tag == null || !FlexSupportLoader.isFlexMxmFile(tag.getContainingFile())) {
            return null;
        }
        long count = tag.getManager().getModificationTracker().getModificationCount();
        String tagName = tag.getName();
        if (myQNameToIconModificationCount == count) {
            icon = myQNameToIconMap.get(tagName);
            if (icon != null) {
                return icon;
            }
            if (myQNameToIconMap.containsKey(tagName)) {
                return null;
            }
        } else {
            myQNameToIconMap.clear();
            myQNameToIconModificationCount = count;
        }
        icon = JSStructureItemPresentation.findIcon(tag);
        myQNameToIconMap.put(tagName, icon);
        return icon;
    }

    private static Icon findIcon(XmlTag tag) {
        XmlElementDescriptor descriptor;
        JSAttributeNameValuePair pair;
        JSAttribute[] attrs;
        JSAttributeList attributeList;
        JSClass aClass = JSResolveUtil.getClassFromTagNameInMxml(tag.getFirstChild());
        if (aClass != null && (attributeList = aClass.getAttributeList()) != null && (attrs = attributeList.getAttributesByName("IconFile")).length > 0 && (pair = attrs[0].getValueByName(null)) != null) {
            String s = pair.getSimpleValue();
            VirtualFile file = aClass.getContainingFile().getVirtualFile();
            if (file != null) {
                VirtualFile child;
                VirtualFile parent = file.getParent();
                VirtualFile virtualFile = child = parent != null && s != null ? parent.findChild(s) : null;
                if (child != null) {
                    return new ImageIcon(child.getPath());
                }
            }
        }
        if ((descriptor = tag.getDescriptor()) instanceof IconProvider && aClass != null) {
            return ((IconProvider)descriptor).getIcon((PsiElement)aClass, 0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/structureView/JSStructureItemPresentation", "buildPresentationForElement"));
    }
}

