/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReturnStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSReturnStatementStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSReturnStatementElementType
extends JSStubElementType<JSReturnStatementStub, JSReturnStatement> {
    public JSReturnStatementElementType() {
        super("RETURN_STATEMENT");
    }

    @NotNull
    public JSReturnStatementStub createStub(@NotNull JSReturnStatement psi, StubElement parentStub) {
        if (psi == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(0);
        }
        return new JSReturnStatementStubImpl(psi, parentStub);
    }

    @Override
    @Nullable
    public PsiElement construct(@NotNull ASTNode node) {
        if (node == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(1);
        }
        return new JSReturnStatementImpl(node);
    }

    @NotNull
    public JSReturnStatementStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(2);
        }
        return new JSReturnStatementStubImpl(dataStream, parentStub);
    }

    public boolean shouldCreateStub(ASTNode node) {
        Language language = JSTreeUtil.getLanguage(node);
        if (!this.isAcceptableLanguage(language)) {
            return false;
        }
        ASTNode expressionNode = JSReturnStatementImpl.getExpressionNode(node);
        return expressionNode != null && (expressionNode.getElementType() == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(expressionNode.getElementType()) || JSReturnStatementElementType.isIIFE(expressionNode));
    }

    public boolean isAcceptableLanguage(Language language) {
        if (!(language instanceof JSLanguageDialect)) {
            return false;
        }
        return !((JSLanguageDialect)language).getOptionHolder().isECMA4;
    }

    private static boolean isIIFE(@NotNull ASTNode expressionNode) {
        if (expressionNode == null) {
            JSReturnStatementElementType.$$$reportNull$$$0(3);
        }
        if (expressionNode.getElementType() != JSStubElementTypes.CALL_EXPRESSION) {
            return false;
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression(expressionNode);
        while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            methodExpression = JSParenthesizedExpressionImpl.getInnerExpression(methodExpression);
        }
        return methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/types/JSReturnStatementElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "construct";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isIIFE";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

