/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructureBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.StatusText;
import icons.JavaScriptLanguageIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLanguageServiceToolWindowManager
extends JSLanguageServiceToolWindowManager {
    private final Project myProject;
    private final TypeScriptCompilerSettings mySettings;
    @Nullable
    private volatile TypeScriptServiceStructureBuilder.StructurePanel myStructurePanel;

    public static AnAction createShowSettingsAction() {
        return new AnAction(JavaScriptBundle.message("typescript.compiler.notification.editor.configure", new Object[0]), null, AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"settings.typescriptcompiler", (String)"");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$1", "actionPerformed"));
            }
        };
    }

    TypeScriptLanguageServiceToolWindowManager(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        super(project, "TypeScript", "reference.tool.windows.typescript", JavaScriptLanguageIcons.Typescript.TypeScript_Compiler, (NotNullLazyValue<AnAction[]>)NotNullLazyValue.createValue(() -> AnAction.EMPTY_ARRAY));
        this.myProject = project;
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
    }

    @Override
    @NotNull
    protected ConsoleViewImpl createConsole() {
        return new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false){

            public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
                if (s == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (contentType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!TypeScriptLanguageServiceToolWindowManager.this.myProject.isOpen() || TypeScriptLanguageServiceToolWindowManager.this.myProject.isDisposed()) {
                    return;
                }
                super.print(TypeScriptLanguageServiceToolWindowManager.this.trimMessageToPrint(s), ConsoleViewContentType.NORMAL_OUTPUT);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contentType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$2";
                objectArray[2] = "print";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public String trimMessageToPrint(@NotNull String s) {
        int defaultLength;
        if (s == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        int n = defaultLength = JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled() ? 2000 : 150;
        if (((String)s).length() > defaultLength) {
            s = ((String)s).substring(0, defaultLength) + "...(truncated)\n";
        }
        String string = s;
        if (string == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected AnAction @Nullable [] getConsoleActions() {
        AnAction[] anActionArray;
        Object[] actions = super.getConsoleActions();
        AnAction showStructure = new AnAction(JavaScriptBundle.message("action.show.structure.text", new Object[0]), null, AllIcons.Actions.PreviewDetails){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ToolWindow window;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((window = TypeScriptLanguageServiceToolWindowManager.this.myToolWindow) != null) {
                    TypeScriptServiceStructureBuilder.StructurePanel panel = TypeScriptLanguageServiceToolWindowManager.this.getOrCreateStructurePanel(window);
                    if (panel == null) {
                        return;
                    }
                    ContentManager manager = window.getContentManager();
                    for (Content content : manager.getContents()) {
                        String name = panel.getName();
                        if (!name.equals(content.getDisplayName())) continue;
                        manager.setSelectedContent(content);
                        panel.refresh();
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$3", "actionPerformed"));
            }
        };
        if (actions == null) {
            AnAction[] anActionArray2 = new AnAction[1];
            anActionArray = anActionArray2;
            anActionArray2[0] = showStructure;
        } else {
            anActionArray = (AnAction[])ArrayUtil.append((Object[])actions, (Object)showStructure);
        }
        return anActionArray;
    }

    @Override
    protected AnAction[] getErrorPanelRightActions(boolean all) {
        if (all) {
            return super.getErrorPanelRightActions(true);
        }
        String showErrorsText = JavaScriptBundle.message("javascript.language.service.default.project.errors", new Object[0]);
        ToggleAction showErrors = new ToggleAction(showErrorsText, showErrorsText, AllIcons.General.ProjectTab){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return TypeScriptLanguageServiceToolWindowManager.this.mySettings.isShowAllProjectErrors();
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    4.$$$reportNull$$$0(1);
                }
                return actionUpdateThread;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(2);
                }
                TypeScriptLanguageServiceToolWindowManager.this.setState(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        return new AnAction[]{showErrors};
    }

    void setState(boolean state) {
        this.mySettings.setShowAllProjectErrors(state);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        NewErrorTreeViewPanel panel = this.getCurrentErrorTreeViewPanel();
        if (panel != null) {
            this.updateCurrentErrorsEmptyText(panel);
        }
    }

    @Override
    @NotNull
    protected String getProjectErrorsTitle() {
        String string = JavaScriptBundle.message("tab.title.compile.errors", new Object[0]);
        if (string == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            TypeScriptLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        StatusText text = panel.getEmptyText();
        if (!this.mySettings.useService()) {
            text.clear();
            text.setText(JavaScriptBundle.message("javascript.language.service.tracking.disabled", new Object[0]));
            return;
        }
        if (!this.mySettings.isShowAllProjectErrors() && this.hasActiveConsoles()) {
            text.clear();
            text.setText(JavaScriptBundle.message("status.text.no.errors.in.current.file", new Object[0]));
            text.appendText(JavaScriptBundle.message("status.text.javascript.language.service.default.project.errors", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadingAssertions.assertEventDispatchThread();
                    TypeScriptLanguageServiceToolWindowManager.this.setState(true);
                }
            });
            return;
        }
        super.updateCurrentErrorsEmptyText(panel);
    }

    @Override
    public boolean needActivateProgressPanel() {
        return true;
    }

    @Override
    protected void initDefaultPanels(@Nullable ToolWindow toolWindow) {
        super.initDefaultPanels(toolWindow);
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            this.getOrCreateStructurePanel(toolWindow);
        }
    }

    @Nullable
    private TypeScriptServiceStructureBuilder.StructurePanel getOrCreateStructurePanel(@Nullable ToolWindow toolWindow) {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            return panel;
        }
        if (toolWindow != null) {
            this.myStructurePanel = panel = TypeScriptServiceStructureBuilder.registerStructureContent(this.myProject, toolWindow, this.myHelpId);
        }
        return panel;
    }

    @Override
    protected void createCurrentTreeViewPanel() {
        if (TypeScriptCompilerSettings.isTypeScriptToolWindowEnable()) {
            super.createCurrentTreeViewPanel();
        }
    }

    @Override
    public synchronized void resetToolWindow() {
        TypeScriptServiceStructureBuilder.StructurePanel panel = this.myStructurePanel;
        if (panel != null) {
            Disposer.dispose((Disposable)panel);
            this.myStructurePanel = null;
        }
        super.resetToolWindow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceToolWindowManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "trimMessageToPrint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trimMessageToPrint";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

