/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.GithubDownloadUtil;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0006\u0017\u0018\u0019\u001a\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "myCache", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache;", "getTemplates", "", "", "version", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "myCacheSubdir", "myDownloadRetryIntervalMs", "", "myDownloadedFile", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "getDownloadedPath", "Ljava/nio/file/Path;", "DownloadedFile", "DownloadStatus", "SuccessfullyDownloaded", "VersionNotFound", "DownloadFailed", "Companion", "intellij.javascript.impl"})
public final class DiagnosticTemplatesEnProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final DiagnosticTemplatesMemoryCache myCache;
    @NotNull
    private final String myCacheSubdir;
    private final int myDownloadRetryIntervalMs;
    @Nullable
    private volatile DownloadedFile myDownloadedFile;

    public DiagnosticTemplatesEnProvider(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
        this.myCache = new DiagnosticTemplatesMemoryCache((Function1<? super Path, ? extends Sequence<Pair<Integer, String>>>)((Function1)DiagnosticTemplatesEnProvider::myCache$lambda$0));
        this.myCacheSubdir = "typescript-diag-message-parser";
        this.myDownloadRetryIntervalMs = 20000;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @RequiresBackgroundThread
    @NotNull
    public final List<String> getTemplates(@NotNull String version2, @NotNull DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)getCriteria, (String)"getCriteria");
        Path file = this.getDownloadedPath(version2);
        return file != null ? this.myCache.getTemplates(file, getCriteria) : CollectionsKt.emptyList();
    }

    private final Path getDownloadedPath(String version2) {
        DownloadedFile downloadedFile;
        DownloadedFile downloadedFile2 = downloadedFile = this.myDownloadedFile;
        if (Intrinsics.areEqual((Object)(downloadedFile2 != null ? downloadedFile2.getVersion() : null), (Object)version2)) {
            DownloadStatus downloadStatus = downloadedFile.getStatus();
            if (downloadStatus instanceof SuccessfullyDownloaded) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isRegularFile(((SuccessfullyDownloaded)downloadedFile.getStatus()).getFile(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    return ((SuccessfullyDownloaded)downloadedFile.getStatus()).getFile();
                }
            } else {
                if (downloadStatus instanceof VersionNotFound) {
                    return null;
                }
                if (downloadStatus instanceof DownloadFailed) {
                    long retryAt = ((DownloadFailed)downloadedFile.getStatus()).getWhenMs() + (long)this.myDownloadRetryIntervalMs;
                    if (retryAt > System.currentTimeMillis()) {
                        return null;
                    }
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        String[] stringArray = new String[]{this.myCacheSubdir, "diagnosticMessages-en-" + version2 + ".json"};
        Path downloadedPath = Paths.get(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNull((Object)downloadedPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(downloadedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.myDownloadedFile = new DownloadedFile(version2, new SuccessfullyDownloaded(downloadedPath));
            return downloadedPath;
        }
        return (Path)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this, version2, downloadedPath, null){
            int label;
            final /* synthetic */ DiagnosticTemplatesEnProvider this$0;
            final /* synthetic */ String $version;
            final /* synthetic */ Path $downloadedPath;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                this.$downloadedPath = $downloadedPath;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.async$default((CoroutineScope)this.this$0.getCs(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Path>, Object>(this.this$0, this.$version, this.$downloadedPath, null){
                            int label;
                            final /* synthetic */ DiagnosticTemplatesEnProvider this$0;
                            final /* synthetic */ String $version;
                            final /* synthetic */ Path $downloadedPath;
                            {
                                this.this$0 = $receiver;
                                this.$version = $version;
                                this.$downloadedPath = $downloadedPath;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            Object object2 = DiagnosticTemplatesEnProvider.Companion;
                                            Path path2 = this.$downloadedPath;
                                            String string = this.$version;
                                            Companion companion = object2;
                                            synchronized (companion) {
                                                boolean bl = false;
                                                Intrinsics.checkNotNull((Object)path2);
                                                LinkOption[] linkOptionArray = new LinkOption[]{};
                                                if (!Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                                                    GithubDownloadUtil.downloadAtomically(null, (String)StringsKt.replace$default((String)Registry.Companion.stringValue("ts.highlightCodeInErrorTooltips.diagnosticMessages.url"), (String)"${version}", (String)string, (boolean)false, (int)4, null), (File)path2.toFile(), (String)"microsoft", (String)"TypeScript");
                                                }
                                                Unit unit = Unit.INSTANCE;
                                            }
                                            object2 = this.$downloadedPath;
                                            Intrinsics.checkNotNull((Object)object2);
                                            DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, new SuccessfullyDownloaded((Path)object2)));
                                            return this.$downloadedPath;
                                        }
                                        catch (IOException e) {
                                            Throwable throwable = e.getCause();
                                            HttpRequests.HttpStatusException httpStatusException = throwable instanceof HttpRequests.HttpStatusException ? (HttpRequests.HttpStatusException)throwable : null;
                                            boolean bl = httpStatusException != null ? httpStatusException.getStatusCode() == 404 : false;
                                            if (bl) {
                                                DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, VersionNotFound.INSTANCE));
                                            } else {
                                                DiagnosticTemplatesEnProvider.access$setMyDownloadedFile$p(this.this$0, new DownloadedFile(this.$version, new DownloadFailed(System.currentTimeMillis())));
                                            }
                                            return null;
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null).await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Path> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Sequence myCache$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.getCodeToTemplate(it);
    }

    public static final /* synthetic */ void access$setMyDownloadedFile$p(DiagnosticTemplatesEnProvider $this, DownloadedFile downloadedFile) {
        $this.myDownloadedFile = downloadedFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$Companion;", "", "<init>", "()V", "getCodeToTemplate", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "", "", "file", "Ljava/nio/file/Path;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Sequence<Pair<Integer, String>> getCodeToTemplate(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Pair<? extends Integer, ? extends String>>, Continuation<? super Unit>, Object>(file, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Path $file;
                {
                    this.$file = $file;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block11: {
                        var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        block0 : switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$sequence = (SequenceScope)this.L$0;
                                root = JsonParser.parseReader((Reader)Files.newBufferedReader(this.$file));
                                if (!root.isJsonObject()) {
                                    Logger.getInstance(DiagnosticTemplatesEnProvider.class).error("Not json object: " + this.$file);
                                    return Unit.INSTANCE;
                                }
                                var4_5 = root.getAsJsonObject().entrySet().iterator();
lbl11:
                                // 4 sources

                                while (var4_5.hasNext()) {
                                    var5_6 = (Map.Entry)var4_5.next();
                                    Intrinsics.checkNotNull((Object)var5_6);
                                    jsonKey = (String)var5_6.getKey();
                                    jsonVal = (JsonElement)var5_6.getValue();
                                    if (!jsonVal.isJsonObject() || !jsonVal.getAsJsonObject().has("code") || !jsonVal.getAsJsonObject().get("code").isJsonPrimitive()) break block0;
                                    if (jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive() == null) ** GOTO lbl31
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$1 = false;
                                    if (it.isNumber()) ** GOTO lbl-1000
                                    if (it.isString()) {
                                        v0 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAsString(...)");
                                        ** if (StringsKt.toIntOrNull((String)v0) == null) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = true;
                                        ** GOTO lbl29
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = false;
                                    }
lbl29:
                                    // 2 sources

                                    v2 = v1;
                                    ** GOTO lbl32
lbl31:
                                    // 1 sources

                                    v2 = false;
lbl32:
                                    // 2 sources

                                    if (!v2) break block0;
                                    it = jsonVal.getAsJsonObject().get("code").getAsJsonPrimitive();
                                    var11_13 = $this$sequence;
                                    $i$a$-let-DiagnosticTemplatesEnProvider$Companion$getCodeToTemplate$1$2 = false;
                                    if (it.isNumber()) {
                                        v3 = it.getAsInt();
                                    } else {
                                        v4 = it.getAsString();
                                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getAsString(...)");
                                        v3 = Integer.parseInt(v4);
                                    }
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var4_5;
                                    this.label = 1;
                                    v5 = var11_13.yield((Object)TuplesKt.to((Object)Boxing.boxInt((int)v3), (Object)jsonKey), (Continuation)this);
                                    if (v5 != var12_2) continue;
                                    return var12_2;
                                }
                                break block11;
                            }
                            case 1: {
                                var4_5 = (Iterator<E>)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v5 = $result;
                                ** GOTO lbl11
                            }
                        }
                        Logger.getInstance(DiagnosticTemplatesEnProvider.class).error("In " + this.$file + " unexpected json value=" + jsonVal + " with key=" + jsonKey);
                        ** GOTO lbl11
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super Pair<Integer, String>> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "whenMs", "", "<init>", "(J)V", "getWhenMs", "()J", "intellij.javascript.impl"})
    private static final class DownloadFailed
    extends DownloadStatus {
        private final long whenMs;

        public DownloadFailed(long whenMs) {
            super(null);
            this.whenMs = whenMs;
        }

        public final long getWhenMs() {
            return this.whenMs;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "", "<init>", "()V", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadFailed;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "intellij.javascript.impl"})
    private static abstract class DownloadStatus {
        private DownloadStatus() {
        }

        public /* synthetic */ DownloadStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadedFile;", "", "version", "", "status", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;)V", "getVersion", "()Ljava/lang/String;", "getStatus", "()Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "intellij.javascript.impl"})
    private static final class DownloadedFile {
        @NotNull
        private final String version;
        @NotNull
        private final DownloadStatus status;

        public DownloadedFile(@NotNull String version2, @NotNull DownloadStatus status) {
            Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            this.version = version2;
            this.status = status;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final DownloadStatus getStatus() {
            return this.status;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$SuccessfullyDownloaded;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "file", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getFile", "()Ljava/nio/file/Path;", "intellij.javascript.impl"})
    private static final class SuccessfullyDownloaded
    extends DownloadStatus {
        @NotNull
        private final Path file;

        public SuccessfullyDownloaded(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(null);
            this.file = file;
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$VersionNotFound;", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesEnProvider$DownloadStatus;", "<init>", "()V", "intellij.javascript.impl"})
    private static final class VersionNotFound
    extends DownloadStatus {
        @NotNull
        public static final VersionNotFound INSTANCE = new VersionNotFound();

        private VersionNotFound() {
            super(null);
        }
    }
}

