/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.intentions.TypeScriptLibraryUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferencesLibraryFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final String LIBRARY_NAME = "ts-external-references";

    public TypeScriptReferencesLibraryFix(PsiElement comment) {
        super(comment);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(3);
        }
        if (!(file instanceof JSFile)) {
            return;
        }
        Collection<VirtualFile> files = TypeScriptReferencesLibraryFix.getFilesForLibrary((JSFile)file);
        if (files.isEmpty()) {
            return;
        }
        Collection<Module> modules = TypeScriptLibraryUtil.getModules(project, ContainerUtil.createMaybeSingletonList((Object)file.getVirtualFile()));
        TypeScriptLibraryUtil.updateLibrary(project, modules, LIBRARY_NAME, files, false);
    }

    @NotNull
    private static Collection<VirtualFile> getFilesForLibrary(JSFile file) {
        Collection<VirtualFile> collection = JSFixFactory.getInstance().typeScriptReferencePathValidator().getOutOfProjectReferences(file);
        if (collection == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(8);
        }
        if (!(file instanceof JSFile)) {
            return false;
        }
        return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences((JSFile)file);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("intention.name.create.library.with.files.outside.project", new Object[0]);
        if (string == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(12);
        }
        if (file == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(13);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            TypeScriptReferencesLibraryFix.$$$reportNull$$$0(14);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptReferencesLibraryFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesForLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 14 -> new IllegalStateException(string);
        };
    }
}

