/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.bugs;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.ConstantUtils;
import org.jetbrains.annotations.NotNull;

public final class DivideByZeroJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("division.by.zero.error.string", new Object[0]);
        if (string == null) {
            DivideByZeroJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection", "buildErrorString"));
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                DivisionByZeroVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIV.equals(tokenType) && !JSTokenTypes.PERC.equals(tokenType)) {
                return;
            }
            if (!ConstantUtils.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        @Override
        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
            if (expression == null) {
                DivisionByZeroVisitor.$$$reportNull$$$0(1);
            }
            super.visitJSAssignmentExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression.getOperationSign();
            if (!JSTokenTypes.DIVEQ.equals(tokenType) && !JSTokenTypes.PERCEQ.equals(tokenType)) {
                return;
            }
            if (!ConstantUtils.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/bugs/DivideByZeroJSInspection$DivisionByZeroVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

