/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ForLoopReplaceableByWhileJSInspection
extends JavaScriptInspection {
    public boolean m_ignoreLoopsWithoutConditions = false;

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("for.loop.replaceable.by.while.problem.descriptor", new Object[0]);
        if (string == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreLoopsWithoutConditions", (String)InspectionJSBundle.message("for.loop.replaceable.by.while.ignore.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ForLoopReplaceableByWhileJSInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ReplaceForByWhileFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopReplaceableByWhileVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ReplaceForByWhileFix
    extends InspectionJSFix {
        private ReplaceForByWhileFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("for.loop.replaceable.by.while.replace.quickfix", new Object[0]);
            if (string == null) {
                ReplaceForByWhileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement forKeywordElement = descriptor.getPsiElement();
            JSForStatement forStatement = (JSForStatement)forKeywordElement.getParent();
            assert (forStatement != null);
            JSExpression condition = forStatement.getCondition();
            JSStatement body2 = forStatement.getBody();
            String bodyText = body2 == null ? "" : body2.getText();
            @NonNls String whileStatement = condition == null ? "while(true)" + bodyText : "while(" + condition.getText() + ")" + bodyText;
            ReplaceForByWhileFix.replaceStatement(forStatement, whileStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ReplaceForByWhileFix", "getFamilyName"));
        }
    }

    private class ForLoopReplaceableByWhileVisitor
    extends BaseInspectionVisitor {
        private ForLoopReplaceableByWhileVisitor() {
        }

        @Override
        public void visitJSForStatement(@NotNull JSForStatement statement) {
            if (statement == null) {
                ForLoopReplaceableByWhileVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSForStatement(statement);
            JSVarStatement varStatement = statement.getVarDeclaration();
            if (varStatement != null) {
                return;
            }
            JSExpression initialization = statement.getInitialization();
            if (initialization != null) {
                return;
            }
            JSExpression update2 = statement.getUpdate();
            if (update2 != null) {
                return;
            }
            if (ForLoopReplaceableByWhileJSInspection.this.m_ignoreLoopsWithoutConditions && BoolUtils.isTrueLiteral(statement.getCondition())) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/ForLoopReplaceableByWhileJSInspection$ForLoopReplaceableByWhileVisitor", "visitJSForStatement"));
        }
    }
}

