/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.jinja.template.DjangoTemplateFileViewProvider;
import com.intellij.jinja.template.formatter.DjangoCompositeBlock;
import com.intellij.jinja.template.formatter.DjangoTemplateBlock;
import com.intellij.jinja.template.formatter.DjangoTemplateBlockTreeFormatter;
import com.intellij.jinja.template.formatter.DjangoXmlBlock;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.DjangoTemplatePsiUtil;
import com.intellij.jinja.template.psi.impl.DjangoTemplateFileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.impl.source.html.HtmlScriptInjectionBlockerExtension;
import com.intellij.psi.impl.source.html.HtmlScriptLanguageInjector;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.template.lang.core.templateLanguages.PyTemplatesCoreUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplateFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = formattingContext.getContainingFile();
        PsiElement element = formattingContext.getPsiElement();
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider vProvider = (TemplateLanguageFileViewProvider)fileViewProvider;
            if (element instanceof DjangoTemplateFileImpl) {
                Language templateDataLanguage = vProvider.getTemplateDataLanguage();
                Language baseLanguage = vProvider.getBaseLanguage();
                if (templateDataLanguage instanceof XMLLanguage) {
                    FormattingModel formattingModel = DjangoTemplateFormattingModelBuilder.createXmlFormattingModel((PsiElement)vProvider.getPsi(templateDataLanguage), (PsiElement)vProvider.getPsi(baseLanguage), settings, psiFile);
                    if (formattingModel == null) {
                        DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(1);
                    }
                    return formattingModel;
                }
                if (templateDataLanguage.getID().equals("JavaScript") || templateDataLanguage.getID().equals("GenericSQL")) {
                    FormattingModel formattingModel = DjangoTemplateFormattingModelBuilder.createJavascriptFormattingModel((PsiElement)vProvider.getPsi(templateDataLanguage), (PsiElement)vProvider.getPsi(baseLanguage), settings, psiFile, templateDataLanguage);
                    if (formattingModel == null) {
                        DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(2);
                    }
                    return formattingModel;
                }
                FormattingModel formattingModel = this.createBaseLanguageFormattingModel(templateDataLanguage, (PsiElement)vProvider.getPsi(templateDataLanguage), settings);
                if (formattingModel == null) {
                    DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(3);
                }
                return formattingModel;
            }
            if (element instanceof OuterLanguageElement && element.getNode().getElementType() == DjangoTemplateTokenTypes.DJANGO_INJECTION_IN_HTML) {
                List<PsiElement> list2 = DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElement(element, vProvider);
                return DjangoTemplateFormattingModelBuilder.createDjangoFormattingModel(element, list2, settings, psiFile);
            }
        }
        FormattingModel formattingModel = super.createModel(formattingContext);
        if (formattingModel == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        return formattingModel;
    }

    private FormattingModel createBaseLanguageFormattingModel(Language language, PsiElement element, CodeStyleSettings settings) {
        FormattingModelBuilder modelBuilder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(language);
        if (modelBuilder != null && !(modelBuilder instanceof SimpleTemplateLanguageFormattingModelBuilder)) {
            return modelBuilder.createModel(FormattingContext.create((PsiElement)element, (CodeStyleSettings)settings));
        }
        return super.createModel(FormattingContext.create((PsiElement)element, (CodeStyleSettings)settings));
    }

    private static FormattingModel createXmlFormattingModel(PsiElement templateElement, PsiElement djangoPsiRoot, CodeStyleSettings settings, PsiFile psiFile) {
        assert (templateElement.getNode() != null);
        assert (psiFile != null);
        XmlFormattingPolicy policy = DjangoTemplateFormattingModelBuilder.getPolicy(settings, psiFile);
        DjangoXmlBlock block = new DjangoXmlBlock(templateElement.getNode(), null, Alignment.createAlignment(), policy, Indent.getNoneIndent(), templateElement.getTextRange());
        DjangoTemplateBlockTreeFormatter formatter2 = new DjangoTemplateBlockTreeFormatter();
        Block djangoBlock = formatter2.reformat(policy, (Block)block, djangoPsiRoot);
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)psiFile, (Block)djangoBlock, (CodeStyleSettings)settings);
    }

    private static FormattingModel createJavascriptFormattingModel(PsiElement templateElement, PsiElement djangoPsiRoot, CodeStyleSettings settings, PsiFile psiFile, Language templateLanguage) {
        FormattingModelBuilder modelBuilder = (FormattingModelBuilder)LanguageFormatting.INSTANCE.forLanguage(templateLanguage);
        if (modelBuilder != null) {
            return modelBuilder.createModel(FormattingContext.create((PsiElement)templateElement, (CodeStyleSettings)settings));
        }
        return DjangoTemplateFormattingModelBuilder.createXmlFormattingModel(templateElement, djangoPsiRoot, settings, psiFile);
    }

    @NotNull
    private static FormattingModel createDjangoFormattingModel(PsiElement elementInTemplate, @NotNull List<PsiElement> elements, @NotNull CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        DjangoCompositeBlock block;
        if (elements == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        XmlFormattingPolicy policy = DjangoTemplateFormattingModelBuilder.getPolicy(settings, psiFile);
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (PsiElement element : elements) {
            assert (element.getNode() != null);
            if (element instanceof PsiErrorElement || element instanceof PsiWhiteSpace) continue;
            DjangoTemplateBlock block2 = new DjangoTemplateBlock(element.getNode(), DjangoTemplateFormattingModelBuilder.selectWrap(elementInTemplate), null, policy);
            blocks.add((Block)block2);
        }
        if (blocks.size() > 1) {
            block = new DjangoCompositeBlock((List<Block>)blocks);
        } else if (blocks.size() > 0) {
            block = (Block)blocks.get(0);
        } else {
            throw new IllegalStateException("Block list cant be empty!");
        }
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)psiFile, (Block)block, (CodeStyleSettings)settings);
        if (formattingModel == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        return formattingModel;
    }

    private static Wrap selectWrap(PsiElement elementInTemplate) {
        Wrap wrap2 = DjangoTemplateFormattingModelBuilder.isInAttribute(elementInTemplate) ? Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false) : null;
        return wrap2;
    }

    public static boolean isInAttribute(PsiElement elementInTemplate) {
        return PsiTreeUtil.getParentOfType((PsiElement)elementInTemplate, XmlAttribute.class) != null;
    }

    private static XmlFormattingPolicy getPolicy(CodeStyleSettings settings, PsiFile psiFile) {
        FormattingDocumentModelImpl documentModel;
        FileViewProvider fileViewProvider = psiFile.getViewProvider();
        if (fileViewProvider instanceof DjangoTemplateFileViewProvider) {
            DjangoTemplateFileViewProvider viewProvider = (DjangoTemplateFileViewProvider)fileViewProvider;
            Language language = viewProvider.getTemplateDataLanguage();
            documentModel = FormattingDocumentModelImpl.createOn((PsiFile)viewProvider.getPsi(language));
            if (language == XMLLanguage.INSTANCE) {
                return new XmlPolicy(settings, (FormattingDocumentModel)documentModel);
            }
        } else {
            documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        }
        return new HtmlPolicy(settings, (FormattingDocumentModel)documentModel){

            public boolean isTextElement(XmlTag tag) {
                return super.isTextElement(tag) || DjangoTemplateFormattingModelBuilder.isProtectedFromInjection(tag);
            }
        };
    }

    private static boolean isProtectedFromInjection(@NotNull XmlTag tag) {
        Language language;
        if (tag == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        return (language = HtmlScriptLanguageInjector.getScriptLanguageToInject((XmlTag)tag)) != null && HtmlScriptInjectionBlockerExtension.isInjectionBlocked((XmlTag)tag, (Language)language);
    }

    @Nullable
    public static CommonCodeStyleSettings.IndentOptions getIndentOptions(@NotNull PsiFile file, @NotNull CodeStyleSettings settings) {
        Language language;
        if (file == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            DjangoTemplateFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        return (language = PyTemplatesCoreUtil.getTemplateDataLanguage((PsiElement)file, DjangoTemplateFileViewProvider.class)) != null ? settings.getIndentOptions((FileType)language.getAssociatedFileType()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/formatter/DjangoTemplateFormattingModelBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/formatter/DjangoTemplateFormattingModelBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDjangoFormattingModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDjangoFormattingModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isProtectedFromInjection";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

