/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.psi;

import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.impl.DjangoOuterLanguageElement;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2VariableReferenceImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoTemplatePsiUtil {
    private DjangoTemplatePsiUtil() {
    }

    public static boolean isTemplateCharacters(@NotNull ASTNode child) {
        if (child == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(0);
        }
        return child.getPsi() instanceof DjangoOuterLanguageElement && child.getElementType() == DjangoTemplateTokenTypes.TEMPLATE_CHARACTERS;
    }

    public static boolean containsButNotEqual(@NotNull TextRange biggerRange, @NotNull TextRange smallerRange) {
        if (biggerRange == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(1);
        }
        if (smallerRange == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(2);
        }
        return biggerRange.contains(smallerRange) && !biggerRange.equals((Object)smallerRange);
    }

    @NotNull
    public static PsiElement biggestElementInside(@NotNull PsiElement element, @NotNull PsiElement djangoElement) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(3);
        }
        if (djangoElement == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(4);
        }
        while (djangoElement.getParent() != null && !(djangoElement.getParent() instanceof XmlDocument) && djangoElement.getParent().getTextRange() != null && !DjangoTemplatePsiUtil.containsButNotEqual(djangoElement.getParent().getTextRange(), element.getTextRange())) {
            djangoElement = djangoElement.getParent();
        }
        PsiElement psiElement = djangoElement;
        if (psiElement == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, TemplateLanguageFileViewProvider vProvider) {
        PsiFile psi = vProvider.getPsi(vProvider.getBaseLanguage());
        if (psi == null) {
            return new ArrayList<PsiElement>();
        }
        PsiElement el = psi.findElementAt(outerLangElement.getTextRange().getStartOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, el);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, PsiElement djangoElement) {
        djangoElement = djangoElement.findElementAt(outerLangElement.getTextOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, djangoElement);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElementInner(PsiElement outerLangElement, PsiElement djangoElement) {
        ArrayList<PsiElement> list2 = new ArrayList<PsiElement>();
        for (djangoElement = DjangoTemplatePsiUtil.biggestElementInside(outerLangElement, djangoElement); djangoElement != null && djangoElement.getTextRange().getEndOffset() <= outerLangElement.getTextRange().getEndOffset(); djangoElement = djangoElement.getNextSibling()) {
            list2.add(djangoElement);
        }
        return list2;
    }

    @Nullable
    public static String getDjangoExpressionVariable(DjangoTagElementImpl element) {
        Jinja2VariableReferenceImpl ref = (Jinja2VariableReferenceImpl)PsiTreeUtil.findChildOfType((PsiElement)element, Jinja2VariableReferenceImpl.class);
        if (ref != null) {
            return ref.getName();
        }
        return null;
    }

    public static boolean isWhiteSpaceOrComment(@NotNull PsiElement element) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(6);
        }
        return element.getText().trim().length() == 0 || element instanceof PsiComment || element instanceof PsiWhiteSpace;
    }

    public static PsiElement skipCommentsAndWhitespaces(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            DjangoTemplatePsiUtil.$$$reportNull$$$0(7);
        }
        if (!strict && !DjangoTemplatePsiUtil.isWhiteSpaceOrComment(element)) {
            return element;
        }
        PsiElement candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        while (candidate != null && DjangoTemplatePsiUtil.isWhiteSpaceOrComment(candidate)) {
            candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)candidate);
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biggerRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallerRange";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/template/psi/DjangoTemplatePsiUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/template/psi/DjangoTemplatePsiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "biggestElementInside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCharacters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsButNotEqual";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "biggestElementInside";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWhiteSpaceOrComment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipCommentsAndWhitespaces";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

