/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.python.concurrencyVisualizer.icons.ConcurrencyVisualiserIcons;
import com.intellij.python.concurrencyVisualizer.tool.ConcurrencyView;
import com.intellij.python.concurrencyVisualizer.tool.panels.ConcurrencyTab;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonScripts;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public final class PyConcurrencyDebugRunner
extends PyDebugRunner {
    public static final String PY_CONCURRENCY_DEBUG_RUNNER = "PyConcurrencyDebugRunner";
    private static final Key<Boolean> PYTHON_CONCURRENCY_PROCESS_HANDLER = Key.create((String)"PYTHON_CONCURRENCY_PROCESS_HANDLER");
    private ArrayList<XBreakpoint> myDisabledBreakpoints;

    @NotNull
    public String getRunnerId() {
        return PY_CONCURRENCY_DEBUG_RUNNER;
    }

    protected Promise<XDebugSession> createSession(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        if (state == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(1);
        }
        return super.createSession(state, environment).thenAsync(session -> AppUIExecutor.onUiThread().submit(() -> {
            Project project = environment.getProject();
            session.getDebugProcess().getProcessHandler().putUserData(PYTHON_CONCURRENCY_PROCESS_HANDLER, (Object)true);
            final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
            this.disableBreakpoints(project);
            session.addSessionListener(new XDebugSessionListener(){

                public void sessionStopped() {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        for (XBreakpoint breakpoint : PyConcurrencyDebugRunner.this.myDisabledBreakpoints) {
                            breakpoint.setEnabled(true);
                        }
                    });
                    toolWindowManager.invokeLater(() -> {
                        ToolWindow debugToolWindow = toolWindowManager.getToolWindow("Debug");
                        if (debugToolWindow != null) {
                            debugToolWindow.setAvailable(true);
                        }
                    });
                }
            });
            PyConcurrencyDebugRunner.initToolWindow(session, project);
            return session;
        }));
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull ParamsGroup debugParams, @NotNull PythonCommandLineState pyState, @NotNull GeneralCommandLine cmd) {
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(2);
        }
        if (debugParams == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(3);
        }
        if (pyState == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(4);
        }
        if (cmd == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(5);
        }
        super.configureDebugParameters(project, debugParams, pyState, cmd);
        debugParams.addParameter("--save-threading");
        debugParams.addParameter("--save-asyncio");
        cmd.getEnvironment().put("PYTHONASYNCIODEBUG", "1");
        PyDebugRunner.disableBuiltinBreakpoint((Sdk)pyState.getSdk(), (Map)cmd.getEnvironment());
    }

    protected void configureDebugParameters(@NotNull Project project, @NotNull PythonCommandLineState pyState, @NotNull PythonExecution debuggerScript, boolean debuggerScriptInServerMode) {
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(6);
        }
        if (pyState == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(7);
        }
        if (debuggerScript == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(8);
        }
        PyConcurrencyDebugRunner.configureCommonDebugParameters((Project)project, (PythonExecution)debuggerScript);
        debuggerScript.addParameter("--save-threading");
        debuggerScript.addParameter("--save-asyncio");
        debuggerScript.addEnvironmentVariable("PYTHONASYNCIODEBUG", "1");
        PythonScripts.disableBuiltinBreakpoint((PythonExecution)debuggerScript, (Sdk)pyState.getSdk());
    }

    private void disableBreakpoints(@NotNull Project project) {
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(9);
        }
        this.myDisabledBreakpoints = new ArrayList();
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)project);
        for (XBreakpoint breakpoint : manager.getBreakpointManager().getAllBreakpoints()) {
            if (!breakpoint.isEnabled()) continue;
            breakpoint.setEnabled(false);
            this.myDisabledBreakpoints.add(breakpoint);
        }
    }

    private static void initToolWindow(@NotNull XDebugSession newSession, final @NotNull Project project) {
        if (newSession == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(10);
        }
        if (project == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(11);
        }
        final ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.invokeLater(() -> {
            ToolWindow toolwindow = toolWindowManager.getToolWindow("Debug");
            if (toolwindow != null) {
                toolwindow.setAvailable(false);
            }
        });
        ToolWindow toolWindow = toolWindowManager.getToolWindow(PythonConcurrencyVisualizerBundle.message("concurrency.diagram.window.id", new Object[0]));
        if (toolWindow == null) {
            toolWindowManager.invokeLater(() -> {
                ToolWindow window = PyConcurrencyDebugRunner.createToolWindow(toolWindowManager);
                final ContentManager contentManager = window.getContentManager();
                final String WINDOW_ID = PythonConcurrencyVisualizerBundle.message("concurrency.diagram.window.id", new Object[0]);
                contentManager.addContentManagerListener(new ContentManagerListener(){

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        ToolWindow toolWindowToUnregister;
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (contentManager.getContents().length == 0 && (toolWindowToUnregister = ToolWindowManager.getInstance((Project)project).getToolWindow(WINDOW_ID)) != null) {
                            toolWindowManager.invokeLater(() -> ToolWindowManager.getInstance((Project)project).unregisterToolWindow(WINDOW_ID));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/python/concurrencyVisualizer/PyConcurrencyDebugRunner$2", "contentRemoved"));
                    }
                });
                PyConcurrencyDebugRunner.createContent(project, window, newSession, 0);
                window.show(null);
            });
        } else {
            ConcurrencyTab selectedTab;
            XDebugSession session;
            JComponent component2;
            ContentManager contentManager = toolWindow.getContentManager();
            Content content = contentManager.getSelectedContent();
            int contentIndex = contentManager.getContentCount();
            Content contentToRemove = null;
            if (content != null && (component2 = content.getComponent()) instanceof ConcurrencyTab && (session = (selectedTab = (ConcurrencyTab)((Object)component2)).getThreadingGraphModel().getLastSession()) != null && session.isStopped()) {
                contentIndex = contentManager.getIndexOfContent(content);
                contentToRemove = content;
            }
            PyConcurrencyDebugRunner.createContent(project, toolWindow, newSession, contentIndex);
            if (contentToRemove != null) {
                contentManager.removeContent(contentToRemove, true);
            }
            toolWindowManager.invokeLater(() -> toolWindow.show(null));
        }
    }

    private static void createContent(Project project, @NotNull ToolWindow toolWindow, @NotNull XDebugSession session, int index) {
        if (toolWindow == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(12);
        }
        if (session == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(13);
        }
        Content content = new ConcurrencyView(project).createContent(session);
        ContentManager myContentManager = toolWindow.getContentManager();
        myContentManager.addContent(content, index);
        myContentManager.setSelectedContent(content);
    }

    private static ToolWindow createToolWindow(@NotNull ToolWindowManager toolWindowManager) {
        if (toolWindowManager == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(14);
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(PythonConcurrencyVisualizerBundle.message("concurrency.diagram.window.id", new Object[0]), true, ToolWindowAnchor.BOTTOM);
        toolWindow.setIcon(ConcurrencyVisualiserIcons.ConcurrencyDiagramToolwindow);
        return toolWindow;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(15);
        }
        if (profile == null) {
            PyConcurrencyDebugRunner.$$$reportNull$$$0(16);
        }
        return executorId.equals("ConcurrencyExecutor") && profile instanceof AbstractPythonRunConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugParams";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerScript";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSession";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/concurrencyVisualizer/PyConcurrencyDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSession";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "configureDebugParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "disableBreakpoints";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "initToolWindow";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createContent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindow";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

