/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger.remote.vfs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.python.pro.debugger.remote.ui.PyMappingSimpleResolveDialog;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PyPathMapper {
    public static final Pattern WINDOWS_VOLUME_NAME = Pattern.compile("([A-Za-z]:)[/\\\\](.*)");

    public static String @NotNull [] getPath(@NotNull String originalPath) {
        String path2;
        if (originalPath == null) {
            PyPathMapper.$$$reportNull$$$0(0);
        }
        ArrayList<String> pathList = new ArrayList<String>();
        Matcher windowsVolumeMatcher = WINDOWS_VOLUME_NAME.matcher(originalPath);
        if (windowsVolumeMatcher.matches()) {
            pathList.add(windowsVolumeMatcher.group(1));
            path2 = windowsVolumeMatcher.group(2);
        } else {
            path2 = originalPath;
        }
        StringTokenizer st = new StringTokenizer(path2, "/\\");
        while (st.hasMoreTokens()) {
            String segment2 = st.nextToken();
            if (segment2.length() <= 0) continue;
            pathList.add(segment2);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(pathList);
        if (stringArray == null) {
            PyPathMapper.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    public static String @NotNull [] intersectFromEnd(@NotNull String path1, @NotNull String path2, boolean caseSensitive) {
        if (path1 == null) {
            PyPathMapper.$$$reportNull$$$0(2);
        }
        if (path2 == null) {
            PyPathMapper.$$$reportNull$$$0(3);
        }
        return PyPathMapper.intersectFromEnd(PyPathMapper.getPath(path1), PyPathMapper.getPath(path2), caseSensitive);
    }

    public static String @NotNull [] intersectFromEnd(String[] arr1, String[] arr2, boolean caseSensitive) {
        int i1 = arr1.length - 1;
        for (int i2 = arr2.length - 1; i1 > -1 && i2 > -1 && (caseSensitive ? arr1[i1].equals(arr2[i2]) : arr1[i1].equalsIgnoreCase(arr2[i2])); --i1, --i2) {
        }
        String[] stringArray = Arrays.copyOfRange(arr1, i1 + 1, arr1.length);
        if (stringArray == null) {
            PyPathMapper.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public static boolean detectLocalPath(@NotNull Project project, @NotNull String remoteFilePath, @NotNull PyRemotePathMapper pathMapper) {
        if (project == null) {
            PyPathMapper.$$$reportNull$$$0(5);
        }
        if (remoteFilePath == null) {
            PyPathMapper.$$$reportNull$$$0(6);
        }
        if (pathMapper == null) {
            PyPathMapper.$$$reportNull$$$0(7);
        }
        Collection candidates = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((String)PathUtil.getFileName((String)remoteFilePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        PyMappingSimpleResolveDialog dialog = new PyMappingSimpleResolveDialog(project, remoteFilePath, candidates);
        UIUtil.invokeAndWaitIfNeeded(() -> dialog.show());
        if (dialog.isOK()) {
            VirtualFile selectedFile = dialog.getSelectedFile();
            PyPathMapper.updateMapping(selectedFile, remoteFilePath, pathMapper);
            return true;
        }
        return false;
    }

    public static void updateMapping(VirtualFile virtualFile, String remoteFilePath, PyRemotePathMapper pathMapper) {
        PathMappingSettings.PathMapping mapping2 = PyPathMapper.detectMapping(virtualFile.getPath(), remoteFilePath);
        pathMapper.addMapping(mapping2.getLocalRoot(), mapping2.getRemoteRoot(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    @NotNull
    public static PathMappingSettings.PathMapping detectMapping(String localPath, String remotePath) {
        localPath = FileUtil.toSystemIndependentName((String)localPath);
        remotePath = FileUtil.toSystemIndependentName((String)remotePath);
        int i = 1;
        int lastCommonSeparator = 1;
        while (i < remotePath.length() && i < localPath.length() && localPath.charAt(localPath.length() - i) == remotePath.charAt(remotePath.length() - i)) {
            if (localPath.charAt(localPath.length() - ++i) != '/' || remotePath.charAt(remotePath.length() - i) != '/' || i == localPath.length() || i == remotePath.length()) continue;
            lastCommonSeparator = i;
        }
        return new PathMappingSettings.PathMapping(PyPathMapper.getRoot(localPath, lastCommonSeparator), PyPathMapper.getRoot(remotePath, lastCommonSeparator));
    }

    private static String getRoot(String path2, int i) {
        if (i < path2.length()) {
            return path2.substring(0, path2.length() - i + 1);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intersectFromEnd";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectLocalPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

