/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.flask.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.python.pro.flask.FlaskFinder;
import com.intellij.python.pro.flask.codeInsight.FlaskNames;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/python/pro/flask/completion/FlaskCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "qualifierIsFlaskExt", "", "reference", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "isFlaskExtension", "dirOrFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiManager", "Lcom/intellij/psi/PsiManager;", "anchor", "Lcom/intellij/psi/PsiElement;", "getFlaskExtensionName", "", "file", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nFlaskCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlaskCompletionContributor.kt\ncom/intellij/python/pro/flask/completion/FlaskCompletionContributor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,80:1\n1317#2,2:81\n*S KotlinDebug\n*F\n+ 1 FlaskCompletionContributor.kt\ncom/intellij/python/pro/flask/completion/FlaskCompletionContributor\n*L\n39#1:81,2\n*E\n"})
public final class FlaskCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement element = parameters2.getPosition().getParent();
        if (element instanceof PyReferenceExpression && this.qualifierIsFlaskExt((PyReferenceExpression)element) && FlaskFinder.flaskExtPackageExists(element)) {
            PsiManager psiManager = PsiManager.getInstance((Project)((PyReferenceExpression)element).getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
            PsiManager psiManager2 = psiManager;
            RootVisitorHost.visitRoots((PsiElement)element, (arg_0, arg_1, arg_2, arg_3) -> FlaskCompletionContributor.fillCompletionVariants$lambda$4(this, psiManager2, element, result2, arg_0, arg_1, arg_2, arg_3));
        }
    }

    private final boolean qualifierIsFlaskExt(PyReferenceExpression reference) {
        String qualifier;
        PyExpression pyExpression = reference.getQualifier();
        String string = qualifier = pyExpression != null ? pyExpression.getText() : null;
        if (Intrinsics.areEqual((Object)qualifier, (Object)FlaskNames.FLASK_EXT.toString())) {
            return true;
        }
        PsiElement parent = reference.getParent();
        PyImportElement pyImportElement = parent instanceof PyImportElement ? (PyImportElement)parent : null;
        PyStatement containingImportStatement = pyImportElement != null ? pyImportElement.getContainingImportStatement() : null;
        return containingImportStatement instanceof PyFromImportStatement && Intrinsics.areEqual((Object)((PyFromImportStatement)containingImportStatement).getImportSourceQName(), (Object)FlaskNames.FLASK_EXT);
    }

    private final boolean isFlaskExtension(VirtualFile dirOrFile, PsiManager psiManager, PsiElement anchor) {
        PsiDirectory psiDirectory;
        return dirOrFile.isDirectory() ? (psiDirectory = psiManager.findDirectory(dirOrFile)) != null && PyUtil.isPackage((PsiDirectory)psiDirectory, (boolean)false, (PsiElement)anchor) : FileTypeRegistry.getInstance().isFileOfType(dirOrFile, (FileType)PythonFileType.INSTANCE) && !Intrinsics.areEqual((Object)dirOrFile.getName(), (Object)"__init__.py");
    }

    private final String getFlaskExtensionName(VirtualFile file) {
        String string;
        String string2 = file.isDirectory() ? file.getName() : file.getNameWithoutExtension();
        Intrinsics.checkNotNull((Object)string2);
        String name = string2;
        if (StringsKt.startsWith$default((String)name, (String)"flask_", (boolean)false, (int)2, null)) {
            String string3 = name.substring(6);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = name;
        }
        return string;
    }

    private static final boolean fillCompletionVariants$lambda$4$lambda$0(VirtualFile it) {
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.startsWith$default((String)string, (String)"flask_", (boolean)false, (int)2, null);
    }

    private static final boolean fillCompletionVariants$lambda$4$lambda$1(FlaskCompletionContributor this$0, PsiManager $psiManager, PsiElement $element, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isFlaskExtension(it, $psiManager, $element);
    }

    private static final LookupElementBuilder fillCompletionVariants$lambda$4$lambda$2(FlaskCompletionContributor this$0, VirtualFile it) {
        Intrinsics.checkNotNull((Object)it);
        return LookupElementBuilder.create((String)this$0.getFlaskExtensionName(it));
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean fillCompletionVariants$lambda$4(FlaskCompletionContributor this$0, PsiManager $psiManager, PsiElement $element, CompletionResultSet $result, VirtualFile root, Module module, Sdk sdk, boolean bl) {
        void $this$forEach$iv;
        Sequence sequence;
        Sequence sequence2;
        VirtualFile virtualFile;
        Sequence flaskExtChildren = root != null && (virtualFile = root.findChild("flaskext")) != null && (sequence2 = virtualFile.getChildren()) != null && (sequence = ArraysKt.asSequence((Object[])sequence2)) != null ? sequence : SequencesKt.emptySequence();
        Sequence sequence3 = root;
        if (sequence3 == null || (sequence3 = sequence3.getChildren()) == null || (sequence3 = ArraysKt.asSequence((Object[])sequence3)) == null || (sequence3 = SequencesKt.filter((Sequence)sequence3, FlaskCompletionContributor::fillCompletionVariants$lambda$4$lambda$0)) == null) {
            sequence3 = SequencesKt.emptySequence();
        }
        Sequence flaskUnderscoreTopLevelChildren = sequence3;
        sequence2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.plus((Sequence)flaskExtChildren, (Sequence)flaskUnderscoreTopLevelChildren), arg_0 -> FlaskCompletionContributor.fillCompletionVariants$lambda$4$lambda$1(this$0, $psiManager, $element, arg_0)), arg_0 -> FlaskCompletionContributor.fillCompletionVariants$lambda$4$lambda$2(this$0, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupElementBuilder it = (LookupElementBuilder)element$iv;
            boolean bl2 = false;
            $result.addElement((LookupElement)it);
        }
        return true;
    }
}

