/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.profiler.ProfilerCommunication;
import com.intellij.python.profiler.ProfilerResponse;
import com.intellij.python.profiler.PythonProfilerBundle;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/profiler/SnapshotAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "profilerCommunication", "Lcom/intellij/python/profiler/ProfilerCommunication;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/python/profiler/ProfilerCommunication;Lcom/intellij/execution/process/ProcessHandler;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProfilerCommunication", "()Lcom/intellij/python/profiler/ProfilerCommunication;", "getProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.python.profiler"})
public final class SnapshotAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final ProfilerCommunication profilerCommunication;
    @NotNull
    private final ProcessHandler processHandler;

    public SnapshotAction(@NotNull Project project, @NotNull ProfilerCommunication profilerCommunication, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profilerCommunication, (String)"profilerCommunication");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        super(PythonProfilerBundle.message("action.PyProfiler.CaptureSnapshot.text", new Object[0]), PythonProfilerBundle.message("action.PyProfiler.CaptureSnapshot.description", new Object[0]), AllIcons.Actions.ProfileCPU);
        this.project = project;
        this.profilerCommunication = profilerCommunication;
        this.processHandler = processHandler;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProfilerCommunication getProfilerCommunication() {
        return this.profilerCommunication;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FutureCallback value2 = (FutureCallback)new FutureCallback<ProfilerResponse>(this){
            final /* synthetic */ SnapshotAction this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailure(Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                throw new UnsupportedOperationException();
            }

            public void onSuccess(ProfilerResponse response) {
                ProfilerCommunication profilerCommunication = this.this$0.getProfilerCommunication();
                Project project = this.this$0.getProject();
                Sdk sdk = this.this$0.getProfilerCommunication().getSdk();
                ProfilerResponse profilerResponse = response;
                Intrinsics.checkNotNull((Object)profilerResponse);
                profilerCommunication.processResponse(project, sdk, profilerResponse, this.this$0.getProcessHandler());
            }
        };
        Futures.addCallback(this.profilerCommunication.captureSnapshot(), (FutureCallback)value2, (Executor)AppExecutorUtil.getAppExecutorService());
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(!this.processHandler.isProcessTerminated());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

