/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.ProfileDataKt;
import com.intellij.python.profiler.callgraph.CallGraphDiagramProvider;
import com.intellij.python.profiler.callgraph.CallGraphEdge;
import com.intellij.python.profiler.callgraph.CallGraphNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u0014H\u0016J\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\nj\b\u0012\u0004\u0012\u00020\u000e`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/python/profiler/callgraph/CallGraphDiagramModel;", "Lcom/intellij/diagram/DiagramDataModel;", "Lcom/intellij/python/profiler/FunctionStat;", "project", "Lcom/intellij/openapi/project/Project;", "functionsStats", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "nodes", "Ljava/util/HashSet;", "Lcom/intellij/python/profiler/callgraph/CallGraphNode;", "Lkotlin/collections/HashSet;", "edges", "Lcom/intellij/python/profiler/callgraph/CallGraphEdge;", "getNodeName", "", "n", "Lcom/intellij/diagram/DiagramNode;", "getEdges", "", "Lcom/intellij/diagram/DiagramEdge;", "getNodes", "addElement", "element", "refreshDataModel", "", "getModificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "dispose", "intellij.python.profiler"})
@SourceDebugExtension(value={"SMAP\nCallGraphModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallGraphModel.kt\ncom/intellij/python/profiler/callgraph/CallGraphDiagramModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1053#2:138\n1202#2,2:139\n1230#2,4:141\n*S KotlinDebug\n*F\n+ 1 CallGraphModel.kt\ncom/intellij/python/profiler/callgraph/CallGraphDiagramModel\n*L\n22#1:138\n26#1:139,2\n26#1:141,4\n*E\n"})
public final class CallGraphDiagramModel
extends DiagramDataModel<FunctionStat> {
    @NotNull
    private final HashSet<CallGraphNode> nodes;
    @NotNull
    private final HashSet<CallGraphEdge> edges;

    /*
     * WARNING - void declaration
     */
    public CallGraphDiagramModel(@NotNull Project project, @NotNull List<? extends FunctionStat> functionsStats) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(functionsStats, (String)"functionsStats");
        super(project, (DiagramProvider)CallGraphDiagramProvider.INSTANCE);
        this.nodes = new HashSet();
        this.edges = new HashSet();
        Iterable $this$sortedBy$iv = functionsStats;
        boolean bl = false;
        for (FunctionStat call : CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                FunctionStat stat = (FunctionStat)a2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(-((double)stat.getTotalTimeMs()) / (double)stat.getBaseTotalTime());
                stat = (FunctionStat)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(-((double)stat.getTotalTimeMs()) / (double)stat.getBaseTotalTime()));
            }
        }), (int)50)) {
            this.nodes.add(new CallGraphNode(call));
        }
        Iterable $this$associateBy$iv = this.nodes;
        boolean bl2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CallGraphNode callGraphNode = (CallGraphNode)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl3 = false;
            map2.put(ProfileDataKt.callId(it.getIdentifyingElement()), element$iv$iv);
        }
        Map idToNodes = destination$iv$iv;
        for (FunctionStat functionStat : functionsStats) {
            for (FunctionStat caller : functionStat.getCallers()) {
                CallGraphNode source = (CallGraphNode)((Object)idToNodes.get(ProfileDataKt.callId(caller)));
                CallGraphNode target = (CallGraphNode)((Object)idToNodes.get(ProfileDataKt.callId(functionStat)));
                if (source == null || target == null) continue;
                this.edges.add(new CallGraphEdge(source, target));
            }
        }
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<FunctionStat> n) {
        Intrinsics.checkNotNullParameter(n, (String)"n");
        return ((CallGraphNode)n).getCallStat().getName();
    }

    @NotNull
    public Collection<? extends DiagramEdge<FunctionStat>> getEdges() {
        return this.edges;
    }

    @NotNull
    public Collection<? extends DiagramNode<FunctionStat>> getNodes() {
        return this.nodes;
    }

    @Nullable
    public DiagramNode<FunctionStat> addElement(@Nullable FunctionStat element) {
        throw new UnsupportedOperationException();
    }

    public void refreshDataModel() {
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"getModificationTracker(...)");
        return psiModificationTracker;
    }

    public void dispose() {
    }
}

