/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import com.jetbrains.python.sdk.skeletons.PyLegacySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyRemoteSkeletonGeneratorBase
extends PyLegacySkeletonGenerator {
    protected HashSet<String> myListedBinaries;

    public PyRemoteSkeletonGeneratorBase(@NotNull String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (skeletonPath == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(0);
        }
        if (pySdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(1);
        }
        super(skeletonPath, pySdk, currentFolder);
        this.myListedBinaries = new HashSet();
    }

    protected static long doneIn(long started) {
        return System.currentTimeMillis() - started;
    }

    @NotNull
    protected List<PyRemoteSourceItem> listSources(@NotNull Sdk sdk, @NotNull List<String> extraSysPathEntries) throws InvalidSdkException, ExecutionException {
        if (sdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(2);
        }
        if (extraSysPathEntries == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(3);
        }
        String homePath = sdk.getHomePath();
        long startTime = System.currentTimeMillis();
        List pathList = ContainerUtil.concat((List)PythonCommandLineState.getAddedPaths((Sdk)sdk), extraSysPathEntries);
        ProcessOutput process = this.commandBuilder().extraSysPath(pathList).extraArgs(new String[]{"-v", "-S"}).timeout(240000).runProcess();
        LOG.info("Retrieving binary module list took " + PyRemoteSkeletonGeneratorBase.doneIn(startTime) + " ms");
        List lines = process.getStdoutLines();
        if (lines.isEmpty()) {
            throw new InvalidSdkException(PythonRemoteInterpreterBundle.message("python.remote.skeleton.generator.empty.output", "generator3/__main__.py", homePath));
        }
        Iterator iter = lines.iterator();
        int generatorVersion = PySkeletonHeader.fromVersionString((String)((String)iter.next()).trim());
        ArrayList<PyRemoteSourceItem> result2 = new ArrayList<PyRemoteSourceItem>();
        boolean end = false;
        while (iter.hasNext()) {
            String line2 = (String)iter.next();
            if ("END".equals(line2 = line2.trim())) {
                end = true;
                break;
            }
            try {
                int size2;
                String[] strs = line2.split("\t");
                String path2 = strs[0];
                String rootPath = strs[1];
                try {
                    size2 = Integer.parseInt(strs[2]);
                }
                catch (Exception e) {
                    size2 = 0;
                }
                PyRemoteSourceItem item = new PyRemoteSourceItem(path2, rootPath, size2);
                result2.add(item);
            }
            catch (Exception e) {
                LOG.error("Error parsing output: " + line2, (Throwable)e);
            }
        }
        if (!end) {
            LOG.error("Skeletons generator: list_sources: no END of output");
        }
        ArrayList<PyRemoteSourceItem> arrayList = result2;
        if (arrayList == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    protected List<PySkeletonGenerator.GenerationResult> runGeneration(@NotNull PySkeletonGenerator.Builder builder, @Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
        if (builder == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(5);
        }
        if (this.hasIndependentRemoteSkeletonsDirectory()) {
            File stateMarkerFile = new File(this.getSkeletonsPath(), ".state.json");
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(stateMarkerFile), StandardCharsets.UTF_8);){
                LOG.debug("Sending skeletons state file to the remote generator: " + stateMarkerFile.getPath());
                String skeletonsState = StreamUtil.readText((Reader)reader);
                builder.extraArgs(new String[]{"--state-file", "-"});
                builder.stdin(skeletonsState);
            }
            catch (FileNotFoundException ignored) {
                builder.extraArgs(new String[]{"--init-state-file"});
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        List results = super.runGeneration(builder, indicator);
        this.myListedBinaries.clear();
        results.stream().map(PySkeletonGenerator.GenerationResult::getModuleOrigin).filter(origin -> !"(built-in)".equals(origin)).forEach(path2 -> this.myListedBinaries.add((String)path2));
        List list2 = results;
        if (list2 == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(6);
        }
        return list2;
    }

    protected boolean hasIndependentRemoteSkeletonsDirectory() {
        return this.getRemoteSkeletonsPath() != null;
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(7);
        }
        return this.myListedBinaries.contains(name);
    }

    @NotNull
    protected PyRemotePathMapper createPathMappings(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        if (remoteSdkAdditionalData == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(8);
        }
        PyRemotePathMapper pathMapper = new PyRemotePathMapper();
        PythonRemoteInterpreterManager.addHelpersMapping((RemoteSdkProperties)remoteSdkAdditionalData, (PyRemotePathMapper)pathMapper);
        String skeletonsPath = this.getRemoteSkeletonsPath();
        if (skeletonsPath != null) {
            pathMapper.addMapping(this.getSkeletonsPath(), skeletonsPath, PyRemotePathMapper.PyPathMappingType.SKELETONS);
        }
        PyRemotePathMapper pyRemotePathMapper = pathMapper = PythonRemoteInterpreterManager.appendBasicMappings((Project)project, (PyRemotePathMapper)pathMapper, (RemoteSdkAdditionalData)remoteSdkAdditionalData);
        if (pyRemotePathMapper == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(9);
        }
        return pyRemotePathMapper;
    }

    public static String[] addUnbuffered(String homePath, String[] commandLine) {
        ArrayList cmd = Lists.newArrayList((Object[])commandLine);
        if (!homePath.contains("jython")) {
            if (cmd.isEmpty()) {
                LOG.warn("Command line is empty for getProcessOutput");
            } else {
                cmd.add(1, "-u");
            }
        }
        commandLine = ArrayUtilRt.toStringArray((Collection)cmd);
        return commandLine;
    }

    @Nullable
    protected String getRemoteSkeletonsPath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSysPathEntries";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "listSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runGeneration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "listSources";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runGeneration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPathMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 9 -> new IllegalStateException(string);
        };
    }
}

