/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter;

import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.remoteInterpreter.PyRemoteSkeletonGeneratorBase;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyRemoteSkeletonGeneratorWithRemoteSources
extends PyRemoteSkeletonGeneratorBase {
    @Nullable
    protected final Project myProject;
    @NotNull
    protected final Sdk mySdk;

    protected PyRemoteSkeletonGeneratorWithRemoteSources(@NotNull String skeletonPath, @NotNull Sdk sdk, @Nullable String currentFolder, @Nullable Project project) {
        if (skeletonPath == null) {
            PyRemoteSkeletonGeneratorWithRemoteSources.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PyRemoteSkeletonGeneratorWithRemoteSources.$$$reportNull$$$0(1);
        }
        super(skeletonPath, sdk, currentFolder);
        this.myProject = project;
        this.mySdk = sdk;
    }

    protected PyRemoteSdkAdditionalData getRemoteSdkAdditionalData() {
        return (PyRemoteSdkAdditionalData)this.mySdk.getSdkAdditionalData();
    }

    public final void refreshGeneratedSkeletons() {
        long started = System.currentTimeMillis();
        try {
            List<PyRemoteSourceItem> allSources = this.listSources(this.mySdk, Collections.singletonList(this.getRemoteSkeletonsPath()));
            String skeletonsLocalPath = this.getSkeletonsPath();
            String sourcesLocalPath = PySdkExtKt.getRemoteSourcesLocalPath((Sdk)this.mySdk).toString();
            ImmutableList sourcesToDownload = FluentIterable.from(allSources).transform(input -> {
                if (!PythonSdkType.isSkeletonsPath((String)input.getRootPath())) {
                    PyRemoteSourceItem item = new PyRemoteSourceItem(input.getPath(), input.getRootPath(), input.getSize());
                    item.setLocalPrefix(input.generateRootFolderName());
                    return item;
                }
                return null;
            }).filter(Predicates.notNull()).toList();
            Collection skeletonsToDownload = Collections2.filter(allSources, input -> PythonSdkType.isSkeletonsPath((String)input.getRootPath()));
            PathMappingSettings mappingSettings = this.getRemoteSdkAdditionalData().getPathMappings();
            for (PyRemoteSourceItem item : sourcesToDownload) {
                item.addRootMappingTo(mappingSettings, sourcesLocalPath);
            }
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            ((PyRemoteSdkAdditionalData)sdkModificator.getSdkAdditionalData()).setPathMappings(mappingSettings);
            Application application = ApplicationManager.getApplication();
            application.invokeAndWait(() -> application.runWriteAction(() -> sdkModificator.commitChanges()));
            this.downloadSources((Collection<PyRemoteSourceItem>)sourcesToDownload, sourcesLocalPath);
            this.downloadSources(skeletonsToDownload, skeletonsLocalPath);
        }
        catch (ExecutionException e) {
            NotificationGroupManager.getInstance().getNotificationGroup("WSL rsync").createNotification(e.getMessage(), NotificationType.ERROR).notify(this.myProject);
            LOG.warn((Throwable)e);
        }
        catch (InvalidSdkException e) {
            LOG.warn((Throwable)e);
        }
        long time = PyRemoteSkeletonGeneratorWithRemoteSources.doneIn(started);
        LOG.info("Sources and skeletons are loaded in " + time + " millis.");
    }

    private void downloadSources(@NotNull Collection<PyRemoteSourceItem> allSources, @NotNull String localPath) throws InvalidSdkException, ExecutionException {
        List sourcesToDownload;
        if (allSources == null) {
            PyRemoteSkeletonGeneratorWithRemoteSources.$$$reportNull$$$0(2);
        }
        if (localPath == null) {
            PyRemoteSkeletonGeneratorWithRemoteSources.$$$reportNull$$$0(3);
        }
        if ((sourcesToDownload = ContainerUtil.filter(allSources, input -> input.shouldCopy(localPath))).isEmpty()) {
            return;
        }
        this.downloadSourcesToLocalFolder(localPath, sourcesToDownload);
        VirtualFile localSourcesFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
        assert (localSourcesFile != null);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{localSourcesFile});
    }

    protected abstract void downloadSourcesToLocalFolder(@NotNull String var1, @NotNull Collection<PyRemoteSourceItem> var2) throws InvalidSdkException, ExecutionException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skeletonPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/remoteInterpreter/PyRemoteSkeletonGeneratorWithRemoteSources";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

