/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000bH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/python/wsl/PyWSLPackageManager;", "Lcom/jetbrains/python/packaging/PyPackageManagerImpl;", "holder", "Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "<init>", "(Lcom/intellij/wsl/remoteSdk/WSLCredentialsHolder;Lcom/intellij/openapi/projectRoots/Sdk;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;)V", "getHelperPath", "", "Lorg/jetbrains/annotations/Nullable;", "helper", "getPythonProcessOutput", "Lcom/intellij/execution/process/ProcessOutput;", "helperPath", "args", "", "askForSudo", "", "showProgress", "workingDir", "pyArgs", "", "toSystemDependentName", "dirName", "intellij.python.wsl"})
final class PyWSLPackageManager
extends PyPackageManagerImpl {
    @NotNull
    private final WSLCredentialsHolder holder;
    @NotNull
    private final PyRemoteSdkAdditionalData data;

    public PyWSLPackageManager(@NotNull WSLCredentialsHolder holder, @NotNull Sdk sdk, @NotNull PyRemoteSdkAdditionalData data) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(sdk);
        this.holder = holder;
        this.data = data;
        this.mySeparator = "/";
    }

    @Nullable
    public String getHelperPath(@NotNull String helper2) {
        Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
        return this.holder.getDistribution().getWslPath(PythonHelpersLocator.Companion.findPathStringInHelpers(helper2));
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir, @Nullable List<String> pyArgs) {
        Intrinsics.checkNotNullParameter((Object)helperPath, (String)"helperPath");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Object[] objectArray = new String[]{this.data.getInterpreterPath(), helperPath};
        List command = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)args);
        ProcessOutput processOutput = new CapturingProcessRunner((BaseProcessHandler)PyWSLUtilsKt.startWslProcess$default(null, new GeneralCommandLine(command), (PyRemoteSdkAdditionalDataBase)this.data, askForSudo, workingDir, false, 32, null)).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @NotNull
    protected String toSystemDependentName(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        return dirName;
    }
}

