/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.project.Project;
import com.intellij.python.wsl.PyWSLUtilsKt;
import com.intellij.python.wsl.PyWslChooserDialog;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyRemoteFilesChooser;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/python/wsl/PyWslFileChooser;", "Lcom/jetbrains/python/remote/PyRemoteFilesChooser;", "<init>", "()V", "chooseRemoteFiles", "", "", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "foldersOnly", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;Z)[Ljava/lang/String;", "intellij.python.wsl"})
final class PyWslFileChooser
implements PyRemoteFilesChooser {
    @NotNull
    public static final PyWslFileChooser INSTANCE = new PyWslFileChooser();

    private PyWslFileChooser() {
    }

    @NotNull
    public String[] chooseRemoteFiles(@NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, boolean foldersOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Result<WSLDistribution, String> it = PyWSLUtilsKt.getDistribution(data);
        boolean bl = false;
        Result<WSLDistribution, String> result2 = it;
        if (!(result2 instanceof Result.Success)) {
            if (result2 instanceof Result.Failure) {
                throw new ExecutionException((String)((Result.Failure)it).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        WSLDistribution distribution = (WSLDistribution)((Result.Success)it).getResult();
        PyWslChooserDialog dialog = new PyWslChooserDialog(project, distribution);
        if (dialog.showAndGet()) {
            String[] stringArray = new String[]{new WebServerConfig.RemotePath((String)dialog.getText().getText()).path};
            return stringArray;
        }
        return new String[0];
    }
}

