/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.template.lang.core.templateLanguages;

import com.google.common.collect.Sets;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.LanguageSubstitutor;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.template.lang.core.templateLanguages.PyTemplateLanguageSubstitutor;
import com.intellij.template.lang.core.templateLanguages.PythonTemplateLanguage;
import com.intellij.template.lang.core.templateLanguages.TemplateSettingsHolder;
import com.intellij.template.lang.core.templateLanguages.TemplatesService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TemplatesService")
public final class PyTemplatesServiceImpl
implements TemplatesService,
PersistentStateComponent<TemplateSettingsBean> {
    private static final String NO_TEMPLATE_LANG = "None";
    private static final NotNullLazyValue<PyTemplateLanguageSubstitutor> PY_TEMPLATE_LANGUAGE_SUBSTITUTOR = NotNullLazyValue.createValue(() -> new PyTemplateLanguageSubstitutor());
    @NotNull
    private final TemplateSettingsBean mySettingsBean = new TemplateSettingsBean();
    @NotNull
    private final List<Runnable> myLanguageSelectedListeners = new ArrayList<Runnable>();
    @NotNull
    private final Map<String, VirtualFileSystem> myTemplateFolderToFs = new ConcurrentHashMap<String, VirtualFileSystem>();

    public TemplateSettingsBean getState() {
        return this.mySettingsBean;
    }

    public void loadState(@NotNull TemplateSettingsBean state) {
        if (state == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this.mySettingsBean);
        if (state.TEMPLATES_IN_JAVASCRIPT) {
            this.mySettingsBean.myTemplateFileTypes.add("JavaScript");
            this.mySettingsBean.TEMPLATES_IN_JAVASCRIPT = false;
        }
    }

    @Override
    public void generateTemplates(@NotNull TemplateSettingsHolder settings, @NotNull VirtualFile baseDir) {
        if (settings == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(2);
        }
        PythonTemplateLanguage templateLanguage = settings.getTemplateLanguage();
        Object templatesFolderPath = settings.getTemplatesFolder();
        String string = this.mySettingsBean.TEMPLATE_CONFIGURATION = templateLanguage == null ? NO_TEMPLATE_LANG : templateLanguage.getTemplateLanguageName();
        if (!StringUtil.isEmptyOrSpaces((String)templatesFolderPath)) {
            try {
                templatesFolderPath = baseDir.getPath() + File.separator + (String)templatesFolderPath;
                VfsUtil.createDirectories((String)templatesFolderPath);
                this.mySettingsBean.TEMPLATE_FOLDERS.add((String)templatesFolderPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @NotNull
    public List<FileType> getTemplateFileTypes() {
        FileTypeRegistry rs = FileTypeRegistry.getInstance();
        List result2 = ContainerUtil.mapNotNull(this.mySettingsBean.myTemplateFileTypes, s -> rs.findFileTypeByName(s));
        List list2 = result2.isEmpty() ? new ArrayList(BASIC_TEMPLATE_TYPES) : result2;
        if (list2 == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public void setTemplateFileTypes(@NotNull List<FileType> fileTypes) {
        if (fileTypes == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(4);
        }
        this.mySettingsBean.setTemplateFileTypes(ContainerUtil.map(fileTypes, o -> o.getName()));
    }

    @Override
    @NotNull
    public List<VirtualFile> getTemplateFolders() {
        List<VirtualFile> list2 = this.mySettingsBean.TEMPLATE_FOLDERS.stream().map(folder -> this.getFs((String)folder).findFileByPath(folder)).filter(o -> o != null && o.isDirectory()).collect(Collectors.toList());
        if (list2 == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Override
    public void setTemplateFolders(VirtualFile ... roots) {
        if (roots == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(6);
        }
        ArrayList<String> templateFolders = new ArrayList<String>(roots.length);
        this.myTemplateFolderToFs.clear();
        for (VirtualFile root : roots) {
            String path2 = root.getPath();
            templateFolders.add(path2);
            this.myTemplateFolderToFs.put(path2, root.getFileSystem());
        }
        this.mySettingsBean.TEMPLATE_FOLDERS = templateFolders;
    }

    @Override
    public void addLanguageSelectedListener(Runnable listener2) {
        this.myLanguageSelectedListeners.add(listener2);
    }

    @Override
    public void removeLanguageSelectedListener(Runnable listener2) {
        this.myLanguageSelectedListeners.remove(listener2);
    }

    @Override
    public void setTemplateLanguage(@Nullable PythonTemplateLanguage language) {
        String languageName;
        String string = languageName = language != null ? language.getTemplateLanguageName() : NO_TEMPLATE_LANG;
        if (!languageName.equals(this.mySettingsBean.TEMPLATE_CONFIGURATION)) {
            this.mySettingsBean.TEMPLATE_CONFIGURATION = languageName;
            this.myLanguageSelectedListeners.forEach(Runnable::run);
        }
    }

    @Override
    @Nullable
    public PythonTemplateLanguage getTemplateLanguage() {
        return (PythonTemplateLanguage)((Object)ContainerUtil.find(PythonTemplateLanguage.getAllTemplateLanguages(), o -> o.getTemplateLanguageName().equals(this.mySettingsBean.TEMPLATE_CONFIGURATION)));
    }

    private static void addLanguageSubstitutorByTypeName(String typeName) {
        Language language = PyTemplatesServiceImpl.getLanguageByFileType(typeName);
        if (language != null) {
            LanguageSubstitutors.getInstance().addExplicitExtension(language, (Object)((LanguageSubstitutor)PY_TEMPLATE_LANGUAGE_SUBSTITUTOR.getValue()));
        }
    }

    private static Language getLanguageByFileType(@NotNull String fileTypeName) {
        FileType[] types;
        if (fileTypeName == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(7);
        }
        for (FileType fileType : types = FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            if (!fileTypeName.equals(fileType.getName()) || !(fileType instanceof LanguageFileType)) continue;
            return ((LanguageFileType)fileType).getLanguage();
        }
        return null;
    }

    private static void removeLanguageSubstitutorByTypeName(String typeName) {
        Language language = PyTemplatesServiceImpl.getLanguageByFileType(typeName);
        if (language != null) {
            LanguageSubstitutors.getInstance().removeExplicitExtension(language, (Object)((LanguageSubstitutor)PY_TEMPLATE_LANGUAGE_SUBSTITUTOR.getValue()));
        }
    }

    @NotNull
    private VirtualFileSystem getFs(@NotNull String folder) {
        if (folder == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(8);
        }
        VirtualFileSystem virtualFileSystem = this.myTemplateFolderToFs.computeIfAbsent(folder, s -> LocalFileSystem.getInstance());
        if (virtualFileSystem == null) {
            PyTemplatesServiceImpl.$$$reportNull$$$0(9);
        }
        return virtualFileSystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/template/lang/core/templateLanguages/PyTemplatesServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/template/lang/core/templateLanguages/PyTemplatesServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFileTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFolders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplates";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateFileTypes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateFolders";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByFileType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9 -> new IllegalStateException(string);
        };
    }

    public static final class TemplateSettingsBean {
        @NotNull
        public String TEMPLATE_CONFIGURATION = "None";
        public boolean TEMPLATES_IN_JAVASCRIPT = false;
        @NotNull
        public List<String> TEMPLATE_FOLDERS = new ArrayList<String>();
        @NotNull
        private List<String> myTemplateFileTypes = new ArrayList<String>();

        @NotNull
        public List<String> getTemplateFileTypes() {
            List<String> list2 = this.myTemplateFileTypes;
            if (list2 == null) {
                TemplateSettingsBean.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public void setTemplateFileTypes(@NotNull List<String> fileTypes) {
            if (fileTypes == null) {
                TemplateSettingsBean.$$$reportNull$$$0(1);
            }
            Set<String> newSet = Set.copyOf(fileTypes);
            Set<String> currentSet = Set.copyOf(this.myTemplateFileTypes);
            for (String add2 : Sets.difference(newSet, currentSet)) {
                PyTemplatesServiceImpl.addLanguageSubstitutorByTypeName(add2);
            }
            for (String remove : Sets.difference(currentSet, newSet)) {
                PyTemplatesServiceImpl.removeLanguageSubstitutorByTypeName(remove);
            }
            this.myTemplateFileTypes = fileTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/template/lang/core/templateLanguages/PyTemplatesServiceImpl$TemplateSettingsBean";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateFileTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/template/lang/core/templateLanguages/PyTemplatesServiceImpl$TemplateSettingsBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setTemplateFileTypes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

