/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.ImmutableSet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.model.applications.DjangoAppConfig;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoCoreUtil {
    private static final Set<String> NAMES = ImmutableSet.of((Object)"urls.py", (Object)"manage.py", (Object)"settings.py", (Object)"views.py");

    protected DjangoCoreUtil() {
    }

    @NotNull
    public static PyRequirement createRequirementAtLeast(int major, int minor) {
        PyRequirement pyRequirement = PyRequirementsKt.pyRequirement((String)"Django", (PyRequirementRelation)PyRequirementRelation.GTE, (String)String.format("%s.%s", major, minor));
        if (pyRequirement == null) {
            DjangoCoreUtil.$$$reportNull$$$0(0);
        }
        return pyRequirement;
    }

    private static boolean isProjectRoot(@Nullable PsiFileSystemItem dir) {
        return dir instanceof PsiDirectory && ((PsiDirectory)dir).findFile("manage.py") != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiFileSystemItem folder) {
        PsiFileSystemItem f;
        if (folder == null) {
            DjangoCoreUtil.$$$reportNull$$$0(1);
        }
        for (f = folder; f != null && !DjangoCoreUtil.isProjectRoot(f); f = f.getParent()) {
        }
        return (PsiDirectory)f;
    }

    @Nullable
    public static Module getDjangoModule(@NotNull Project project) {
        if (project == null) {
            DjangoCoreUtil.$$$reportNull$$$0(2);
        }
        return (Module)ContainerUtil.getFirstItem((List)ProjectFacetManager.getInstance((Project)project).getModulesWithFacet(DjangoFacetType.ID));
    }

    @Nullable
    public static String getProjectRoot(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(3);
        }
        if ((facet = DjangoFacet.getInstance(module)) != null) {
            return ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootPath();
        }
        return null;
    }

    @Nullable
    public static PsiFileSystemItem searchFileOrFolder(String path2, PsiElement contextElement) {
        PsiFile fileOrFolder = DjangoCoreUtil.searchFile(path2, contextElement);
        if (fileOrFolder == null) {
            fileOrFolder = DjangoCoreUtil.searchFolder(path2, contextElement);
        }
        return fileOrFolder;
    }

    @Nullable
    public static PsiFile searchFile(String path2, PsiElement contextElement) {
        PsiFile file = DjangoCoreUtil.searchProjectFile(path2, contextElement);
        if (file == null) {
            file = DjangoCoreUtil.getLibraryFile(path2, contextElement);
        }
        return file;
    }

    @Nullable
    public static PsiDirectory searchFolder(@NotNull String path2, @NotNull PsiElement contextElement) {
        PsiDirectory file;
        if (path2 == null) {
            DjangoCoreUtil.$$$reportNull$$$0(4);
        }
        if (contextElement == null) {
            DjangoCoreUtil.$$$reportNull$$$0(5);
        }
        if ((file = DjangoCoreUtil.searchProjectFolder(path2, contextElement, null)) == null) {
            file = DjangoCoreUtil.getLibraryFolder(path2, contextElement);
        }
        return file;
    }

    @Nullable
    public static PsiFile searchProjectFile(String path2, @NotNull PsiElement contextElement) {
        String elementProjectName;
        if (contextElement == null) {
            DjangoCoreUtil.$$$reportNull$$$0(6);
        }
        PsiDirectory djangoRoot = DjangoCoreUtil.getProjectRoot(contextElement);
        String projectName = PythonStringUtil.getFirstPrefix((String)path2, (String)".");
        PsiFile result2 = projectName.equals(elementProjectName = DjangoCoreUtil.getProjectName(contextElement)) ? DjangoCoreUtil.searchInProject(djangoRoot, PythonStringUtil.removeFirstPrefix((String)path2, (String)".")) : DjangoCoreUtil.searchInProject(djangoRoot, path2);
        if (result2 != null) {
            return result2;
        }
        result2 = DjangoPsiUtil.findFileInRoots(path2, contextElement);
        return result2;
    }

    @Nullable
    public static PsiDirectory searchProjectFolder(@NotNull String path2, @NotNull PsiElement contextElement, @Nullable Module withModule) {
        String elementProjectName;
        String projectName;
        String viewsPath;
        PsiDirectory djangoRoot;
        PsiDirectory result2;
        if (path2 == null) {
            DjangoCoreUtil.$$$reportNull$$$0(7);
        }
        if (contextElement == null) {
            DjangoCoreUtil.$$$reportNull$$$0(8);
        }
        if ((result2 = DjangoPsiUtil.findFolder(djangoRoot = DjangoCoreUtil.getProjectRoot(contextElement), viewsPath = (projectName = PythonStringUtil.getFirstPrefix((String)path2, (String)".")).equals(elementProjectName = DjangoCoreUtil.getProjectName(contextElement)) ? DjangoPythonUtil.toFolderPath(PythonStringUtil.removeFirstPrefix((String)path2, (String)".")) : DjangoPythonUtil.toFolderPath(path2))) != null) {
            return result2;
        }
        QualifiedName qName = QualifiedName.fromDottedString((String)path2);
        PyQualifiedNameResolveContext context = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement) == null && withModule != null ? PyResolveImportUtil.fromModule((Module)withModule) : PyResolveImportUtil.fromFoothold((PsiElement)contextElement);
        return StreamEx.of((Collection)PyResolveImportUtil.resolveQualifiedName((QualifiedName)qName, (PyQualifiedNameResolveContext)context)).select(PsiDirectory.class).findFirst().orElse(null);
    }

    @Nullable
    public static PsiFile searchInProject(PsiDirectory djangoRoot, String appPath) {
        String viewsPath = DjangoPythonUtil.toFilePath(appPath);
        return DjangoPsiUtil.findChild(djangoRoot, viewsPath);
    }

    @Nullable
    public static PsiFile getLibraryFile(String path2, PsiElement contextElement) {
        VirtualFile file = DjangoPythonUtil.findLibraryFile(DjangoPythonUtil.toFilePath(path2), PythonSdkUtil.findPythonSdk((PsiElement)contextElement));
        return file != null && file.isValid() ? contextElement.getManager().findFile(file) : null;
    }

    @Nullable
    public static PsiDirectory getLibraryFolder(String path2, PsiElement contextElement) {
        VirtualFile file = DjangoPythonUtil.findLibraryFile(DjangoPythonUtil.toFolderPath(path2), PythonSdkUtil.findPythonSdk((PsiElement)contextElement));
        return file != null ? contextElement.getManager().findDirectory(file) : null;
    }

    public static void addDjangoPathToEnv(@NotNull String djangoPath, Map<String, String> envs) {
        if (djangoPath == null) {
            DjangoCoreUtil.$$$reportNull$$$0(9);
        }
        String djangoRoot = DjangoCoreUtil.removeDjangoBin(djangoPath);
        PythonEnvUtil.addToPythonPath(envs, (String)FileUtil.toSystemDependentName((String)djangoRoot));
    }

    public static String getManageScript(@Nullable Module module) {
        VirtualFile manageFile;
        if (module == null) {
            return "";
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet != null && (manageFile = DjangoCoreUtil.getManageFile(module)) != null) {
            return manageFile.getPath();
        }
        return "";
    }

    @Nullable
    public static String getDjangoAdmin(String sdkHome) {
        String admin = "django-admin.py";
        Path path2 = PythonSdkUtil.getExecutablePath((Path)Path.of(sdkHome, new String[0]), (String)admin);
        return path2 != null ? path2.toString() : null;
    }

    @Nullable
    @RequiresBackgroundThread(generateAssertion=false)
    public static VirtualFile getSettingsFile(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(10);
        }
        if ((facet = DjangoFacet.getInstance(module)) == null) {
            return null;
        }
        return DjangoCoreUtil.getSettingsFile(facet);
    }

    @Nullable
    @RequiresBackgroundThread(generateAssertion=false)
    public static VirtualFile getSettingsFile(@NotNull DjangoFacet facet) {
        if (facet == null) {
            DjangoCoreUtil.$$$reportNull$$$0(11);
        }
        return DjangoCoreUtil.resolveFileFromDjangoProjectRoot(((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile(), ((DjangoFacetConfiguration)facet.getConfiguration()).getSettingsFilePath());
    }

    @Nullable
    public static VirtualFile getManageFile(@NotNull Module module) {
        DjangoFacet facet;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(12);
        }
        if ((facet = DjangoFacet.getInstance(module)) != null) {
            return DjangoCoreUtil.resolveFileFromDjangoProjectRoot(((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile(), ((DjangoFacetConfiguration)facet.getConfiguration()).getManageFilePath());
        }
        return null;
    }

    @Nullable
    @RequiresBackgroundThread(generateAssertion=false)
    private static VirtualFile resolveFileFromDjangoProjectRoot(@Nullable VirtualFile djangoProjectRoot, @NotNull String filePath2) {
        if (filePath2 == null) {
            DjangoCoreUtil.$$$reportNull$$$0(13);
        }
        if (djangoProjectRoot == null) {
            return null;
        }
        return com.intellij.openapi.vfs.VirtualFileUtil.resolveFromRootOrRelative((VirtualFile)djangoProjectRoot, (String)filePath2);
    }

    public static Map<String, String> addModuleToEnv(@NotNull Module module, @NotNull Map<String, String> envs, @Nullable VirtualFile file, @NotNull String envName) {
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(14);
        }
        if (envs == null) {
            DjangoCoreUtil.$$$reportNull$$$0(15);
        }
        if (envName == null) {
            DjangoCoreUtil.$$$reportNull$$$0(16);
        }
        if (file != null) {
            String moduleToImport = DjangoCoreUtil.getImportableModule(module, file);
            envs.put(envName, moduleToImport);
        }
        return envs;
    }

    public static String getSettingsModule(@NotNull Module module) {
        VirtualFile settingsFile;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(17);
        }
        if ((settingsFile = DjangoCoreUtil.getSettingsFile(module)) != null) {
            return DjangoCoreUtil.getImportableModule(module, settingsFile);
        }
        return "settings";
    }

    public static String getImportableModule(@NotNull Module module, @NotNull VirtualFile file) {
        String moduleToImport;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(18);
        }
        if (file == null) {
            DjangoCoreUtil.$$$reportNull$$$0(19);
        }
        if ((moduleToImport = QualifiedNameFinder.findShortestImportableName((Module)module, (VirtualFile)file)) == null) {
            moduleToImport = FileUtilRt.getNameWithoutExtension((String)file.getName());
        }
        return moduleToImport;
    }

    public static boolean isDjangoAvailable(@NotNull Module module, String sdkHome) {
        Sdk pythonSdk;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(20);
        }
        if ((pythonSdk = PythonSdkUtil.findSdkByPath((String)sdkHome)) == null) {
            return false;
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromSdk((Project)module.getProject(), (Sdk)pythonSdk);
        List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)"django"), (PyQualifiedNameResolveContext)context);
        return !results.isEmpty();
    }

    @NotNull
    public static List<String> getDjangoVersionParts(@NotNull PyPackage djangoPackage) {
        if (djangoPackage == null) {
            DjangoCoreUtil.$$$reportNull$$$0(21);
        }
        List list2 = StringUtil.split((String)djangoPackage.getVersion(), (String)".");
        if (list2 == null) {
            DjangoCoreUtil.$$$reportNull$$$0(22);
        }
        return list2;
    }

    public static StringPattern createDjangoStandardProjectFileNamePattern() {
        return StandardPatterns.string().oneOf(NAMES);
    }

    @Nullable
    public static String getDjangoPath(Sdk sdk) {
        VirtualFile[] roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        return DjangoCoreUtil.getDjangoPath(roots);
    }

    @Nullable
    private static String getDjangoPath(VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            VirtualFile binFolder;
            if (SystemInfo.isLinux && "python-django".equals(root.getName()) && (binFolder = root.findChild("bin")) != null) {
                return binFolder.getPath();
            }
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            VirtualFile djangoBinFolder = lfs.refreshAndFindFileByIoFile(new File(root.getPath(), "django/bin"));
            if (djangoBinFolder == null) continue;
            return djangoBinFolder.getPath();
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjango(VirtualFile root) {
        return DjangoCoreUtil.findDjango(root, 3);
    }

    @Nullable
    private static VirtualFile findDjango(final VirtualFile root, int depth) {
        final Ref result2 = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.limit((int)depth)}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                VirtualFile rootPackage;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file.isDirectory() && (rootPackage = DjangoCoreUtil.findDjangoRootPackage(file)) != null) {
                    result2.set((Object)rootPackage);
                    VirtualFileVisitor.Result result22 = 1.skipTo((VirtualFile)root);
                    if (result22 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result22;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return result3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/django/util/DjangoCoreUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/django/util/DjangoCoreUtil$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        });
        return (VirtualFile)result2.get();
    }

    @Nullable
    public static VirtualFile findDjangoRootPackage(@NotNull VirtualFile root) {
        if (root == null) {
            DjangoCoreUtil.$$$reportNull$$$0(23);
        }
        for (VirtualFile child : root.getChildren()) {
            VirtualFile bin2;
            if (!child.isDirectory() || !child.getName().equals("django") || (bin2 = DjangoCoreUtil.findDjangoBin(child)) == null) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static VirtualFile findDjangoBin(@NotNull VirtualFile root) {
        if (root == null) {
            DjangoCoreUtil.$$$reportNull$$$0(24);
        }
        for (VirtualFile child : root.getChildren()) {
            if (!child.isDirectory() || !child.getName().equals("bin")) continue;
            for (VirtualFile grandchild : child.getChildren()) {
                if (grandchild.isDirectory() || !grandchild.getName().equals("django-admin.py")) continue;
                return grandchild;
            }
        }
        return null;
    }

    public static boolean isInsideDjango(VirtualFile file, @Nullable VirtualFile stopAt) {
        while (file != null) {
            if (Comparing.equal((Object)file, (Object)stopAt)) {
                return false;
            }
            if (DjangoCoreUtil.findDjangoRootPackage(file) != null) {
                return true;
            }
            file = file.getParent();
        }
        return false;
    }

    @Nullable
    public static String getExistingFileForName(@NotNull VirtualFile root, String path2) {
        VirtualFile file;
        if (root == null) {
            DjangoCoreUtil.$$$reportNull$$$0(25);
        }
        if ((file = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)path2))) != null) {
            return file.getName();
        }
        List<String> files = DjangoCoreUtil.getFilesInRoot(root.getPath(), FileUtilRt.getNameWithoutExtension((String)path2));
        if (files.size() > 0) {
            return files.get(0);
        }
        return null;
    }

    public static List<String> getFilesInRoot(@Nullable String projectRoot, @NotNull String name) {
        File root;
        if (name == null) {
            DjangoCoreUtil.$$$reportNull$$$0(26);
        }
        ArrayList<String> names2 = new ArrayList<String>();
        if (projectRoot != null && (root = new File(projectRoot)).exists()) {
            for (File file : root.listFiles(new NameFileFilter(name))) {
                names2.add(file.getName());
            }
        }
        Collections.sort(names2);
        return names2;
    }

    @Nullable
    public static String getProjectName(PsiElement elem) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)elem);
        if (module == null) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        return ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectName();
    }

    public static boolean isDjangoTemplateDocument(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DjangoCoreUtil.$$$reportNull$$$0(27);
        }
        if (project == null) {
            DjangoCoreUtil.$$$reportNull$$$0(28);
        }
        Ref result2 = Ref.create((Object)false);
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                result2.set((Object)(psiFile.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE) != null ? 1 : 0));
            }
        });
        return (Boolean)result2.get();
    }

    public static boolean isDjangoTemplateByExtension(@NotNull VirtualFile file) {
        if (file == null) {
            DjangoCoreUtil.$$$reportNull$$$0(29);
        }
        return DjangoCoreUtil.hasDjangoTemplateExtension(file.getName());
    }

    public static boolean hasDjangoTemplateExtension(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        String extension = PythonStringUtil.getLastSuffix((String)name, (String)".");
        if (StringUtil.isEmpty((String)extension)) {
            return false;
        }
        FileType type = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        return DjangoCoreUtil.isTemplateFileType(type);
    }

    private static boolean isTemplateFileType(@NotNull FileType type) {
        if (type == null) {
            DjangoCoreUtil.$$$reportNull$$$0(30);
        }
        return type.equals(HtmlFileType.INSTANCE) || type.equals(XHtmlFileType.INSTANCE) || type.equals(XmlFileType.INSTANCE) || type instanceof LanguageFileType && DjangoCoreUtil.isJavaScriptFileType((LanguageFileType)type);
    }

    public static Presentation updateDjangoRequiredAction(AnActionEvent e) {
        Module module;
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && (module = DjangoCoreUtil.getDjangoModule(project)) != null) {
            presentation.setEnabledAndVisible(true);
            return presentation;
        }
        module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (module != null && DjangoCoreUtil.containsDjango(module)) {
            presentation.setEnabledAndVisible(true);
        }
        return presentation;
    }

    public static boolean containsDjango(Module module) {
        VirtualFile djangoRoot;
        VirtualFile projectRootFolderFile;
        DjangoBinSearchingPolicy policy = new DjangoBinSearchingPolicy();
        String binPath = (String)ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)policy, null);
        if (binPath != null) {
            return true;
        }
        if (DjangoCoreUtil.getDjangoPath(ModuleRootManager.getInstance((Module)module).getContentRoots()) != null) {
            return true;
        }
        DjangoFacet djangoFacet = DjangoFacet.getInstance(module);
        return djangoFacet != null && (projectRootFolderFile = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null && (djangoRoot = DjangoCoreUtil.findDjangoRootPackage(projectRootFolderFile)) != null;
    }

    @Nullable
    public static PsiDirectory getProjectRoot(@NotNull PsiElement element) {
        Project project;
        Module module;
        if (element == null) {
            DjangoCoreUtil.$$$reportNull$$$0(31);
        }
        if ((module = DjangoCoreUtil.getDjangoModule(project = element.getProject())) == null) {
            return null;
        }
        VirtualFile projectRoot = VirtualFileUtil.findFile(DjangoCoreUtil.getProjectRoot(module));
        if (projectRoot != null) {
            return PsiManager.getInstance((Project)project).findDirectory(projectRoot);
        }
        PsiFile psiFile = DjangoPsiUtil.getFile(element);
        if (psiFile == null) {
            return null;
        }
        PsiDirectory parent = psiFile.getParent();
        return parent != null ? DjangoCoreUtil.getProjectRoot((PsiFileSystemItem)parent) : null;
    }

    @Nullable
    public static String getDjangoPath(@NotNull Module module) {
        String djangoBin;
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(32);
        }
        if ((djangoBin = (String)ModuleRootManager.getInstance((Module)module).processOrder((RootPolicy)new DjangoBinSearchingPolicy(), null)) == null) {
            djangoBin = DjangoCoreUtil.getDjangoPath(ModuleRootManager.getInstance((Module)module).getContentRoots());
        }
        if (djangoBin != null) {
            String path2 = DjangoCoreUtil.removeDjangoBin(djangoBin);
            return FileUtil.toSystemDependentName((String)path2);
        }
        return null;
    }

    private static String removeDjangoBin(@NotNull String djangoBin) {
        if (djangoBin == null) {
            DjangoCoreUtil.$$$reportNull$$$0(33);
        }
        return djangoBin.substring(0, djangoBin.length() - "django/bin".length());
    }

    public static List<String> getInstalledAppLabels(@NotNull Module module) {
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(34);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        List<DjangoAppConfig> apps = DjangoSettingsPy.getInstalledApps(module);
        for (DjangoAppConfig app : apps) {
            result2.add(app.getLabel());
        }
        return result2;
    }

    public static QualifiedName appLabelToQName(Module module, String appLabel) {
        List<DjangoAppConfig> apps = DjangoSettingsPy.getInstalledApps(module);
        for (DjangoAppConfig app : apps) {
            if (!app.getLabel().equals(appLabel)) continue;
            return QualifiedName.fromDottedString((String)app.getName());
        }
        return null;
    }

    @NotNull
    public static List<PsiDirectory> getApplications(@NotNull Module module) {
        if (module == null) {
            DjangoCoreUtil.$$$reportNull$$$0(35);
        }
        PyQualifiedNameResolveContext context = PyResolveImportUtil.fromModule((Module)module).copyWithPlainDirectories();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        List list2 = ((StreamEx)StreamEx.of(DjangoSettingsPy.getInstalledApps(module)).flatMap(s -> PyResolveImportUtil.resolveQualifiedName((QualifiedName)QualifiedName.fromDottedString((String)s.getName()), (PyQualifiedNameResolveContext)context).stream()).select(PsiDirectory.class).filter(directory -> fileIndex.isInContent(directory.getVirtualFile()))).toList();
        if (list2 == null) {
            DjangoCoreUtil.$$$reportNull$$$0(36);
        }
        return list2;
    }

    public static boolean isJavaScriptFileType(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            DjangoCoreUtil.$$$reportNull$$$0(37);
        }
        return "JavaScript".equals(fileType.getLanguage().getID());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/util/DjangoCoreUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoPackage";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoBin";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequirementAtLeast";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/util/DjangoCoreUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDjangoVersionParts";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplications";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoModule";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "searchFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "searchProjectFolder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDjangoPathToEnv";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getManageFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileFromDjangoProjectRoot";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addModuleToEnv";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsModule";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportableModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoAvailable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoVersionParts";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoRootPackage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findDjangoBin";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getExistingFileForName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilesInRoot";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateDocument";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDjangoTemplateByExtension";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateFileType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDjangoPath";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "removeDjangoBin";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledAppLabels";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getApplications";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isJavaScriptFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 37 -> new IllegalArgumentException(string);
        };
    }

    private static class NameFileFilter
    implements FileFilter {
        private final String name;

        NameFileFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(File file) {
            String name = file.getName();
            return file.isFile() && name.endsWith(".py") && name.contains("settings");
        }
    }

    public static class DjangoBinSearchingPolicy
    extends RootPolicy<String> {
        @Nullable
        public String visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, String value2) {
            if (jdkOrderEntry == null) {
                DjangoBinSearchingPolicy.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                value2 = DjangoCoreUtil.getDjangoPath(jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value2;
        }

        @Nullable
        public String visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, String value2) {
            if (libraryOrderEntry == null) {
                DjangoBinSearchingPolicy.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                value2 = DjangoCoreUtil.getDjangoPath(libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
            }
            return value2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libraryOrderEntry";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/util/DjangoCoreUtil$DjangoBinSearchingPolicy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJdkOrderEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLibraryOrderEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ManageFileFinder
    implements Processor<VirtualFile> {
        private VirtualFile myManageFile;

        private ManageFileFinder() {
        }

        public boolean process(VirtualFile file) {
            if (!file.isDirectory() && "manage.py".equals(file.getName())) {
                this.myManageFile = file;
                return false;
            }
            return true;
        }
    }
}

