/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.util;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.django.util.DjangoPythonUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonDataflowUtil {
    private PythonDataflowUtil() {
    }

    @Nullable
    public static Set<LookupElement> getDictionaryKeys(PyExpression expr) {
        Set<LookupElement> result2;
        if (expr instanceof PyDictLiteralExpression) {
            return DjangoPythonUtil.getKeys((PyDictLiteralExpression)expr);
        }
        if (expr instanceof PyCallExpression && (result2 = PythonDataflowUtil.processCall((PyCallExpression)expr)) != null) {
            return result2;
        }
        if (expr instanceof PyReferenceExpression) {
            return PythonDataflowUtil.processVariableReference(expr);
        }
        return Collections.emptySet();
    }

    @Nullable
    private static Set<LookupElement> processCall(PyCallExpression call) {
        String text2 = call.getCallee().getText();
        if ("locals".equals(text2)) {
            return PythonDataflowUtil.getLocals((PyElement)call);
        }
        if ("dict".equals(text2)) {
            return PythonDataflowUtil.processDictConstructorCall(call);
        }
        return null;
    }

    private static Set<LookupElement> processVariableReference(PyExpression expr) {
        final String name = expr.getText();
        PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        if (func == null) {
            return null;
        }
        final HashSet<LookupElement> result2 = new HashSet<LookupElement>();
        PyRecursiveElementVisitor visitor = new PyRecursiveElementVisitor(){

            public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Pair<PyExpression, PyExpression> targetValue : DjangoPythonUtil.getTargetsToValuesMapping(node)) {
                    PyStringLiteralExpression key;
                    PyExpression left = (PyExpression)targetValue.getFirst();
                    if (DjangoPythonUtil.isVariable(left, name)) {
                        Set<LookupElement> callDict;
                        PyExpression value2 = (PyExpression)targetValue.getSecond();
                        if (value2 instanceof PyDictLiteralExpression) {
                            result2.addAll(DjangoPythonUtil.getKeys((PyDictLiteralExpression)value2));
                        }
                        if (!(value2 instanceof PyCallExpression) || (callDict = PythonDataflowUtil.processCall((PyCallExpression)value2)) == null) continue;
                        result2.addAll(callDict);
                        continue;
                    }
                    if (!DjangoPythonUtil.isKeyAccess(left, name) || (key = DjangoPythonUtil.getKey(left)) == null) continue;
                    result2.add(LookupElementBuilder.createWithSmartPointer((String)key.getStringValue(), (PsiElement)key));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/django/util/PythonDataflowUtil$1", "visitPyAssignmentStatement"));
            }
        };
        func.accept((PsiElementVisitor)visitor);
        return result2;
    }

    @Nullable
    private static Set<LookupElement> processDictConstructorCall(PyCallExpression call) {
        boolean keyword = true;
        HashSet<LookupElement> result2 = new HashSet<LookupElement>();
        for (PyExpression ex : call.getArguments()) {
            if (!(ex instanceof PyKeywordArgument)) {
                keyword = false;
                break;
            }
            PyKeywordArgument kw = (PyKeywordArgument)ex;
            if (kw.getKeywordNode() == null || kw.getKeyword() == null) continue;
            result2.add((LookupElement)LookupElementBuilder.createWithSmartPointer((String)kw.getKeyword(), (PsiElement)kw.getKeywordNode().getPsi()));
        }
        if (keyword) {
            return result2;
        }
        if (call.getArguments().length == 1) {
            return PythonDataflowUtil.getDictionaryKeys(call.getArguments()[0]);
        }
        return null;
    }

    public static Set<PyCallExpression> getCalls(PyExpression expr) {
        PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
        if (call != null) {
            return Collections.singleton(call);
        }
        HashSet<PyCallExpression> result2 = new HashSet<PyCallExpression>();
        PyStatement stat = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PyStatement.class);
        if (stat instanceof PyAssignmentStatement) {
            PyAssignmentStatement assign = (PyAssignmentStatement)stat;
            for (Pair<PyExpression, PyExpression> pair2 : DjangoPythonUtil.getTargetsToValuesMapping(assign)) {
                if (!((PyExpression)pair2.getSecond()).equals(expr)) continue;
                CallVisitor visitor = new CallVisitor(stat, expr, result2);
                stat.getParent().accept((PsiElementVisitor)visitor);
            }
        }
        return result2;
    }

    private static boolean isCallWithArgument(@NotNull PyCallExpression call, @NotNull PyExpression arg) {
        PyArgumentList args;
        if (call == null) {
            PythonDataflowUtil.$$$reportNull$$$0(0);
        }
        if (arg == null) {
            PythonDataflowUtil.$$$reportNull$$$0(1);
        }
        if ((args = call.getArgumentList()) != null) {
            PyResolveContext context = PyResolveContext.defaultContext((TypeEvalContext)TypeEvalContext.codeInsightFallback((Project)call.getProject()));
            for (PyExpression callArg : args.getArguments()) {
                QualifiedResolveResult res;
                if (callArg instanceof PyReferenceExpressionImpl && arg.equals((res = ((PyReferenceExpressionImpl)callArg).followAssignmentsChain(context)).getElement())) {
                    return true;
                }
                if (!arg.equals(callArg)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<LookupElement> getLocals(PyElement element) {
        ArrayList ret = new ArrayList();
        PsiElement realContext = PyPsiUtils.getRealContext((PsiElement)element);
        CompletionVariantsProcessor processor = new CompletionVariantsProcessor((PsiElement)element, psiElement -> psiElement instanceof PyTargetExpression || psiElement instanceof PyParameter, null);
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)realContext, PyFunction.class);
        if (function != null) {
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor, (ScopeOwner)function, null, (PsiElement)function);
            ret.addAll(processor.getResultList());
        }
        return Sets.newLinkedHashSet(ret);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "arg";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/django/util/PythonDataflowUtil";
        objectArray[2] = "isCallWithArgument";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CallVisitor
    extends PyRecursiveElementVisitor {
        private final PyStatement myStartStatement;
        private final PyExpression myArgument;
        private boolean myStarted = false;
        private final Set<PyCallExpression> myResult;

        private CallVisitor(PyStatement startStatement, PyExpression argument, Set<PyCallExpression> result2) {
            this.myStartStatement = startStatement;
            this.myArgument = argument;
            this.myResult = result2;
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                CallVisitor.$$$reportNull$$$0(0);
            }
            if (this.myStarted && PythonDataflowUtil.isCallWithArgument(node, this.myArgument)) {
                this.myResult.add(node);
            }
            super.visitPyCallExpression(node);
        }

        public void visitPyAssignmentStatement(@NotNull PyAssignmentStatement node) {
            if (node == null) {
                CallVisitor.$$$reportNull$$$0(1);
            }
            if (node.equals(this.myStartStatement)) {
                this.myStarted = true;
            }
            super.visitPyAssignmentStatement(node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "node";
            objectArray2[1] = "com/jetbrains/django/util/PythonDataflowUtil$CallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyAssignmentStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

