/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.utils;

public final class StringUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private StringUtils() {
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return StringUtils.bytesToHexString(bytes, 0, bytes.length);
    }

    public static String bytesToHexString(byte[] bytes, int offset2, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Negative length " + length);
        }
        if (offset2 < 0) {
            throw new IndexOutOfBoundsException("Negative start offset " + offset2);
        }
        if (length > bytes.length - offset2) {
            throw new IndexOutOfBoundsException("Invalid range, bytes.length: " + bytes.length + " offset: " + offset2 + " length: " + length);
        }
        char[] chars = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int unsignedInt = bytes[i + offset2] & 0xFF;
            chars[2 * i] = HEX_CHARS[unsignedInt >>> 4];
            chars[2 * i + 1] = HEX_CHARS[unsignedInt & 0xF];
        }
        return new String(chars);
    }
}

