/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.util.TimeZone;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcClientRequestProcessor;
import org.apache.xmlrpc.XmlRpcClientResponseProcessor;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcTransport;

public class XmlRpcClientWorker {
    protected XmlRpcClientRequestProcessor requestProcessor;
    protected XmlRpcClientResponseProcessor responseProcessor;
    private static final Object PROCESSING_ERROR_FLAG = new Object();

    public XmlRpcClientWorker(TimeZone tz) {
        this(new XmlRpcClientRequestProcessor(tz), new XmlRpcClientResponseProcessor(tz));
    }

    public XmlRpcClientWorker(XmlRpcClientRequestProcessor requestProcessor, XmlRpcClientResponseProcessor responseProcessor) {
        this.requestProcessor = requestProcessor;
        this.responseProcessor = responseProcessor;
    }

    public Object execute(XmlRpcClientRequest xmlRpcRequest, XmlRpcTransport transport) throws XmlRpcException, XmlRpcClientException, IOException {
        long now = 0L;
        if (XmlRpc.debug) {
            now = System.currentTimeMillis();
        }
        boolean endClientRequestDone = false;
        try {
            byte[] request2 = this.requestProcessor.encodeRequestBytes(xmlRpcRequest, this.responseProcessor.getEncoding());
            InputStream is = transport.sendXmlRpc(request2);
            Object response = this.responseProcessor.decodeResponse(is);
            endClientRequestDone = true;
            transport.endClientRequest();
            if (response != null && response instanceof XmlRpcException) {
                throw (XmlRpcException)response;
            }
            Object object = response;
            return object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (XmlRpcClientException xrce) {
            throw xrce;
        }
        catch (RuntimeException x2) {
            if (XmlRpc.debug) {
                x2.printStackTrace();
            }
            throw new XmlRpcClientException("Unexpected exception in client processing", x2);
        }
        finally {
            if (XmlRpc.debug) {
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
            }
            if (!endClientRequestDone) {
                try {
                    transport.endClientRequest();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    protected boolean canReUse() {
        return this.responseProcessor.canReUse() && this.requestProcessor.canReUse();
    }
}

