/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0004)*+,BU\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000bJ$\u0010%\u001a\u00020\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0003J\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020(R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "", "domainValues", "", "transformedValues", "", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "labels", "", "fixed", "", "formatter", "Lkotlin/Function1;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/Transform;Ljava/util/List;ZLkotlin/jvm/functions/Function1;)V", "getDomainValues", "()Ljava/util/List;", "getFixed", "()Z", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "isEmpty", "getLabels", "size", "", "getSize", "()I", "getTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "getTransformedValues", "filterByTransformedLimits", "limits", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "projectOnAxis", "axisDomain", "axisLength", "isHorizontal", "withFixedBreaks", "withOneBreak", "withTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "Companion", "ContinuousFlex", "DemoAndTest", "Fixed", "plot-base"})
@SourceDebugExtension(value={"SMAP\nScaleBreaks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1#2:299\n1549#3:300\n1620#3,3:301\n1559#3:304\n1590#3,4:305\n1559#3:309\n1590#3,4:310\n*S KotlinDebug\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks\n*L\n50#1:300\n50#1:301,3\n103#1:304\n103#1:305,4\n110#1:309\n110#1:310,4\n*E\n"})
public final class ScaleBreaks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Object> domainValues;
    @NotNull
    private final List<Double> transformedValues;
    @NotNull
    private final Transform transform;
    @NotNull
    private final List<String> labels;
    private final boolean fixed;
    @NotNull
    private final Function1<Object, String> formatter;
    @NotNull
    private static final Function1<Object, String> IDENTITY_FORMATTER = Companion.IDENTITY_FORMATTER.1.INSTANCE;
    @NotNull
    private static final Function1<Object, String> DUMMY_FORMATTER = Companion.DUMMY_FORMATTER.1.INSTANCE;
    @NotNull
    private static final ScaleBreaks EMPTY = new ScaleBreaks(CollectionsKt.emptyList(), CollectionsKt.emptyList(), Transforms.INSTANCE.getIDENTITY(), CollectionsKt.emptyList(), true, DUMMY_FORMATTER);

    private ScaleBreaks(List<? extends Object> domainValues, List<Double> transformedValues, Transform transform2, List<String> labels, boolean fixed, Function1<Object, String> formatter2) {
        this.domainValues = domainValues;
        this.transformedValues = transformedValues;
        this.transform = transform2;
        this.labels = labels;
        this.fixed = fixed;
        this.formatter = formatter2;
        if (!(this.domainValues.size() == this.transformedValues.size())) {
            boolean $i$a$-check-ScaleBreaks$32 = false;
            String $i$a$-check-ScaleBreaks$32 = "Scale breaks size: " + this.domainValues.size() + " transformed size: " + this.transformedValues.size() + " but expected to be the same";
            throw new IllegalStateException($i$a$-check-ScaleBreaks$32.toString());
        }
        if (!(this.domainValues.size() == this.transformedValues.size())) {
            boolean bl = false;
            String string = "Scale breaks size: " + this.domainValues.size() + " transformed size: " + this.transformedValues.size() + " but expected to be the same";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final List<Object> getDomainValues() {
        return this.domainValues;
    }

    @NotNull
    public final List<Double> getTransformedValues() {
        return this.transformedValues;
    }

    @NotNull
    public final Transform getTransform() {
        return this.transform;
    }

    @NotNull
    public final List<String> getLabels() {
        return this.labels;
    }

    public final boolean getFixed() {
        return this.fixed;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    public final boolean isEmpty() {
        return this.domainValues.isEmpty();
    }

    public final int getSize() {
        return this.domainValues.size();
    }

    @NotNull
    public final ScaleBreaks withOneBreak() {
        if (!(!this.isEmpty())) {
            boolean bl = false;
            String string = "Can't get one break from an empty scale breaks.";
            throw new IllegalStateException(string.toString());
        }
        return new ScaleBreaks(this.domainValues.subList(0, 1), this.transformedValues.subList(0, 1), this.transform, this.labels.subList(0, 1), this.fixed, this.formatter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScaleBreaks withFixedBreaks(@NotNull List<? extends Object> domainValues, @Nullable List<String> labels) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
        List list2 = labels;
        if (list2 == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            iterable = domainValues;
            Function1<Object, String> transform$iv = this.formatter;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
            }
            list2 = (List)destination$iv$iv;
        }
        List labels2 = list2;
        iterable = ScaleBreaks.Companion.applyTransformAndDropNulls(this.transform, domainValues, labels2);
        List filteredDomainValues = (List)iterable.component1();
        List filteredTransformedValues = (List)iterable.component2();
        List filteredLabels = (List)iterable.component3();
        return new ScaleBreaks(filteredDomainValues, filteredTransformedValues, this.transform, filteredLabels, true, this.formatter);
    }

    @NotNull
    public final ScaleBreaks withTransform(@NotNull ContinuousTransform transform2) {
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        Triple triple = ScaleBreaks.Companion.applyTransformAndDropNulls(transform2, this.domainValues, this.labels);
        List filteredDomainValues = (List)triple.component1();
        List filteredTransformedValues = (List)triple.component2();
        List filteredLabels = (List)triple.component3();
        return new ScaleBreaks(filteredDomainValues, filteredTransformedValues, transform2, filteredLabels, this.fixed, this.formatter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> projectOnAxis(@NotNull DoubleSpan axisDomain, double axisLength, boolean isHorizontal) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        boolean reverse = !isHorizontal;
        ScaleMapper<Double> mapper = Mappers.INSTANCE.linear(axisDomain, new DoubleSpan(0.0, axisLength), reverse);
        Iterable $this$mapIndexed$iv = this.transformedValues;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void v;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv$iv).doubleValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d2 = mapper.invoke((double)v);
            if (d2 == null) {
                void i;
                throw new IllegalStateException("Can't project axis break " + this.labels.get((int)i) + " (" + (double)v + ") to axis (horiz:" + isHorizontal + ')');
            }
            collection.add(Double.valueOf(d2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScaleBreaks filterByTransformedLimits(@NotNull DoubleSpan limits) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
        Iterable $this$mapIndexed$iv = this.transformedValues;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void value2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)item$iv$iv).doubleValue();
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean include = value2 >= limits.getLowerEnd() && value2 <= limits.getUpperEnd();
            collection.add(include ? Integer.valueOf((int)index) : null);
        }
        List includeIndices = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        return includeIndices.size() == this.transformedValues.size() ? this : new ScaleBreaks(CollectionsKt.slice(this.domainValues, (Iterable)includeIndices), CollectionsKt.slice(this.transformedValues, (Iterable)includeIndices), this.transform, CollectionsKt.slice(this.labels, (Iterable)includeIndices), this.fixed, this.formatter);
    }

    public /* synthetic */ ScaleBreaks(List domainValues, List transformedValues, Transform transform2, List labels, boolean fixed, Function1 formatter2, DefaultConstructorMarker $constructor_marker) {
        this(domainValues, transformedValues, transform2, labels, fixed, (Function1<Object, String>)formatter2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JP\u0010\r\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Companion;", "", "()V", "DUMMY_FORMATTER", "Lkotlin/Function1;", "", "EMPTY", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "getEMPTY", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "IDENTITY_FORMATTER", "getIDENTITY_FORMATTER", "()Lkotlin/jvm/functions/Function1;", "applyTransformAndDropNulls", "Lkotlin/Triple;", "", "", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "domainValues", "labels", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nScaleBreaks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1559#2:299\n1590#2,4:300\n777#2:304\n788#2:305\n1864#2,2:306\n789#2,2:308\n1866#2:310\n791#2:311\n777#2:312\n788#2:313\n1864#2,2:314\n789#2,2:316\n1866#2:318\n791#2:319\n*S KotlinDebug\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Companion\n*L\n155#1:299\n155#1:300,4\n159#1:304\n159#1:305\n159#1:306,2\n159#1:308,2\n159#1:310\n159#1:311\n161#1:312\n161#1:313\n161#1:314,2\n161#1:316,2\n161#1:318\n161#1:319\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Object, String> getIDENTITY_FORMATTER() {
            return IDENTITY_FORMATTER;
        }

        @NotNull
        public final ScaleBreaks getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        private final Triple<List<Object>, List<Double>, List<String>> applyTransformAndDropNulls(Transform transform2, List<? extends Object> domainValues, List<String> labels) {
            void $this$filterIndexedTo$iv$iv;
            void $this$filterIndexedTo$iv$iv2;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Transform transformCore = transform2.unwrap();
            List<Double> transformed = ScaleUtil.INSTANCE.applyTransform(domainValues, transformCore);
            Iterable iterable = transformed;
            boolean $i$f$mapIndexed = false;
            void var9_9 = $this$mapIndexed$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                Iterator v;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Double d = (Double)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(v == null ? null : Integer.valueOf((int)i));
            }
            Set keepIndices = CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
            Iterable $this$filterIndexed$iv = domainValues;
            boolean $i$f$filterIndexed = false;
            destination$iv$iv = $this$filterIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIndexedTo22 = false;
            void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv2;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv2 = n;
                boolean bl = false;
                int i = index$iv$iv2;
                boolean bl2 = false;
                if (!keepIndices.contains(i)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List filteredDomainValues = (List)destination$iv$iv2;
            List filteredTransformedValues = CollectionsKt.filterNotNull((Iterable)transformed);
            Iterable $this$filterIndexed$iv2 = labels;
            boolean $i$f$filterIndexed2 = false;
            Iterable $i$f$filterIndexedTo22 = $this$filterIndexed$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIndexedTo = false;
            void $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv$iv2 = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv2) {
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object bl = item$iv$iv$iv;
                int index$iv$iv3 = n;
                boolean $i$a$-forEachIndexed-CollectionsKt___CollectionsKt$filterIndexedTo$1$iv$iv2 = false;
                String cfr_ignored_0 = (String)element$iv$iv;
                int i = index$iv$iv3;
                boolean bl3 = false;
                if (!keepIndices.contains(i)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List filteredLabels = (List)destination$iv$iv3;
            return new Triple((Object)filteredDomainValues, (Object)filteredTransformedValues, (Object)filteredLabels);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006JD\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\t2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$ContinuousFlex;", "", "()V", "noTransform", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "domainValues", "", "", "formatter", "Lkotlin/Function1;", "", "alternativeLabels", "withTransform", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nScaleBreaks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$ContinuousFlex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1549#2:299\n1620#2,3:300\n*S KotlinDebug\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$ContinuousFlex\n*L\n245#1:299\n245#1:300,3\n*E\n"})
    public static final class ContinuousFlex {
        @NotNull
        public static final ContinuousFlex INSTANCE = new ContinuousFlex();

        private ContinuousFlex() {
        }

        @NotNull
        public final ScaleBreaks noTransform(@NotNull List<Double> domainValues, @NotNull Function1<Object, String> formatter2, @Nullable List<String> alternativeLabels) {
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            Intrinsics.checkNotNullParameter(formatter2, (String)"formatter");
            return this.withTransform(domainValues, Transforms.INSTANCE.getIDENTITY(), formatter2, alternativeLabels);
        }

        public static /* synthetic */ ScaleBreaks noTransform$default(ContinuousFlex continuousFlex, List list2, Function1 function1, List list3, int n, Object object) {
            if ((n & 4) != 0) {
                list3 = null;
            }
            return continuousFlex.noTransform(list2, (Function1<Object, String>)function1, list3);
        }

        /*
         * WARNING - void declaration
         */
        private final ScaleBreaks withTransform(List<Double> domainValues, Transform transform2, Function1<Object, String> formatter2, List<String> alternativeLabels) {
            if (alternativeLabels != null && !(domainValues.size() == alternativeLabels.size())) {
                boolean $i$a$-check-ScaleBreaks$ContinuousFlex$withTransform$22 = false;
                String $i$a$-check-ScaleBreaks$ContinuousFlex$withTransform$22 = "Scale breaks size: " + domainValues.size() + " and labels size: " + alternativeLabels.size() + " but expected to be the same";
                throw new IllegalStateException($i$a$-check-ScaleBreaks$ContinuousFlex$withTransform$22.toString());
            }
            List list2 = alternativeLabels;
            if (list2 == null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = domainValues;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    destination$iv$iv.add(formatter2.invoke(item$iv$iv));
                }
                list2 = (List)destination$iv$iv;
            }
            List labels = list2;
            Triple triple = Companion.applyTransformAndDropNulls(transform2, domainValues, labels);
            List filteredDomainValues = (List)triple.component1();
            List filteredTransformedValues = (List)triple.component2();
            List filteredLabels = (List)triple.component3();
            return new ScaleBreaks(filteredDomainValues, filteredTransformedValues, transform2, filteredLabels, false, formatter2, null);
        }

        static /* synthetic */ ScaleBreaks withTransform$default(ContinuousFlex continuousFlex, List list2, Transform transform2, Function1 function1, List list3, int n, Object object) {
            if ((n & 8) != 0) {
                list3 = null;
            }
            return continuousFlex.withTransform(list2, transform2, (Function1<Object, String>)function1, list3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n\u0018\u00010\tJ\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$DemoAndTest;", "", "()V", "continuous", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "domainValues", "", "", "formatter", "Lkotlin/Function1;", "", "labels", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nScaleBreaks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$DemoAndTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1549#2:299\n1620#2,3:300\n*S KotlinDebug\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$DemoAndTest\n*L\n278#1:299\n278#1:300,3\n*E\n"})
    public static final class DemoAndTest {
        @NotNull
        public static final DemoAndTest INSTANCE = new DemoAndTest();

        private DemoAndTest() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ScaleBreaks continuous(@NotNull List<Double> domainValues, @Nullable Function1<Object, String> formatter2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            Function1<Object, String> function1 = formatter2;
            if (function1 == null) {
                function1 = Companion.getIDENTITY_FORMATTER();
            }
            Function1<Object, String> formatter3 = function1;
            Iterable iterable = domainValues;
            Transform transform2 = Transforms.INSTANCE.getIDENTITY();
            List<Double> list2 = domainValues;
            List<Double> list3 = domainValues;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(formatter3.invoke(item$iv$iv));
            }
            List list4 = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            Function1<Object, String> function12 = formatter3;
            boolean bl = true;
            List list5 = list4;
            Transform transform3 = transform2;
            List<Double> list6 = list2;
            List<Double> list7 = list3;
            return new ScaleBreaks(list7, list6, transform3, list5, bl, function12, defaultConstructorMarker);
        }

        public static /* synthetic */ ScaleBreaks continuous$default(DemoAndTest demoAndTest2, List list2, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            return demoAndTest2.continuous((List<Double>)list2, (Function1<Object, String>)function1);
        }

        @NotNull
        public final ScaleBreaks continuous(@NotNull List<Double> domainValues, @NotNull List<String> labels) {
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            return new ScaleBreaks(domainValues, domainValues, Transforms.INSTANCE.getIDENTITY(), labels, true, DUMMY_FORMATTER, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002JS\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Fixed;", "", "()V", "shorten", "", "str", "limit", "", "withTransform", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "domainValues", "", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/Transform;", "formatter", "Lkotlin/Function1;", "alternativeLabels", "labelLengthLimit", "(Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/Transform;Lkotlin/jvm/functions/Function1;Ljava/util/List;Ljava/lang/Integer;)Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nScaleBreaks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Fixed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1549#2:299\n1620#2,3:300\n1549#2:303\n1620#2,3:304\n*S KotlinDebug\n*F\n+ 1 ScaleBreaks.kt\norg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks$Fixed\n*L\n184#1:299\n184#1:300,3\n186#1:303\n186#1:304,3\n*E\n"})
    public static final class Fixed {
        @NotNull
        public static final Fixed INSTANCE = new Fixed();

        private Fixed() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ScaleBreaks withTransform(@NotNull List<? extends Object> domainValues, @NotNull Transform transform2, @NotNull Function1<Object, String> formatter2, @Nullable List<String> alternativeLabels, @Nullable Integer labelLengthLimit) {
            List list2;
            Intrinsics.checkNotNullParameter(domainValues, (String)"domainValues");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            Intrinsics.checkNotNullParameter(formatter2, (String)"formatter");
            if (alternativeLabels != null && !(domainValues.size() == alternativeLabels.size())) {
                boolean $i$a$-check-ScaleBreaks$Fixed$withTransform$22 = false;
                String $i$a$-check-ScaleBreaks$Fixed$withTransform$22 = "Scale breaks size: " + domainValues.size() + " and labels size: " + alternativeLabels.size() + " but expected to be the same";
                throw new IllegalStateException($i$a$-check-ScaleBreaks$Fixed$withTransform$22.toString());
            }
            List list3 = alternativeLabels;
            if (list3 == null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = domainValues;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    destination$iv$iv.add(formatter2.invoke(item$iv$iv));
                }
                list3 = (List)destination$iv$iv;
            }
            List labels = list3;
            boolean bl = false;
            Integer n = labelLengthLimit;
            if (n != null) {
                void $this$mapTo$iv$iv;
                int limit = ((Number)n).intValue();
                boolean bl2 = false;
                Iterable $this$map$iv = labels;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(INSTANCE.shorten((String)it, limit));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = labels;
            }
            List labels2 = list2;
            Triple triple = Companion.applyTransformAndDropNulls(transform2, domainValues, labels2);
            List filteredDomainValues = (List)triple.component1();
            List filteredTransformedValues = (List)triple.component2();
            List filteredLabels = (List)triple.component3();
            return new ScaleBreaks(filteredDomainValues, filteredTransformedValues, transform2, filteredLabels, true, formatter2, null);
        }

        public static /* synthetic */ ScaleBreaks withTransform$default(Fixed fixed, List list2, Transform transform2, Function1 function1, List list3, Integer n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                list3 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            return fixed.withTransform(list2, transform2, (Function1<Object, String>)function1, list3, n);
        }

        private final String shorten(String str, int limit) {
            return limit > 0 && str.length() > limit ? StringsKt.take((String)str, (int)limit) + "..." : str;
        }
    }
}

