/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.DefaultTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeFlavor;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.values.ThemeValues;
import org.jetbrains.letsPlot.core.plot.builder.presentation.DefaultFontFamilyRegistry;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nJ7\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeUtil;", "", "()V", "buildTheme", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultTheme;", "themeName", "", "userOptions", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "getThemeValues", "getThemeValues$plot_builder", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nThemeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeUtil\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n453#2:63\n403#2:64\n453#2:67\n403#2:68\n1238#3,2:65\n1238#3,4:69\n1241#3:73\n*S KotlinDebug\n*F\n+ 1 ThemeUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeUtil\n*L\n49#1:63\n49#1:64\n51#1:67\n51#1:68\n49#1:65,2\n51#1:69,4\n49#1:73\n*E\n"})
public final class ThemeUtil {
    @NotNull
    public static final ThemeUtil INSTANCE = new ThemeUtil();

    private ThemeUtil() {
    }

    @NotNull
    public final DefaultTheme buildTheme(@NotNull String themeName, @NotNull Map<String, ? extends Object> userOptions, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter((Object)themeName, (String)"themeName");
        Intrinsics.checkNotNullParameter(userOptions, (String)"userOptions");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        return new DefaultTheme(this.getThemeValues$plot_builder(themeName, userOptions), fontFamilyRegistry);
    }

    public static /* synthetic */ DefaultTheme buildTheme$default(ThemeUtil themeUtil, String string, Map map2, FontFamilyRegistry fontFamilyRegistry, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            fontFamilyRegistry = new DefaultFontFamilyRegistry(0.0, 1, null);
        }
        return themeUtil.buildTheme(string, map2, fontFamilyRegistry);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> getThemeValues$plot_builder(@NotNull String themeName, @NotNull Map<String, ? extends Object> userOptions) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)themeName, (String)"themeName");
        Intrinsics.checkNotNullParameter(userOptions, (String)"userOptions");
        ThemeValues baselineValues = ThemeValues.Companion.forName$plot_builder(themeName);
        Map<String, Object> effectiveOptions = baselineValues.plus(userOptions);
        if (Intrinsics.areEqual((Object)themeName, (Object)"none")) {
            return effectiveOptions;
        }
        Object object = effectiveOptions.get("flavor");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            throw new IllegalStateException("Flavor name should be specified".toString());
        }
        String flavorName = string;
        ThemeFlavor flavor = ThemeFlavor.Companion.forName$plot_builder(flavorName);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"pen", (Object)flavor.getPen()), TuplesKt.to((Object)"paper", (Object)flavor.getPaper()), TuplesKt.to((Object)"brush", (Object)flavor.getBrush())};
        Map geomThemeOptions = MapsKt.mapOf((Pair)TuplesKt.to((Object)"geom", (Object)MapsKt.mapOf((Pair[])pairArray)));
        Map<String, Object> $this$mapValues$iv = effectiveOptions;
        boolean $i$f$mapValues = false;
        Map<String, Object> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Object object2;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String parameter = (String)entry2.getKey();
            Object options = entry2.getValue();
            Map map5 = options instanceof Map ? (Map)options : null;
            if (map5 == null) {
                object2 = options;
            } else {
                void $this$mapValuesTo$iv$iv2;
                Map subOptions;
                Map $this$mapValues$iv2 = subOptions = map5;
                boolean $i$f$mapValues2 = false;
                Map map6 = $this$mapValues$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
                boolean $i$f$mapValuesTo2 = false;
                Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv2.entrySet();
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv2) {
                    Object object3;
                    void it$iv$iv2;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv2;
                    Map map7 = destination$iv$iv2;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    Map.Entry entry4 = (Map.Entry)element$iv$iv$iv2;
                    Object k2 = it$iv$iv2.getKey();
                    Map map8 = map7;
                    boolean bl3 = false;
                    Object key = entry4.getKey();
                    Object value2 = entry4.getValue();
                    if ((value2 instanceof ThemeFlavor.Companion.SymbolicColor ? (ThemeFlavor.Companion.SymbolicColor)((Object)value2) : null) == null) {
                        object3 = value2;
                    } else {
                        ThemeFlavor.Companion.SymbolicColor color;
                        color = color;
                        object3 = flavor.getSymbolicColors().get((Object)color);
                        if (object3 == null) {
                            throw new IllegalStateException(("Undefined color in flavor scheme = '" + flavorName + "': '" + parameter + "': '" + key + "' = '" + color.name() + '\'').toString());
                        }
                    }
                    Object v = object3;
                    map8.put(k2, v);
                }
                object2 = destination$iv$iv2;
            }
            Object v = object2;
            map4.put(k, v);
        }
        Map withResolvedColors = destination$iv$iv;
        return ThemeValues.Companion.mergeWith(ThemeValues.Companion.mergeWith(geomThemeOptions, flavor.getSpecialColors()), withResolvedColors);
    }

    public static /* synthetic */ Map getThemeValues$plot_builder$default(ThemeUtil themeUtil, String string, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return themeUtil.getThemeValues$plot_builder(string, map2);
    }
}

