/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/spec/config/LegendThemeConfig;", "", "()V", "convertValue", "key", "", "value", "toDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "toJustification", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendJustification;", "toPosition", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendPosition;", "plot-stem"})
public final class LegendThemeConfig {
    @NotNull
    public static final LegendThemeConfig INSTANCE = new LegendThemeConfig();

    private LegendThemeConfig() {
    }

    @NotNull
    public final Object convertValue(@NotNull String key, @NotNull Object value2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        switch (key) {
            case "legend_position": {
                object = this.toPosition(value2);
                break;
            }
            case "legend_justification": {
                object = this.toJustification(value2);
                break;
            }
            case "legend_direction": {
                object = this.toDirection(value2);
                break;
            }
            default: {
                object = value2;
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LegendPosition toPosition(Object value2) {
        LegendPosition legendPosition;
        Object object = value2;
        if (object instanceof String) {
            Object object2 = value2;
            if (Intrinsics.areEqual((Object)object2, (Object)"right")) {
                legendPosition = LegendPosition.Companion.getRIGHT();
                return legendPosition;
            } else if (Intrinsics.areEqual((Object)object2, (Object)"left")) {
                legendPosition = LegendPosition.Companion.getLEFT();
                return legendPosition;
            } else if (Intrinsics.areEqual((Object)object2, (Object)"top")) {
                legendPosition = LegendPosition.Companion.getTOP();
                return legendPosition;
            } else if (Intrinsics.areEqual((Object)object2, (Object)"bottom")) {
                legendPosition = LegendPosition.Companion.getBOTTOM();
                return legendPosition;
            } else {
                if (!Intrinsics.areEqual((Object)object2, (Object)"none")) throw new IllegalArgumentException("Illegal value: '" + value2 + "'.\nlegend_position expected value is either a string: left|right|top|bottom|none or two-element numeric list.");
                legendPosition = LegendPosition.Companion.getNONE();
            }
            return legendPosition;
        } else if (object instanceof List) {
            DoubleVector v = ConfigUtil.INSTANCE.toNumericPair((List)value2);
            legendPosition = new LegendPosition(v.getX(), v.getY());
            return legendPosition;
        } else {
            if (!(object instanceof LegendPosition)) throw new IllegalArgumentException("Illegal value type: " + Reflection.getOrCreateKotlinClass(value2.getClass()).getSimpleName() + ".\nlegend_position expected value is either a string: left|right|top|bottom|none or two-element numeric list.");
            legendPosition = (LegendPosition)value2;
        }
        return legendPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LegendJustification toJustification(Object value2) {
        LegendJustification legendJustification;
        Object object = value2;
        if (object instanceof String) {
            if (!Intrinsics.areEqual((Object)value2, (Object)"center")) throw new IllegalArgumentException("Illegal value '" + value2 + "', legend_justification expected values are: 'center' or two-element numeric list.");
            legendJustification = LegendJustification.Companion.getCENTER();
            return legendJustification;
        } else if (object instanceof List) {
            DoubleVector v = ConfigUtil.INSTANCE.toNumericPair((List)value2);
            legendJustification = new LegendJustification(v.getX(), v.getY());
            return legendJustification;
        } else {
            if (!(object instanceof LegendJustification)) throw new IllegalArgumentException("Illegal value type: " + Reflection.getOrCreateKotlinClass(value2.getClass()).getSimpleName() + ", legend_justification expected values are: 'center' or two-element numeric list.");
            legendJustification = (LegendJustification)value2;
        }
        return legendJustification;
    }

    private final LegendDirection toDirection(Object value2) {
        LegendDirection legendDirection;
        Object object = value2;
        if (Intrinsics.areEqual((Object)object, (Object)"horizontal")) {
            legendDirection = LegendDirection.HORIZONTAL;
        } else if (Intrinsics.areEqual((Object)object, (Object)"vertical")) {
            legendDirection = LegendDirection.VERTICAL;
        } else {
            throw new IllegalArgumentException("Illegal value: " + value2 + ", legend_direction. Expected values are: 'horizontal' or 'vertical'.");
        }
        return legendDirection;
    }
}

