/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.observable.property.WritableProperty;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColor;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPlatformPeer;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformable;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016J\u0010\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0016H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u0010\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u0010\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010&0\u0016H\u0016J\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016R\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGraphicsElement;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformable;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "x", "", "y", "width", "height", "(DDDD)V", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "()V", "bBox", "getBBox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "fill", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/Property;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgColor;", "fillColor", "Lorg/jetbrains/letsPlot/commons/intern/observable/property/WritableProperty;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillOpacity", "pointToAbsoluteCoordinates", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "stroke", "strokeColor", "strokeDashArray", "strokeOpacity", "strokeWidth", "transform", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "Companion", "datamodel"})
public final class SvgRectElement
extends SvgGraphicsElement
implements SvgTransformable,
SvgShape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X = SvgAttributeSpec.Companion.createSpec("x");
    @NotNull
    private static final SvgAttributeSpec<Double> Y = SvgAttributeSpec.Companion.createSpec("y");
    @NotNull
    private static final SvgAttributeSpec<Double> WIDTH = SvgAttributeSpec.Companion.createSpec("width");
    @NotNull
    private static final SvgAttributeSpec<Double> HEIGHT = SvgAttributeSpec.Companion.createSpec("height");

    public SvgRectElement() {
        this.elementName = "rect";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    public SvgRectElement(double x2, double y2, double width2, double height) {
        this();
        this.setAttribute(X, x2);
        this.setAttribute(Y, y2);
        this.setAttribute(HEIGHT, height);
        this.setAttribute(WIDTH, width2);
    }

    public SvgRectElement(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this(rect2.getOrigin().getX(), rect2.getOrigin().getY(), rect2.getDimension().getX(), rect2.getDimension().getY());
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    @NotNull
    public final Property<Double> height() {
        return this.getAttribute(HEIGHT);
    }

    @NotNull
    public final Property<Double> width() {
        return this.getAttribute(WIDTH);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgShape.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgShape.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgShape.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$datamodel(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public Property<String> strokeDashArray() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_DASHARRAY());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point2);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement$Companion;", "", "()V", "HEIGHT", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "", "getHEIGHT", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgAttributeSpec;", "WIDTH", "getWIDTH", "X", "getX", "Y", "getY", "datamodel"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SvgAttributeSpec<Double> getX() {
            return X;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY() {
            return Y;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getWIDTH() {
            return WIDTH;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getHEIGHT() {
            return HEIGHT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

