/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.util;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.encoding.RGBEncoder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgAttributeSpec;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgImageElementEx;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTextNode;
import org.jetbrains.letsPlot.datamodel.svg.util.PrebuiltSvgSubtree;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ+\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/util/SvgToString;", "", "rgbEncoder", "Lorg/jetbrains/letsPlot/commons/encoding/RGBEncoder;", "useCssPixelatedImageRendering", "", "(Lorg/jetbrains/letsPlot/commons/encoding/RGBEncoder;Z)V", "render", "", "svg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "renderElement", "", "svgElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "", "(Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgElement;Ljava/lang/StringBuilder;Ljava/lang/Integer;)V", "renderTextNode", "node", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTextNode;", "Companion", "datamodel"})
public final class SvgToString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RGBEncoder rgbEncoder;
    private final boolean useCssPixelatedImageRendering;
    private static final int TAB = 2;

    public SvgToString(@NotNull RGBEncoder rgbEncoder, boolean useCssPixelatedImageRendering) {
        Intrinsics.checkNotNullParameter((Object)rgbEncoder, (String)"rgbEncoder");
        this.rgbEncoder = rgbEncoder;
        this.useCssPixelatedImageRendering = useCssPixelatedImageRendering;
    }

    public /* synthetic */ SvgToString(RGBEncoder rGBEncoder, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(rGBEncoder, bl);
    }

    @NotNull
    public final String render(@NotNull SvgSvgElement svg) {
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        StringBuilder buffer = new StringBuilder();
        this.renderElement(svg, buffer, 0);
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void renderElement(SvgElement svgElement, StringBuilder buffer, Integer level) {
        Integer childrenLevel;
        if (level != null && level > 0) {
            Companion.crlf(buffer, level);
        }
        buffer.append('<').append(svgElement.getElementName());
        if (Intrinsics.areEqual((Object)svgElement.getElementName(), (Object)"svg")) {
            buffer.append(" xmlns").append("=\"").append("http://www.w3.org/2000/svg").append('\"');
            buffer.append(" xmlns:").append("xlink").append("=\"").append("http://www.w3.org/1999/xlink").append('\"');
        }
        for (SvgAttributeSpec<?> key : svgElement.getAttributeKeys()) {
            buffer.append(' ');
            String name = key.getName();
            String value2 = String.valueOf(svgElement.getAttribute(name).get());
            buffer.append(name).append("=\"").append(value2).append('\"');
        }
        buffer.append('>');
        Integer n = level;
        Integer nextLevel = n == null ? null : Integer.valueOf(n + 1);
        Integer n2 = childrenLevel = svgElement instanceof SvgTextElement ? null : nextLevel;
        if (svgElement.isPrebuiltSubtree()) {
            for (SvgNode childNode : svgElement.children()) {
                Integer n3 = childrenLevel;
                PrebuiltSvgSubtree subtree = new PrebuiltSvgSubtree(childNode, n3 != null ? n3 : 0);
                buffer.append(subtree.getAsString());
            }
        } else {
            if (svgElement instanceof SvgTextElement) {
                Companion.crlf(buffer, nextLevel);
            }
            for (SvgNode childNode : svgElement.children()) {
                SvgNode childNode2 = childNode;
                SvgNode svgNode = childNode2;
                if (svgNode instanceof SvgTextNode) {
                    Companion.crlf(buffer, level);
                    this.renderTextNode((SvgTextNode)childNode2, buffer);
                    continue;
                }
                if (svgNode instanceof SvgElement) {
                    if (childNode2 instanceof SvgImageElementEx) {
                        childNode2 = ((SvgImageElementEx)childNode2).asImageElement(this.rgbEncoder);
                    }
                    if (childNode2 instanceof SvgImageElement) {
                        String string;
                        boolean bl = this.useCssPixelatedImageRendering;
                        if (bl) {
                            string = "image-rendering: optimizeSpeed; image-rendering: pixelated";
                        } else if (!bl) {
                            string = "image-rendering: optimizeSpeed";
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        String style = string;
                        ((SvgImageElement)childNode2).setAttribute("style", style);
                    }
                    SvgNode svgNode2 = childNode2;
                    Intrinsics.checkNotNull((Object)svgNode2, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.datamodel.svg.dom.SvgElement");
                    this.renderElement((SvgElement)svgNode2, buffer, childrenLevel);
                    continue;
                }
                throw new IllegalStateException("Can't render unsupported svg node: " + childNode2);
            }
        }
        Companion.crlf(buffer, level);
        buffer.append("</").append(svgElement.getElementName()).append('>');
    }

    private final void renderTextNode(SvgTextNode node, StringBuilder buffer) {
        buffer.append(Companion.htmlEscape((String)node.textContent().get()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/util/SvgToString$Companion;", "", "()V", "TAB", "", "crlf", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "(Ljava/lang/StringBuilder;Ljava/lang/Integer;)V", "htmlEscape", "", "str", "datamodel"})
    @SourceDebugExtension(value={"SMAP\nSvgToString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvgToString.kt\norg/jetbrains/letsPlot/datamodel/svg/util/SvgToString$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,138:1\n1174#2,2:139\n*S KotlinDebug\n*F\n+ 1 SvgToString.kt\norg/jetbrains/letsPlot/datamodel/svg/util/SvgToString$Companion\n*L\n111#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String htmlEscape(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            StringBuilder escaped = new StringBuilder();
            CharSequence $this$forEach$iv = str;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char ch = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                char c = ch;
                escaped.append(c == '&' ? "&amp;" : (c == '<' ? "&lt;" : (c == '>' ? "&gt;" : (c == '\"' ? "&quot;" : (c == '\'' ? "&#39;" : Character.valueOf(ch))))));
            }
            String string = escaped.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final void crlf(@NotNull StringBuilder buffer, @Nullable Integer level) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (level == null) {
                return;
            }
            buffer.append('\n');
            int n = level * 2;
            for (int i = 0; i < n; ++i) {
                buffer.append(' ');
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

