/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjExceptionInternal;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u0013J\u0006\u0010\u001a\u001a\u00020\u0013J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u001eJ\b\u0010#\u001a\u00020\u001cH\u0002J\u000e\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0013J \u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u0010J*\u0010,\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00162\b\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u0010J6\u0010-\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010+\u001a\u00020\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/FiltersPerformance;", "", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "absum", "", "cost", "entropy", "filterWeights", "histog", "", "iminfo", "initdone", "", "lastprefered", "", "lastrow", "memoryA", "", "preferenceForNone", "preferred", "Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "getPreferred", "()Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "computeAbsFromHistogram", "computeEntropyFromHistogram", "computeHistogram", "", "rowff", "", "computeHistogramForFilter", "filterType", "rowb", "rowbprev", "init", "setFilterWeights", "weights", "setPreferenceForNone", "tuneMemory", "m", "updateFromFiltered", "ftype", "rown", "updateFromRaw", "updateFromRawOrFiltered", "Companion", "plot-api"})
public final class FiltersPerformance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageInfo iminfo;
    private double memoryA;
    private int lastrow;
    @NotNull
    private final double[] absum;
    @NotNull
    private final double[] entropy;
    @NotNull
    private final double[] cost;
    @NotNull
    private final int[] histog;
    private int lastprefered;
    private boolean initdone;
    private double preferenceForNone;
    @NotNull
    private final double[] filterWeights;
    @NotNull
    private static final double[] FILTER_WEIGHTS_DEFAULT;
    private static final double LOG2NI;

    public FiltersPerformance(@NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        this.memoryA = 0.7;
        this.lastrow = -1;
        this.absum = new double[5];
        this.entropy = new double[5];
        this.cost = new double[5];
        this.histog = new int[256];
        this.lastprefered = -1;
        this.preferenceForNone = 1.0;
        double[] dArray = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0};
        this.filterWeights = dArray;
        this.iminfo = imgInfo;
    }

    private final void init() {
        if (this.filterWeights[0] < 0.0) {
            ArrayUtilsKt.arraycopy(FILTER_WEIGHTS_DEFAULT, 0, this.filterWeights, 0, 5);
            double wNone = this.filterWeights[0];
            if (this.iminfo.getBitDepth() == 16) {
                wNone = 1.2;
            } else if (this.iminfo.getAlpha()) {
                wNone = 0.8;
            } else if (this.iminfo.getIndexed() || this.iminfo.getBitDepth() < 8) {
                wNone = 0.4;
            }
            this.filterWeights[0] = wNone /= this.preferenceForNone;
        }
        ArrayUtilsKt.fill(this.cost, 1.0);
        this.initdone = true;
    }

    public final void updateFromFiltered(@NotNull FilterType ftype, @Nullable byte[] rowff, int rown) {
        Intrinsics.checkNotNullParameter((Object)((Object)ftype), (String)"ftype");
        this.updateFromRawOrFiltered(ftype, rowff, null, null, rown);
    }

    public final void updateFromRaw(@NotNull FilterType ftype, @Nullable byte[] rowb, @Nullable byte[] rowbprev, int rown) {
        Intrinsics.checkNotNullParameter((Object)((Object)ftype), (String)"ftype");
        this.updateFromRawOrFiltered(ftype, null, rowb, rowbprev, rown);
    }

    private final void updateFromRawOrFiltered(FilterType ftype, byte[] rowff, byte[] rowb, byte[] rowbprev, int rown) {
        if (!this.initdone) {
            this.init();
        }
        if (rown != this.lastrow) {
            ArrayUtilsKt.fill(this.absum, Double.NaN);
            ArrayUtilsKt.fill(this.entropy, Double.NaN);
        }
        this.lastrow = rown;
        if (rowff != null) {
            this.computeHistogram(rowff);
        } else {
            this.computeHistogramForFilter(ftype, rowb, rowbprev);
        }
        if (ftype == FilterType.FILTER_NONE) {
            this.entropy[ftype.getValue()] = this.computeEntropyFromHistogram();
        } else {
            this.absum[ftype.getValue()] = this.computeAbsFromHistogram();
        }
    }

    @NotNull
    public final FilterType getPreferred() {
        int fi = 0;
        double vali = Double.MAX_VALUE;
        double val = 0.0;
        for (int i = 0; i < 5; ++i) {
            double d;
            if (!Double.isNaN(this.absum[i])) {
                d = this.absum[i];
            } else {
                if (Double.isNaN(this.entropy[i])) continue;
                d = (Math.pow(2.0, this.entropy[i]) - 1.0) * 0.5;
            }
            val = d;
            val *= this.filterWeights[i];
            this.cost[i] = val = this.cost[i] * this.memoryA + (1.0 - this.memoryA) * val;
            if (!(val < vali)) continue;
            vali = val;
            fi = i;
        }
        this.lastprefered = fi;
        return FilterType.Companion.getByVal(this.lastprefered);
    }

    public final void computeHistogramForFilter(@NotNull FilterType filterType, @Nullable byte[] rowb, @Nullable byte[] rowbprev) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterType), (String)"filterType");
        ArrayUtilsKt.fill(this.histog, 0);
        int i = 0;
        int j = 0;
        int imax = this.iminfo.getBytesPerRow();
        switch (WhenMappings.$EnumSwitchMapping$0[filterType.ordinal()]) {
            case 1: {
                for (i = 1; i <= imax; ++i) {
                    int[] nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    int n = rowb[i] & 0xFF;
                    int n2 = nArray[n];
                    nArray[n] = n2 + 1;
                }
                break;
            }
            case 2: {
                int n;
                int n3;
                int[] nArray;
                for (i = 1; i <= imax; ++i) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    byte by = rowb[i];
                    Intrinsics.checkNotNull((Object)rowbprev);
                    n3 = PngHelperInternal.INSTANCE.filterRowPaeth(by, 0, rowbprev[i] & 0xFF, 0);
                    n = nArray[n3];
                    nArray[n3] = n + 1;
                }
                j = 1;
                i = this.iminfo.getBytesPixel() + 1;
                while (i <= imax) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    byte by = rowb[i];
                    int n4 = rowb[j] & 0xFF;
                    Intrinsics.checkNotNull((Object)rowbprev);
                    n3 = PngHelperInternal.INSTANCE.filterRowPaeth(by, n4, rowbprev[i] & 0xFF, rowbprev[j] & 0xFF);
                    n = nArray[n3];
                    nArray[n3] = n + 1;
                    ++i;
                    ++j;
                }
                break;
            }
            case 3: {
                int n;
                int n5;
                int[] nArray;
                for (i = 1; i <= this.iminfo.getBytesPixel(); ++i) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    n5 = rowb[i] & 0xFF;
                    n = nArray[n5];
                    nArray[n5] = n + 1;
                }
                j = 1;
                i = this.iminfo.getBytesPixel() + 1;
                while (i <= imax) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    n5 = rowb[i] - rowb[j] & 0xFF;
                    n = nArray[n5];
                    nArray[n5] = n + 1;
                    ++i;
                    ++j;
                }
                break;
            }
            case 4: {
                for (i = 1; i <= this.iminfo.getBytesPerRow(); ++i) {
                    int[] nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    byte by = rowb[i];
                    Intrinsics.checkNotNull((Object)rowbprev);
                    int n = by - rowbprev[i] & 0xFF;
                    int n6 = nArray[n];
                    nArray[n] = n6 + 1;
                }
                break;
            }
            case 5: {
                int n;
                int n7;
                int[] nArray;
                for (i = 1; i <= this.iminfo.getBytesPixel(); ++i) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    int n8 = rowb[i] & 0xFF;
                    Intrinsics.checkNotNull((Object)rowbprev);
                    n7 = n8 - (rowbprev[i] & 0xFF) / 2 & 0xFF;
                    n = nArray[n7];
                    nArray[n7] = n + 1;
                }
                j = 1;
                i = this.iminfo.getBytesPixel() + 1;
                while (i <= imax) {
                    nArray = this.histog;
                    Intrinsics.checkNotNull((Object)rowb);
                    int n9 = rowb[i] & 0xFF;
                    Intrinsics.checkNotNull((Object)rowbprev);
                    n7 = n9 - ((rowbprev[i] & 0xFF) + (rowb[j] & 0xFF)) / 2 & 0xFF;
                    n = nArray[n7];
                    nArray[n7] = n + 1;
                    ++i;
                    ++j;
                }
                break;
            }
            default: {
                throw new PngjExceptionInternal("Bad filter:" + (Object)((Object)filterType));
            }
        }
    }

    public final void computeHistogram(@NotNull byte[] rowff) {
        Intrinsics.checkNotNullParameter((Object)rowff, (String)"rowff");
        ArrayUtilsKt.fill(this.histog, 0);
        int n = this.iminfo.getBytesPerRow();
        for (int i = 1; i < n; ++i) {
            int[] nArray = this.histog;
            int n2 = rowff[i] & 0xFF;
            int n3 = nArray[n2];
            nArray[n2] = n3 + 1;
        }
    }

    public final double computeAbsFromHistogram() {
        int i;
        int s = 0;
        for (i = 1; i < 128; ++i) {
            s += this.histog[i] * i;
        }
        i = 128;
        for (int j = 128; j > 0; --j) {
            s += this.histog[i] * j;
            ++i;
        }
        return (double)s / (double)this.iminfo.getBytesPerRow();
    }

    public final double computeEntropyFromHistogram() {
        double s = 1.0 / (double)this.iminfo.getBytesPerRow();
        double ls = Math.log(s);
        double h = 0.0;
        for (int x2 : this.histog) {
            if (x2 <= 0) continue;
            h += (Math.log(x2) + ls) * (double)x2;
        }
        if ((h *= s * LOG2NI) < 0.0) {
            h = 0.0;
        }
        return h;
    }

    public final void setPreferenceForNone(double preferenceForNone) {
        this.preferenceForNone = preferenceForNone;
    }

    public final void tuneMemory(double m) {
        this.memoryA = m == 0.0 ? 0.0 : Math.pow(this.memoryA, 1.0 / m);
    }

    public final void setFilterWeights(@NotNull double[] weights) {
        Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
        ArrayUtilsKt.arraycopy(weights, 0, this.filterWeights, 0, 5);
    }

    static {
        double[] dArray = new double[]{0.73, 1.03, 0.97, 1.11, 1.22};
        FILTER_WEIGHTS_DEFAULT = dArray;
        LOG2NI = -1.0 / Math.log(2.0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/FiltersPerformance$Companion;", "", "()V", "FILTER_WEIGHTS_DEFAULT", "", "getFILTER_WEIGHTS_DEFAULT", "()[D", "LOG2NI", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final double[] getFILTER_WEIGHTS_DEFAULT() {
            return FILTER_WEIGHTS_DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterType.values().length];
            try {
                nArray[FilterType.FILTER_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_PAETH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_SUB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_UP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterType.FILTER_AVERAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

