/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.dom.svg;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import org.jetbrains.relocated.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.jetbrains.relocated.apache.batik.dom.svg.ListHandler;
import org.jetbrains.relocated.apache.batik.dom.svg.SVGPathSegItem;
import org.jetbrains.relocated.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.jetbrains.relocated.apache.batik.parser.DefaultPathHandler;
import org.jetbrains.relocated.apache.batik.parser.ParseException;
import org.jetbrains.relocated.apache.batik.parser.PathParser;

public abstract class AbstractSVGNormPathSegList
extends AbstractSVGPathSegList {
    protected AbstractSVGNormPathSegList() {
    }

    @Override
    protected void doParse(String value2, ListHandler handler2) throws ParseException {
        PathParser pathParser = new PathParser();
        NormalizedPathSegListBuilder builder = new NormalizedPathSegListBuilder(handler2);
        pathParser.setPathHandler(builder);
        pathParser.parse(value2);
    }

    protected static class SVGPathSegGenericItem
    extends SVGPathSegItem {
        public SVGPathSegGenericItem(short type, String letter, float x1, float y1, float x2, float y2, float x3, float y3) {
            super(type, letter);
            this.setX1(x2);
            this.setY1(y2);
            this.setX2(x2);
            this.setY2(y2);
            this.setX(x3);
            this.setY(y3);
        }

        public void setValue(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.setX1(x2);
            this.setY1(y2);
            this.setX2(x2);
            this.setY2(y2);
            this.setX(x3);
            this.setY(y3);
        }

        public void setValue(float x2, float y2) {
            this.setX(x2);
            this.setY(y2);
        }

        public void setPathSegType(short type) {
            this.type = type;
        }
    }

    protected static class NormalizedPathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;
        protected SVGPathSegGenericItem lastAbs;

        public NormalizedPathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startPath() throws ParseException {
            this.listHandler.startList();
            this.lastAbs = new SVGPathSegGenericItem(2, "M", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void endPath() throws ParseException {
            this.listHandler.endList();
        }

        @Override
        public void movetoRel(float x2, float y2) throws ParseException {
            this.movetoAbs(this.lastAbs.getX() + x2, this.lastAbs.getY() + y2);
        }

        @Override
        public void movetoAbs(float x2, float y2) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(2, "M", x2, y2));
            this.lastAbs.setX(x2);
            this.lastAbs.setY(y2);
            this.lastAbs.setPathSegType((short)2);
        }

        @Override
        public void closePath() throws ParseException {
            this.listHandler.item(new SVGPathSegItem(1, "z"));
        }

        @Override
        public void linetoRel(float x2, float y2) throws ParseException {
            this.linetoAbs(this.lastAbs.getX() + x2, this.lastAbs.getY() + y2);
        }

        @Override
        public void linetoAbs(float x2, float y2) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(4, "L", x2, y2));
            this.lastAbs.setX(x2);
            this.lastAbs.setY(y2);
            this.lastAbs.setPathSegType((short)4);
        }

        @Override
        public void linetoHorizontalRel(float x2) throws ParseException {
            this.linetoAbs(this.lastAbs.getX() + x2, this.lastAbs.getY());
        }

        @Override
        public void linetoHorizontalAbs(float x2) throws ParseException {
            this.linetoAbs(x2, this.lastAbs.getY());
        }

        @Override
        public void linetoVerticalRel(float y2) throws ParseException {
            this.linetoAbs(this.lastAbs.getX(), this.lastAbs.getY() + y2);
        }

        @Override
        public void linetoVerticalAbs(float y2) throws ParseException {
            this.linetoAbs(this.lastAbs.getX(), y2);
        }

        @Override
        public void curvetoCubicRel(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
            this.curvetoCubicAbs(this.lastAbs.getX() + x1, this.lastAbs.getY() + y1, this.lastAbs.getX() + x2, this.lastAbs.getY() + y2, this.lastAbs.getX() + x3, this.lastAbs.getY() + y3);
        }

        @Override
        public void curvetoCubicAbs(float x1, float y1, float x2, float y2, float x3, float y3) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem(6, "C", x1, y1, x2, y2, x3, y3));
            this.lastAbs.setValue(x1, y1, x2, y2, x3, y3);
            this.lastAbs.setPathSegType((short)6);
        }

        @Override
        public void curvetoCubicSmoothRel(float x2, float y2, float x3, float y3) throws ParseException {
            this.curvetoCubicSmoothAbs(this.lastAbs.getX() + x2, this.lastAbs.getY() + y2, this.lastAbs.getX() + x3, this.lastAbs.getY() + y3);
        }

        @Override
        public void curvetoCubicSmoothAbs(float x2, float y2, float x3, float y3) throws ParseException {
            if (this.lastAbs.getPathSegType() == 6) {
                this.curvetoCubicAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX2()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY2()), x2, y2, x3, y3);
            } else {
                this.curvetoCubicAbs(this.lastAbs.getX(), this.lastAbs.getY(), x2, y2, x3, y3);
            }
        }

        @Override
        public void curvetoQuadraticRel(float x1, float y1, float x2, float y2) throws ParseException {
            this.curvetoQuadraticAbs(this.lastAbs.getX() + x1, this.lastAbs.getY() + y1, this.lastAbs.getX() + x2, this.lastAbs.getY() + y2);
        }

        @Override
        public void curvetoQuadraticAbs(float x1, float y1, float x2, float y2) throws ParseException {
            this.curvetoCubicAbs(this.lastAbs.getX() + 2.0f * (x1 - this.lastAbs.getX()) / 3.0f, this.lastAbs.getY() + 2.0f * (y1 - this.lastAbs.getY()) / 3.0f, x2 + 2.0f * (x1 - x2) / 3.0f, y2 + 2.0f * (y1 - y2) / 3.0f, x2, y2);
            this.lastAbs.setX1(x1);
            this.lastAbs.setY1(y1);
            this.lastAbs.setPathSegType((short)8);
        }

        @Override
        public void curvetoQuadraticSmoothRel(float x2, float y2) throws ParseException {
            this.curvetoQuadraticSmoothAbs(this.lastAbs.getX() + x2, this.lastAbs.getY() + y2);
        }

        @Override
        public void curvetoQuadraticSmoothAbs(float x2, float y2) throws ParseException {
            if (this.lastAbs.getPathSegType() == 8) {
                this.curvetoQuadraticAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX1()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY1()), x2, y2);
            } else {
                this.curvetoQuadraticAbs(this.lastAbs.getX(), this.lastAbs.getY(), x2, y2);
            }
        }

        @Override
        public void arcRel(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x2, float y2) throws ParseException {
            this.arcAbs(rx, ry, xAxisRotation, largeArcFlag, sweepFlag, this.lastAbs.getX() + x2, this.lastAbs.getY() + y2);
        }

        @Override
        public void arcAbs(float rx, float ry, float xAxisRotation, boolean largeArcFlag, boolean sweepFlag, float x2, float y2) throws ParseException {
            if (rx == 0.0f || ry == 0.0f) {
                this.linetoAbs(x2, y2);
                return;
            }
            double x0 = this.lastAbs.getX();
            double y0 = this.lastAbs.getY();
            if (x0 == (double)x2 && y0 == (double)y2) {
                return;
            }
            Arc2D arc = ExtendedGeneralPath.computeArc(x0, y0, rx, ry, xAxisRotation, largeArcFlag, sweepFlag, x2, y2);
            if (arc == null) {
                return;
            }
            AffineTransform t = AffineTransform.getRotateInstance(Math.toRadians(xAxisRotation), arc.getCenterX(), arc.getCenterY());
            Shape s = t.createTransformedShape(arc);
            PathIterator pi = s.getPathIterator(new AffineTransform());
            float[] d = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            int i = -1;
            while (!pi.isDone()) {
                i = pi.currentSegment(d);
                switch (i) {
                    case 3: {
                        this.curvetoCubicAbs(d[0], d[1], d[2], d[3], d[4], d[5]);
                    }
                }
                pi.next();
            }
            this.lastAbs.setPathSegType((short)10);
        }
    }
}

