/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.CommonBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.export.ExportToHTMLDialog;
import com.intellij.codeInspection.export.HTMLExportUtil;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExportHTMLAction
extends AnAction
implements DumbAware {
    private final GroupNode[] myGroupNodes;
    @NonNls
    private static final String HTML = "HTML";
    @NonNls
    private static final String XML = "XML";
    private final DuplicatesRoot myRoot;

    ExportHTMLAction(DuplicatesRoot root) {
        super(InspectionsBundle.messagePointer((String)"action.ExportHTMLAction.text", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export);
        this.myGroupNodes = root.getChildren();
        this.myRoot = root;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ExportHTMLAction.$$$reportNull$$$0(0);
        }
        final Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(InspectionsBundle.message((String)"inspection.action.export.popup.title", (Object[])new Object[0]), new String[]{HTML, XML}){

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ExportHTMLAction.this.export(project2, Comparing.strEqual((String)selectedValue, (String)ExportHTMLAction.HTML)));
            }
        });
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            popup.showUnderneathOf(event.getComponent());
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    private void export(Project project2, boolean toHtml) {
        ExportToHTMLDialog exportToHTMLDialog = new ExportToHTMLDialog(project2, true);
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance((Project)project2);
        if (exportToHTMLSettings.OUTPUT_DIRECTORY == null) {
            exportToHTMLSettings.OUTPUT_DIRECTORY = PathManager.getHomePath() + File.separator + "inspections";
        }
        exportToHTMLDialog.reset();
        if (!exportToHTMLDialog.showAndGet()) {
            return;
        }
        exportToHTMLDialog.apply();
        Path outputDir = Paths.get(exportToHTMLSettings.OUTPUT_DIRECTORY, new String[0]);
        try {
            if (toHtml) {
                int groupIdx = 0;
                @NlsSafe StringBuffer groupFrameBuffer = new StringBuffer();
                for (GroupNode groupNode : this.myGroupNodes) {
                    String groupName = "group" + groupIdx++;
                    StringBuffer buffer = new StringBuffer();
                    for (CodeNode codeNode : groupNode.getChildren()) {
                        ExportHTMLAction.outputCodeFragment(project2, outputDir, groupName, buffer, codeNode);
                    }
                    @NlsSafe String groupFile = groupName + "-index.html";
                    HTMLExportUtil.writeFile((Path)outputDir, (String)groupFile, (Project)project2, w -> w.write(XmlStringUtil.wrapInHtml((CharSequence)buffer)));
                    groupFrameBuffer.append("<a href=\"").append(StringUtil.escapeXmlEntities((String)groupFile)).append("\" target=\"codeFragmentFrame\">").append(groupName).append(" (").append(groupNode.getTitle(false).getText()).append(")").append("</a>").append("<br>");
                }
                HTMLExportUtil.writeFile((Path)outputDir, (String)"groupIndex.html", (Project)project2, w -> w.write(XmlStringUtil.wrapInHtml((CharSequence)groupFrameBuffer)));
                ExportHTMLAction.outputMainFrame(project2, outputDir);
                if (exportToHTMLSettings.OPEN_IN_BROWSER) {
                    BrowserUtil.browse((File)outputDir.resolve("index.html").toFile());
                }
            } else {
                DuplocatorHashCallback.writeDuplicates(outputDir, project2, this.myRoot.getDuplicates());
            }
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)CommonBundle.getErrorTitle());
        }
    }

    private static void outputCodeFragment(Project project2, @NotNull Path outputDir, @NlsSafe String groupName, StringBuffer buffer, CodeNode codeNode) throws InvalidatedException {
        if (outputDir == null) {
            ExportHTMLAction.$$$reportNull$$$0(1);
        }
        PsiFragment codeNodeFragment = codeNode.getFragment();
        VirtualFile virtualFile = codeNode.getVirtualFile();
        TextRange range = codeNode.getTextRange();
        PsiFile file = codeNodeFragment.getFile();
        if (file == null) {
            return;
        }
        String fragment = range.substring(file.getText());
        String codeFragmentFile = groupName + "/" + virtualFile.getNameWithoutExtension() + codeNodeFragment.getStartOffset() + ".html";
        @NlsSafe StringBuffer fragmentBuf = new StringBuffer();
        fragmentBuf.append("<head><h4>");
        fragmentBuf.append(codeNode.getTitle(false).getText());
        fragmentBuf.append("</h4></head>");
        fragmentBuf.append("<body>");
        fragmentBuf.append(StringUtil.escapeXmlEntities((String)fragment).replace("\n", "<br>"));
        fragmentBuf.append("</body>");
        HTMLExportUtil.writeFile((Path)outputDir, (String)codeFragmentFile, (Project)project2, w -> w.write(XmlStringUtil.wrapInHtml((CharSequence)fragmentBuf)));
        @NlsSafe String link = "<a href=\"" + StringUtil.escapeXmlEntities((String)codeFragmentFile) + "\" target=\"elementFrame\">" + virtualFile.getPath() + "</a><br>";
        buffer.append(link);
    }

    private static void outputMainFrame(@NotNull Project project2, @NotNull Path outputDir) {
        if (project2 == null) {
            ExportHTMLAction.$$$reportNull$$$0(2);
        }
        if (outputDir == null) {
            ExportHTMLAction.$$$reportNull$$$0(3);
        }
        String title = DupLocatorBundle.message("duplicates.export.html.page.title", ApplicationNamesInfo.getInstance().getFullProductName());
        @NlsSafe String mainIndex = "<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD><FRAMESET cols=\"30%,70%\">  <FRAMESET rows=\"30%,70%\">    <FRAME src=\"groupIndex.html\" name=\"groupFrame\">    <FRAME src=\"group0-index.html\" name=\"codeFragmentFrame\">  </FRAMESET>  <FRAME src=\"empty.html\" name=\"elementFrame\"></FRAMESET></BODY></HTML";
        HTMLExportUtil.writeFile((Path)outputDir, (String)"index.html", (Project)project2, w -> w.write(mainIndex));
        HTMLExportUtil.writeFile((Path)outputDir, (String)"empty.html", (Project)project2, w -> w.write(""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/resultUI/ExportHTMLAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "outputCodeFragment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "outputMainFrame";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

