/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.accessibilityAudit.AccessibilityAuditManager;
import com.intellij.internal.inspector.accessibilityAudit.Severity;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.internal.inspector.components.InspectorWindow;
import com.intellij.internal.inspector.components.ValueCellRenderer;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class HierarchyTree
extends JTree
implements TreeSelectionListener {
    private static final int MAX_DEEPNESS_TO_DISCOVER_FIELD_NAME = 8;

    HierarchyTree(Component c) {
        this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
        this.setModel(HierarchyTree.buildModel(c));
        this.getSelectionModel().addTreeSelectionListener(this);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this);
        if (c instanceof JComponent && ClientProperty.get((Component)c, UiInspectorAction.CLICK_INFO) != null) {
            SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
        }
    }

    private static TreeModel buildModel(Component c) {
        return HierarchyTree.buildModel(c, false);
    }

    private static TreeModel buildModel(Component c, boolean accessibleModel) {
        Accessible axComponent;
        Component parent = null;
        if (accessibleModel && c instanceof Accessible) {
            axComponent = c.getAccessibleContext().getAccessibleParent();
            if (axComponent instanceof Component) {
                parent = (Component)((Object)axComponent);
            }
        } else {
            parent = c.getParent();
        }
        while (parent != null) {
            c = parent;
            if (accessibleModel && c instanceof Accessible) {
                axComponent = c.getAccessibleContext().getAccessibleParent();
                if (axComponent instanceof Component) {
                    parent = (Component)((Object)axComponent);
                    continue;
                }
                parent = null;
                continue;
            }
            parent = c.getParent();
        }
        return new DefaultTreeModel(ComponentNode.createComponentNode(c, accessibleModel));
    }

    public void resetModel(Component c, boolean accessibleModel) {
        this.setModel(HierarchyTree.buildModel(c, accessibleModel));
    }

    public void selectPath(@NotNull Component component) {
        if (component == null) {
            HierarchyTree.$$$reportNull$$$0(0);
        }
        this.selectPath(component, false);
    }

    public void selectPath(@NotNull Component component, boolean isAccessibleTree) {
        if (component == null) {
            HierarchyTree.$$$reportNull$$$0(1);
        }
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            TreePath row = this.getPathForRow(i);
            Object last = row.getLastPathComponent();
            if (!(last instanceof ComponentNode)) continue;
            ComponentNode node = (ComponentNode)last;
            if ((!isAccessibleTree || node.myAccessible != component) && (isAccessibleTree || node.myComponent != component)) continue;
            this.setSelectionPath(row);
            this.scrollPathToVisible(this.getSelectionPath());
            break;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object[] paths = this.getSelectionPaths();
        if (paths == null) {
            this.onComponentsChanged(Collections.emptyList());
            return;
        }
        List clickInfos = ContainerUtil.mapNotNull((Object[])paths, path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof ComponentNode && ((ComponentNode)node).getUserObject() instanceof List) {
                return (List)((ComponentNode)node).getUserObject();
            }
            return null;
        });
        if (!clickInfos.isEmpty()) {
            this.onClickInfoChanged((List)clickInfos.get(0));
            return;
        }
        List components = ContainerUtil.mapNotNull((Object[])paths, path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof ComponentNode) {
                return ((ComponentNode)node).getComponent();
            }
            return null;
        });
        this.onComponentsChanged(components);
    }

    public abstract void onClickInfoChanged(List<? extends PropertyBean> var1);

    public abstract void onComponentsChanged(List<? extends Component> var1);

    @Nullable
    private static Pair<Class<?>, String> getClassAndFieldName(Component component) {
        Container parent = component.getParent();
        for (int deepness = 1; parent != null && deepness <= 8; parent = parent.getParent(), ++deepness) {
            HashMap fields = new HashMap();
            for (Class<?> aClass = parent.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                for (Field field : aClass.getDeclaredFields()) {
                    fields.put(field, aClass);
                }
            }
            for (Map.Entry entry : fields.entrySet()) {
                try {
                    Field field = (Field)entry.getKey();
                    field.setAccessible(true);
                    if (field.get(parent) != component) continue;
                    return Pair.create((Object)((Class)entry.getValue()), (Object)field.getName());
                }
                catch (IllegalAccessException | InaccessibleObjectException exception) {
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/components/HierarchyTree", "selectPath"));
    }

    private static final class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;
        private final List<IconWithErrorCount> accessibilityAuditIcons = new ArrayList<IconWithErrorCount>();

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                ComponentTreeCellRenderer.$$$reportNull$$$0(0);
            }
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            Color background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null;
            boolean isRenderer = false;
            this.accessibilityAuditIcons.clear();
            if (value instanceof ComponentNode) {
                ComponentNode componentNode = (ComponentNode)value;
                isRenderer = componentNode.getUserObject() instanceof List;
                Component component = componentNode.getComponent();
                if (component != null && !selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                if (componentNode.isAccessibleNode) {
                    AccessibleContext ac = component != null ? component.getAccessibleContext() : componentNode.getAccessible().getAccessibleContext();
                    String simpleName = ac.getClass().getSimpleName();
                    if (StringUtil.isEmpty((String)simpleName)) {
                        this.append(ac.getClass().getName());
                    } else {
                        this.append(simpleName);
                    }
                    String axName = ac.getAccessibleName();
                    if (axName != null) {
                        this.append(" " + axName);
                    }
                } else if (component != null) {
                    this.append(UiInspectorUtil.getComponentName((Component)component));
                    Pair<Class<?>, String> class2field = HierarchyTree.getClassAndFieldName(component);
                    if (class2field != null) {
                        this.append("(" + (String)class2field.second + "@" + ((Class)class2field.first).getSimpleName() + ")");
                    }
                    this.append(": " + ValueCellRenderer.RectangleRenderer.toString(component.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    if (component.isOpaque()) {
                        this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (component.isDoubleBuffered()) {
                        this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (component instanceof UiDataProvider) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("ui-data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (component instanceof DataProvider) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (DataManagerImpl.getDataProviderEx((Object)component) != null) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("with data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                    componentNode.setText(this.toString());
                    this.setIcon(Icons.findIconFor(component));
                } else {
                    this.append(componentNode.myName);
                }
                AccessibilityAuditManager accessibilityAudit = componentNode.accessibilityAudit;
                List<UiInspectorAccessibilityInspection> accessibilityResult = accessibilityAudit.getFailedInspections();
                if (accessibilityAudit.isRunning()) {
                    int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
                    if (!accessibilityResult.isEmpty()) {
                        int warningCount = 0;
                        int recommendationCount = 0;
                        for (UiInspectorAccessibilityInspection inspection : accessibilityResult) {
                            if (inspection.getSeverity() == Severity.WARNING) {
                                ++warningCount;
                                continue;
                            }
                            if (inspection.getSeverity() != Severity.RECOMMENDATION) continue;
                            ++recommendationCount;
                        }
                        if (warningCount > 0) {
                            this.accessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.Warning, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.Warning.getIconHeight())), warningCount));
                        }
                        if (recommendationCount > 0) {
                            this.accessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.Information, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.Information.getIconHeight())), recommendationCount));
                        }
                    } else {
                        this.accessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.GreenCheckmark, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.GreenCheckmark.getIconHeight())), 0));
                    }
                }
            }
            if (isRenderer) {
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.accessibilityAuditIcons.isEmpty()) {
                return;
            }
            GraphicsUtil.setupAntialiasing((Graphics)g);
            int componentHeight = this.getSize().height;
            int iconX = this.getPreferredSize().width;
            int iconSpacing = this.getIconTextGap() * 2;
            FontMetrics fontMetrics = g.getFontMetrics();
            int textHeight = fontMetrics.getHeight();
            g.setColor(UIUtil.getTreeForeground());
            for (IconWithErrorCount entry : this.accessibilityAuditIcons) {
                Icon icon = entry.getIcon();
                int errorCount = entry.getErrorCount();
                int iconHeight = icon.getIconHeight();
                int iconY = (componentHeight - iconHeight) / 2;
                icon.paintIcon((Component)((Object)this), g, iconX, iconY);
                if (errorCount != 0) {
                    int textX = iconX + icon.getIconWidth() + iconSpacing;
                    int textY = (componentHeight - textHeight) / 2 + fontMetrics.getAscent();
                    g.drawString(String.valueOf(errorCount), textX, textY);
                    iconX = textX + fontMetrics.stringWidth(String.valueOf(errorCount)) + iconSpacing;
                    continue;
                }
                iconX += icon.getIconWidth() + iconSpacing;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/components/HierarchyTree$ComponentTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    public static final class ComponentNode
    extends DefaultMutableTreeNode {
        private final Component myComponent;
        private final Accessible myAccessible;
        private final String myName;
        private final boolean isAccessibleNode;
        private final AccessibilityAuditManager accessibilityAudit;
        String myText;

        public static ComponentNode createAccessibleNode(@NotNull Accessible accessible) {
            if (accessible == null) {
                ComponentNode.$$$reportNull$$$0(0);
            }
            String name = accessible.getClass().getName();
            JComponent component = (JComponent)ObjectUtils.tryCast((Object)accessible, JComponent.class);
            ComponentNode node = new ComponentNode(component, accessible, name, true);
            TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareAccessibleChildren(accessible));
            return node;
        }

        public static ComponentNode createComponentNode(@NotNull Component component) {
            if (component == null) {
                ComponentNode.$$$reportNull$$$0(1);
            }
            return ComponentNode.createComponentNode(component, false);
        }

        public static ComponentNode createComponentNode(@NotNull Component component, boolean isAccessibleComponent) {
            if (component == null) {
                ComponentNode.$$$reportNull$$$0(2);
            }
            String name = component.getClass().getName();
            Accessible accessible = (Accessible)ObjectUtils.tryCast((Object)component, Accessible.class);
            ComponentNode node = new ComponentNode(component, accessible, name, isAccessibleComponent);
            if (isAccessibleComponent) {
                TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareAccessibleChildren(accessible));
            } else {
                TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareComponentChildren(component));
            }
            return node;
        }

        public static ComponentNode createNamedNode(@NotNull String name, @Nullable Component component) {
            if (name == null) {
                ComponentNode.$$$reportNull$$$0(3);
            }
            Accessible accessible = (Accessible)ObjectUtils.tryCast((Object)component, Accessible.class);
            ComponentNode node = new ComponentNode(component, accessible, name, false);
            TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareComponentChildren(component));
            return node;
        }

        public void runAccessibilityTests(@NotNull AccessibleContext ac) {
            if (ac == null) {
                ComponentNode.$$$reportNull$$$0(4);
            }
            this.accessibilityAudit.runAccessibilityTests(ac);
        }

        public void clearAccessibilityTestsResult() {
            this.accessibilityAudit.clearAccessibilityTestsResult();
        }

        private ComponentNode(@Nullable Component component, @Nullable Accessible accessible, @NotNull String name, boolean isAccessibleComponent) {
            if (name == null) {
                ComponentNode.$$$reportNull$$$0(5);
            }
            super(component);
            this.myComponent = component;
            this.myAccessible = accessible;
            this.myName = name;
            this.isAccessibleNode = isAccessibleComponent;
            this.accessibilityAudit = new AccessibilityAuditManager();
        }

        private static List<TreeNode> prepareAccessibleChildren(@Nullable Accessible a) {
            AccessibleContext ac;
            ArrayList<TreeNode> result2 = new ArrayList<TreeNode>();
            if (a != null && (ac = a.getAccessibleContext()) != null) {
                int count = ac.getAccessibleChildrenCount();
                for (int i = 0; i < count; ++i) {
                    Accessible axComponent = a.getAccessibleContext().getAccessibleChild(i);
                    result2.add(ComponentNode.createAccessibleNode(axComponent));
                }
            }
            return result2;
        }

        public Component getComponent() {
            return this.myComponent;
        }

        public Accessible getAccessible() {
            return this.myAccessible;
        }

        @Override
        public String toString() {
            if (this.myText != null) {
                return this.myText;
            }
            return this.myName;
        }

        private void setText(String value) {
            this.myText = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof ComponentNode && ((ComponentNode)obj).getComponent() == this.getComponent();
        }

        private static List<TreeNode> prepareComponentChildren(Component parent) {
            Component[] node;
            ArrayList<TreeNode> result2 = new ArrayList<TreeNode>();
            if (parent instanceof JComponent && (node = (Component[])ClientProperty.get((Component)parent, UiInspectorAction.CLICK_INFO)) != null) {
                result2.add((TreeNode)node);
            }
            if (parent instanceof Container) {
                for (Component component : ((Container)parent).getComponents()) {
                    result2.add(ComponentNode.createComponentNode(component));
                }
            }
            if (parent instanceof Window) {
                Window[] children;
                for (Window child : children = ((Window)parent).getOwnedWindows()) {
                    if (child instanceof InspectorWindow) continue;
                    result2.add(ComponentNode.createComponentNode(child));
                }
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessible";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ac";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/components/HierarchyTree$ComponentNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAccessibleNode";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createComponentNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNamedNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runAccessibilityTests";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Icons {
        private static final Map<Class<?>, Icon> COMPONENT_MAPPING = new HashMap();
        @NotNull
        static final Icon Kotlin;
        @NotNull
        static final Icon Unknown;

        Icons() {
        }

        @NotNull
        private static Icon load(@NotNull String path) {
            if (path == null) {
                Icons.$$$reportNull$$$0(0);
            }
            return Icons.load(path, null);
        }

        @NotNull
        private static Icon load(@NotNull String path, Class<?> cls) {
            if (path == null) {
                Icons.$$$reportNull$$$0(1);
            }
            Icon icon = IconLoader.getIcon((String)("com/intellij/internal/inspector/icons/" + path), (ClassLoader)UiInspectorAction.class.getClassLoader());
            if (cls != null) {
                COMPONENT_MAPPING.put(cls, icon);
            }
            Icon icon2 = icon;
            if (icon2 == null) {
                Icons.$$$reportNull$$$0(2);
            }
            return icon2;
        }

        public static Icon findIconFor(Component component) {
            Icon icon = null;
            for (Class<?> aClass = component.getClass(); icon == null && aClass != null; aClass = aClass.getSuperclass()) {
                icon = COMPONENT_MAPPING.get(aClass);
            }
            if (icon == null) {
                icon = Unknown;
            }
            if (ComponentUtil.findParentByCondition((Component)component, c -> c.getClass() == DialogPanel.class) != null) {
                Icon kotlinIcon = ((ScalableIcon)Kotlin).scale(0.5f);
                return new RowIcon(new Icon[]{icon, IconUtil.toSize((Icon)kotlinIcon, (int)icon.getIconWidth(), (int)icon.getIconHeight())});
            }
            return icon;
        }

        static {
            Icons.load("button.svg", JButton.class);
            Icons.load("checkBox.svg", JCheckBox.class);
            Icons.load("comboBox.svg", JComboBox.class);
            Icons.load("editorPane.svg", JEditorPane.class);
            Icons.load("formattedTextField.svg", JFormattedTextField.class);
            Icons.load("label.svg", JLabel.class);
            Icons.load("list.svg", JList.class);
            Icons.load("panel.svg", JPanel.class);
            Icons.load("passwordField.svg", JPasswordField.class);
            Icons.load("progressbar.svg", JProgressBar.class);
            Icons.load("radioButton.svg", JRadioButton.class);
            Icons.load("scrollbar.svg", JScrollBar.class);
            Icons.load("scrollPane.svg", JScrollPane.class);
            Icons.load("separator.svg", JSeparator.class);
            Icons.load("slider.svg", JSlider.class);
            Icons.load("spinner.svg", JSpinner.class);
            Icons.load("splitPane.svg", JSplitPane.class);
            Icons.load("tabbedPane.svg", JTabbedPane.class);
            Icons.load("table.svg", JTable.class);
            Icons.load("textArea.svg", JTextArea.class);
            Icons.load("textField.svg", JTextField.class);
            Icons.load("textPane.svg", JTextPane.class);
            Icons.load("toolbar.svg", JToolBar.class);
            Icons.load("tree.svg", JTree.class);
            Kotlin = Icons.load("kotlin.svg");
            Unknown = Icons.load("unknown.svg");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/HierarchyTree$Icons";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/HierarchyTree$Icons";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class IconWithErrorCount {
        private final Icon icon;
        private final int errorCount;

        private IconWithErrorCount(Icon icon, int errorCount) {
            this.icon = icon;
            this.errorCount = errorCount;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

